/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Report;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;
import megamek.common.options.PilotOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pilot
implements Serializable {
    private String name;
    private int gunnery;
    private int piloting;
    private int hits;
    private boolean unconscious;
    private boolean doomed;
    private boolean dead;
    private boolean ejected;
    private int rollsNeeded;
    private boolean koThisRound;
    private PilotOptions options = new PilotOptions();
    public static final int DEATH = 6;

    public Pilot() {
        this("Unnamed", 4, 5);
    }

    public Pilot(String string, int n, int n2) {
        this.name = string;
        this.gunnery = n;
        this.piloting = n2;
        this.hits = 0;
        this.unconscious = false;
        this.dead = false;
        this.rollsNeeded = 0;
        this.koThisRound = false;
        this.options.initialize();
    }

    public String getName() {
        return this.name;
    }

    public int getGunnery() {
        return this.gunnery;
    }

    public int getPiloting() {
        return this.piloting;
    }

    public int getHits() {
        return this.hits;
    }

    public void setGunnery(int n) {
        this.gunnery = n;
    }

    public void setPiloting(int n) {
        this.piloting = n;
    }

    public void setHits(int n) {
        if (!this.ejected) {
            this.hits = n;
        }
    }

    public boolean isUnconscious() {
        return this.unconscious;
    }

    public void setUnconscious(boolean bl) {
        this.unconscious = bl;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setDead(boolean bl) {
        if (!this.ejected) {
            this.dead = bl;
            if (bl) {
                this.rollsNeeded = 0;
                this.hits = 6;
            }
        }
    }

    public boolean isDoomed() {
        return this.doomed;
    }

    public void setDoomed(boolean bl) {
        if (!this.ejected) {
            this.doomed = bl;
            if (this.doomed) {
                this.rollsNeeded = 0;
                this.hits = 6;
            }
        }
    }

    public boolean isActive() {
        return !this.unconscious && !this.dead;
    }

    public int getRollsNeeded() {
        if (!this.ejected) {
            return this.rollsNeeded;
        }
        return 0;
    }

    public void setRollsNeeded(int n) {
        if (!this.ejected && !this.doomed) {
            this.rollsNeeded = n;
        }
    }

    public boolean isKoThisRound() {
        return this.koThisRound;
    }

    public void setKoThisRound(boolean bl) {
        this.koThisRound = bl;
    }

    public void setOptions(PilotOptions pilotOptions) {
        this.options = pilotOptions;
    }

    public PilotOptions getOptions() {
        return this.options;
    }

    public void clearAdvantages() {
        Enumeration enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = (IOptionGroup)enumeration.nextElement();
            if (!iOptionGroup.getKey().equalsIgnoreCase("lvl3Advantages")) continue;
            Enumeration enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = (IOption)enumeration2.nextElement();
                iOption.clearValue();
            }
        }
    }

    public int countAdvantages() {
        int n = 0;
        Enumeration enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = (IOptionGroup)enumeration.nextElement();
            if (!iOptionGroup.getKey().equalsIgnoreCase("lvl3Advantages")) continue;
            Enumeration enumeration2 = iOptionGroup.getOptions();
            while (enumeration2.hasMoreElements()) {
                IOption iOption = (IOption)enumeration2.nextElement();
                if (!iOption.booleanValue()) continue;
                ++n;
            }
        }
        return n;
    }

    public Enumeration getAdvantages() {
        Enumeration enumeration = this.options.getGroups();
        while (enumeration.hasMoreElements()) {
            IOptionGroup iOptionGroup = (IOptionGroup)enumeration.nextElement();
            if (!iOptionGroup.getKey().equalsIgnoreCase("lvl3Advantages")) continue;
            return iOptionGroup.getOptions();
        }
        return new Vector().elements();
    }

    public String getAdvantageList(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (null == string) {
            string = "";
        }
        Enumeration enumeration = this.getAdvantages();
        while (enumeration.hasMoreElements()) {
            IOption iOption = (IOption)enumeration.nextElement();
            if (!iOption.booleanValue()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(iOption.getName());
            if (iOption.getType() != 3 && iOption.getType() != 4 && iOption.getType() != 1) continue;
            stringBuffer.append(" ").append(iOption.stringValue());
        }
        return stringBuffer.toString();
    }

    public static String parseAdvantageName(String string) {
        int n = (string = string.trim()).indexOf(" ");
        if (n == -1) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    public static Object parseAdvantageValue(String string) {
        Object object;
        int n = (string = string.trim()).indexOf(" ");
        if (n == -1) {
            return new Boolean(true);
        }
        String string2 = string.substring(n + 1, string.length());
        try {
            object = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            object = string2;
        }
        return object;
    }

    public String getDesc() {
        String string = new String(this.name);
        if (this.hits > 0) {
            string = string + " (" + this.hits + " hit(s)";
            if (this.isUnconscious()) {
                string = string + " [ko]";
            } else if (this.isDead()) {
                string = string + " [dead]";
            }
            string = string + ")";
        } else if (this.isUnconscious()) {
            string = string + " [ko]";
        } else if (this.isDead()) {
            string = string + " [dead]";
        }
        return string;
    }

    public Vector<Report> getDescVector(boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report();
        report.type = 0;
        report.add(this.name);
        if (bl) {
            report.messageId = 7050;
            report.add(this.getGunnery());
        } else {
            report.messageId = 7045;
            report.add(this.getGunnery());
            report.add(this.getPiloting());
        }
        if (this.hits > 0 || this.isUnconscious() || this.isDead()) {
            Report report2 = new Report();
            report2.type = 0;
            if (this.hits > 0) {
                report2.messageId = 7055;
                report2.add(this.hits);
                if (this.isUnconscious()) {
                    report2.messageId = 7060;
                    report2.choose(true);
                } else if (this.isDead()) {
                    report2.messageId = 7060;
                    report2.choose(false);
                }
            } else if (this.isUnconscious()) {
                report2.messageId = 7065;
                report2.choose(true);
            } else if (this.isDead()) {
                report2.messageId = 7065;
                report2.choose(false);
            }
            report.newlines = 0;
            vector.addElement(report);
            vector.addElement(report2);
        } else {
            vector.addElement(report);
        }
        return vector;
    }

    public boolean isCustom() {
        return this.gunnery != 4 || this.piloting != 5;
    }

    public double getBVSkillMultiplier() {
        double d = 1.0;
        d = this.gunnery < 4 ? (d += 0.2 * (double)(4 - this.gunnery)) : (d += 0.1 * (double)(4 - this.gunnery));
        return d += 0.05 * (double)(5 - this.piloting);
    }

    public int modifyPhysicalDamagaForMeleeSpecialist() {
        if (!this.getOptions().booleanOption("melee_specialist")) {
            return 0;
        }
        return 1;
    }

    public boolean hasEdgeRemaining() {
        return this.getOptions().intOption("edge") > 0;
    }

    public void decreaseEdge() {
        IOption iOption = this.getOptions().getOption("edge");
        iOption.setValue((Integer)iOption.getValue() - 1);
    }

    public boolean isEjected() {
        return this.ejected;
    }

    public void setEjected(boolean bl) {
        this.ejected = bl;
    }
}

