/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.LocationFullException;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.Report;
import megamek.common.WeaponType;
import megamek.common.preference.PreferenceManager;

public class Protomech
extends Entity
implements Serializable {
    public static final int NUM_PMECH_LOCATIONS = 6;
    public static final String[] LOCATION_NAMES = new String[]{"Head", "Torso", "Right Arm", "Left Arm", "Legs", "Main Gun"};
    public static final String[] LOCATION_ABBRS = new String[]{"HD", "T", "RA", "LA", "L", "MG"};
    private boolean bHasMainGun;
    private boolean bHasRArmGun;
    private boolean bHasLArmGun;
    private boolean bHasTorsoAGun;
    private boolean bHasTorsoBGun;
    private int TorsoAGunNum;
    private int TorsoBGunNum;
    private int[] PilotDamageTaken = new int[]{0, 0, 0, 0, 0, 0};
    private int myBV = 0;
    private boolean m_bHasNoMainGun = false;
    public static final int LOC_HEAD = 0;
    public static final int LOC_TORSO = 1;
    public static final int LOC_RARM = 2;
    public static final int LOC_LARM = 3;
    public static final int LOC_LEG = 4;
    public static final int LOC_MAINGUN = 5;
    public static final int LOC_NMISS = 6;
    public static final int SYSTEM_ARMCRIT = 0;
    public static final int SYSTEM_LEGCRIT = 1;
    public static final int SYSTEM_HEADCRIT = 2;
    public static final int SYSTEM_TORSOCRIT = 3;
    public static final int SYSTEM_TORSO_WEAPON_A = 4;
    public static final int SYSTEM_TORSO_WEAPON_B = 5;
    private static final int[] NUM_OF_SLOTS = new int[]{2, 3, 2, 2, 3, 0};
    public static final int[] POSSIBLE_PILOT_DAMAGE = new int[]{1, 3, 1, 1, 1, 0};
    public static final String[] systemNames = new String[]{"Arm", "Leg", "Head", "Torso"};

    public Protomech() {
        this.setCritical(0, 0, new CriticalSlot(0, 2));
        this.setCritical(0, 1, new CriticalSlot(0, 2));
        this.setCritical(2, 0, new CriticalSlot(0, 0));
        this.setCritical(2, 1, new CriticalSlot(0, 0));
        this.setCritical(3, 0, new CriticalSlot(0, 0));
        this.setCritical(3, 1, new CriticalSlot(0, 0));
        this.setCritical(1, 0, new CriticalSlot(0, 3));
        this.setCritical(1, 1, new CriticalSlot(0, 3));
        this.setCritical(1, 2, new CriticalSlot(0, 3));
        this.setCritical(4, 0, new CriticalSlot(0, 1));
        this.setCritical(4, 1, new CriticalSlot(0, 1));
        this.setCritical(4, 2, new CriticalSlot(0, 1));
        this.bHasMainGun = false;
        this.bHasRArmGun = false;
        this.bHasLArmGun = false;
        this.bHasTorsoAGun = false;
        this.bHasTorsoBGun = false;
        this.m_bHasNoMainGun = true;
    }

    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    public int getPilotDamageTaken(int n) {
        return this.PilotDamageTaken[n];
    }

    public Mounted getTorsoWeapon(boolean bl) {
        Mounted mounted = null;
        if (bl && this.bHasTorsoAGun) {
            mounted = this.getEquipment(this.TorsoAGunNum);
        } else if (!bl && this.bHasTorsoBGun) {
            mounted = this.getEquipment(this.TorsoBGunNum);
        }
        return mounted;
    }

    public void setPilotDamageTaken(int n, int n2) {
        this.PilotDamageTaken[n] = n2;
    }

    public PilotingRollData getBasePilotingRoll() {
        return new PilotingRollData(this.getId(), -2147483647, "Protomeks never take PSRs.");
    }

    public boolean shaded(int n, int n2) {
        switch (n) {
            case 0: 
            case 2: 
            case 3: {
                return 2 == n2;
            }
            case 1: {
                return 0 < n2;
            }
            case 5: 
            case 6: {
                return false;
            }
            case 4: {
                return 3 == n2;
            }
        }
        return false;
    }

    public int getWalkMP(boolean bl) {
        int n = this.getOriginalWalkMP();
        int n2 = this.getCritsHit(4);
        int n3 = bl ? this.applyGravityEffectsOnMP(n) : n;
        if (n3 < n) {
            n = n3;
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                --n;
                break;
            }
            case 2: {
                n /= 2;
                break;
            }
            case 3: {
                n = 0;
            }
        }
        if (this.game != null) {
            int n4 = this.game.getTemperatureDifference();
            return Math.max(n - n4, 0);
        }
        return n;
    }

    public int getCritsHit(int n) {
        int n2 = 0;
        int n3 = this.getNumberOfCriticals(n);
        for (int i = 0; i < n3; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (!criticalSlot.isDamaged() && !criticalSlot.isBreached()) continue;
            ++n2;
        }
        return n2;
    }

    public static int getInnerLocation(int n) {
        return 1;
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        return pilotingRollData;
    }

    public int getNumberOfCriticals(int n) {
        switch (n) {
            case 5: {
                return 0;
            }
            case 0: 
            case 2: 
            case 3: {
                return 2;
            }
            case 1: 
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    public void newRound(int n) {
        this.setSecondaryFacing(this.getFacing());
        super.newRound(n);
    }

    public int getJumpMP() {
        int n = this.jumpMP;
        int n2 = this.getCritsHit(1);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                if (n <= 0) break;
                --n;
                break;
            }
            case 2: {
                n /= 2;
            }
        }
        if (this.applyGravityEffectsOnMP(n) > n) {
            return n;
        }
        return this.applyGravityEffectsOnMP(n);
    }

    public int getJumpMPWithTerrain() {
        if (this.getPosition() == null) {
            return this.getJumpMP();
        }
        int n = this.game.getBoard().getHex(this.getPosition()).terrainLevel(4);
        if (n <= 0 || this.getElevation() >= 0) {
            return this.getJumpMP();
        }
        return 0;
    }

    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    public int getHeatCapacity() {
        return 999;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public String getMovementString(int n) {
        switch (n) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Walked";
            }
            case 2: {
                return "Ran";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 1: {
                return "W";
            }
            case 2: {
                return "R";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    public boolean canChangeSecondaryFacing() {
        return this.getCritsHit(4) <= 2;
    }

    public int getEngineCritHeat() {
        return 0;
    }

    public boolean isValidSecondaryFacing(int n) {
        int n2 = n - this.getFacing();
        if (this.canChangeSecondaryFacing()) {
            return n2 == 0 || n2 == 1 || n2 == -1 || n2 == -5;
        }
        return n2 == 0;
    }

    public int clipSecondaryFacing(int n) {
        if (this.isValidSecondaryFacing(n)) {
            return n;
        }
        int n2 = (n + (6 - this.getFacing())) % 6;
        return n2 >= 3 ? (this.getFacing() + 5) % 6 : (this.getFacing() + 1) % 6;
    }

    public boolean hasRearArmor(int n) {
        return false;
    }

    public int getRunMPwithoutMASC(boolean bl) {
        return this.getRunMP(bl);
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.isRearMounted()) {
            return 4;
        }
        switch (mounted.getLocation()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 5: {
                return 7;
            }
        }
        return 0;
    }

    public boolean isSecondaryArcWeapon(int n) {
        return true;
    }

    public HitData rollHitLocation(int n, int n2) {
        return this.rollHitLocation(n, n2, -1, 0);
    }

    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        int n5 = -1;
        if (n3 != -1 && n4 == 1 && 5 < (n5 = Compute.d6(2)) && n5 < 9) {
            return new HitData(n3, n2 == 1, true);
        }
        n5 = Compute.d6(2);
        try {
            PrintWriter printWriter = PreferenceManager.getClientPreferences().getMekHitLocLog();
            if (printWriter != null) {
                printWriter.print(n);
                printWriter.print("\t");
                printWriter.print(n2);
                printWriter.print("\t");
                printWriter.println(n5);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        switch (n5) {
            case 2: {
                return new HitData(5);
            }
            case 3: 
            case 11: {
                return new HitData(6);
            }
            case 4: {
                return new HitData(2);
            }
            case 5: 
            case 9: {
                return new HitData(4);
            }
            case 6: 
            case 7: 
            case 8: {
                return new HitData(1);
            }
            case 10: {
                return new HitData(2);
            }
            case 12: {
                return new HitData(0);
            }
        }
        return null;
    }

    public boolean canTransferCriticals(int n) {
        return false;
    }

    public HitData getTransferLocation(HitData hitData) {
        switch (hitData.getLocation()) {
            case 6: {
                return new HitData(-1);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new HitData(1, hitData.isRear());
            }
        }
        return new HitData(-2);
    }

    public int getDependentLocation(int n) {
        return -1;
    }

    public void setInternal(int n, int n2, int n3, int n4, int n5) {
        this.initializeInternal(n, 0);
        this.initializeInternal(n2, 1);
        this.initializeInternal(n3, 2);
        this.initializeInternal(n3, 3);
        this.initializeInternal(n4, 4);
        this.initializeInternal(n5, 5);
    }

    public void autoSetInternal() {
        int n = this.hasMainGun() ? 1 : -1;
        switch ((int)this.weight) {
            case 2: {
                this.setInternal(1, 2, 1, 2, n);
                break;
            }
            case 3: {
                this.setInternal(1, 3, 1, 2, n);
                break;
            }
            case 4: {
                this.setInternal(1, 4, 1, 3, n);
                break;
            }
            case 5: {
                this.setInternal(1, 5, 1, 3, n);
                break;
            }
            case 6: {
                this.setInternal(2, 6, 2, 4, n);
                break;
            }
            case 7: {
                this.setInternal(2, 7, 2, 4, n);
                break;
            }
            case 8: {
                this.setInternal(2, 8, 2, 5, n);
                break;
            }
            case 9: {
                this.setInternal(2, 9, 2, 5, n);
            }
        }
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n) throws LocationFullException {
        return this.addEquipment(equipmentType, n, false, -1);
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n, boolean bl) throws LocationFullException {
        Mounted mounted = new Mounted(this, equipmentType);
        this.addEquipment(mounted, n, bl, -1);
        return mounted;
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n, boolean bl, int n2) throws LocationFullException {
        Mounted mounted = new Mounted(this, equipmentType);
        this.addEquipment(mounted, n, bl, n2);
        return mounted;
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl, int n2) throws LocationFullException {
        if (mounted.getType() instanceof AmmoType && -1 != n2) {
            mounted.setShotsLeft(n2);
            super.addEquipment(mounted, n, bl);
            return;
        }
        if (mounted.getType() instanceof WeaponType) {
            switch (n) {
                case 0: 
                case 4: 
                case 6: {
                    throw new LocationFullException("Weapon " + mounted.getName() + " can't be mounted in " + this.getLocationAbbr(n));
                }
                case 5: {
                    if (this.bHasMainGun) {
                        throw new LocationFullException("Already has Main Gun");
                    }
                    this.bHasMainGun = true;
                    mounted.setLocation(n, bl);
                    this.equipmentList.add(mounted);
                    this.weaponList.add(mounted);
                    break;
                }
                case 3: {
                    if (this.bHasLArmGun) {
                        throw new LocationFullException("Already has LArm Gun");
                    }
                    this.bHasLArmGun = true;
                    mounted.setLocation(n, bl);
                    this.equipmentList.add(mounted);
                    this.weaponList.add(mounted);
                    break;
                }
                case 2: {
                    if (this.bHasRArmGun) {
                        throw new LocationFullException("Already has RArm Gun");
                    }
                    this.bHasRArmGun = true;
                    mounted.setLocation(n, bl);
                    this.equipmentList.add(mounted);
                    this.weaponList.add(mounted);
                    break;
                }
                case 1: {
                    if (this.bHasTorsoAGun) {
                        if (this.bHasTorsoBGun) {
                            throw new LocationFullException("Already has both torso guns");
                        }
                        this.bHasTorsoBGun = true;
                        mounted.setLocation(n, bl);
                        this.equipmentList.add(mounted);
                        this.weaponList.add(mounted);
                        this.TorsoBGunNum = this.getEquipmentNum(mounted);
                        break;
                    }
                    this.bHasTorsoAGun = true;
                    mounted.setLocation(n, bl);
                    this.equipmentList.add(mounted);
                    this.weaponList.add(mounted);
                    this.TorsoAGunNum = this.getEquipmentNum(mounted);
                }
            }
        } else {
            super.addEquipment(mounted, n, bl);
        }
    }

    public int calculateBattleValue() {
        if (this.myBV > 0) {
            double d = this.crew.getBVSkillMultiplier();
            return (int)(d * (double)this.myBV);
        }
        double d = 0.0;
        double d2 = 0.0;
        d += (double)this.getTotalArmor();
        d += (double)(this.getTotalInternal() / 2);
        double d3 = 0.0;
        for (Mounted object2 : this.getEquipment()) {
            EquipmentType d4 = object2.getType();
            if (object2.isDestroyed() || !(d4 instanceof WeaponType && d4.hasFlag(0x1000000L) || d4 instanceof AmmoType && ((AmmoType)d4).getAmmoType() == 14) && !d4.hasFlag(1024L)) continue;
            d3 += d4.getBV(this);
        }
        d += d3;
        d += (double)this.weight;
        int n = Compute.getTargetMovementModifier(this.getOriginalRunMP(), false, false).getValue();
        if (n > 5) {
            n = 5;
        }
        double[] dArray = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5};
        d *= dArray[n] + 0.1;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType d9 = (WeaponType)mounted.getType();
            double mounted2 = d9.getBV(this);
            if (mounted.isDestroyed() || d9.hasFlag(0x1000000L)) continue;
            d5 += mounted2;
        }
        if (d5 > d6) {
            d4 += d5;
            d4 += d6 * 0.5;
        } else {
            d4 += d6;
            d4 += d5 * 0.5;
        }
        double d7 = 0.0;
        for (Mounted mounted : this.getAmmo()) {
            AmmoType d10 = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || d10.getAmmoType() == 14) continue;
            d7 += d10.getBV(this);
        }
        d4 += d7;
        double d8 = this.getOriginalRunMP() - 5;
        d8 /= 10.0;
        d8 += 1.0;
        d8 = Math.pow(d8, 1.2);
        d8 = (double)Math.round(d8 * 100.0) / 100.0;
        d2 = d4 * d8;
        if (this.getsTagBVPenalty()) {
            d += 200.0;
        }
        if (this.getsHomingBVPenalty()) {
            d += 200.0;
        }
        double d9 = this.crew.getBVSkillMultiplier();
        int n2 = (int)Math.round(d + d2);
        int n3 = (int)Math.round((double)n2 * d9);
        return n3;
    }

    public Vector victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7030);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        vector.addAll(this.crew.getDescVector(true));
        report = new Report(7070, 0);
        report.add(this.getKillNumber());
        vector.addElement(report);
        if (this.isDestroyed()) {
            Entity entity = this.game.getEntity(this.killerId);
            if (entity == null) {
                entity = this.game.getOutOfGameEntity(this.killerId);
            }
            if (entity != null) {
                report = new Report(7072, 0);
                report.addDesc(entity);
            } else {
                report = new Report(7073, 0);
            }
            vector.addElement(report);
        }
        report.newlines = 2;
        return vector;
    }

    public int getMaxElevationChange() {
        return 1;
    }

    public int getArmor(int n, boolean bl) {
        if (n == 6) {
            return -1;
        }
        return super.getArmor(n, bl);
    }

    public int getInternal(int n) {
        if (n == 6) {
            return -1;
        }
        return super.getInternal(n);
    }

    protected String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String getLocationAbbr(int n) {
        if (n == 6) {
            return "a near miss";
        }
        return super.getLocationAbbr(n);
    }

    public void setBattleValue(int n) {
        this.myBV = n;
    }

    public boolean hasMainGun() {
        return !this.m_bHasNoMainGun;
    }

    public void setHasMainGun(boolean bl) {
        this.m_bHasNoMainGun = !bl;
    }

    public int locations() {
        if (this.m_bHasNoMainGun) {
            return 5;
        }
        return 6;
    }

    public void setCrew(Pilot pilot) {
        super.setCrew(pilot);
        this.getCrew().setPiloting(5);
    }

    public boolean canCharge() {
        return false;
    }

    public boolean canDFA() {
        return false;
    }

    public double getCost() {
        double d = 0.0;
        d += 500000.0;
        d += 75000.0;
        d += (double)(2000.0f * this.weight);
        d += (double)(2000.0f * this.weight);
        d += (double)(400.0f * this.weight);
        d += (double)(360.0f * this.weight);
        d += (double)(540.0f * this.weight);
        if (this.getEngine() != null) {
            d += (double)(5000.0f * this.weight * (float)this.getEngine().getRating() / 75.0f);
        }
        d += (double)(this.weight * (float)this.getJumpMP() * (float)this.getJumpMP() * 200.0f);
        d += (double)(this.getTotalArmor() * 625);
        return d *= 1.0 + (double)this.weight / 100.0;
    }

    public boolean doomedInVacuum() {
        return false;
    }

    public boolean hasActiveEiCockpit() {
        return super.hasActiveEiCockpit() && this.getCritsHit(0) == 0;
    }

    public boolean canAssaultDrop() {
        return true;
    }

    public boolean isNuclearHardened() {
        return true;
    }
}

