/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmorHandlesTank;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.LocationFullException;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;
import megamek.common.Report;
import megamek.common.WeaponType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tank
extends Entity
implements Serializable {
    private boolean m_bHasNoTurret = false;
    private boolean m_bTurretLocked = false;
    private int m_nTurretOffset = 0;
    private int m_nStunnedTurns = 0;
    private int m_nJammedTurns = 0;
    private Mounted m_jammedGun = null;
    private boolean m_bImmobile = false;
    private boolean m_bImmobileHit = false;
    private int burningLocations = 0;
    protected int movementDamage = 0;
    private boolean infernoFire = false;
    public static final int LOC_BODY = 0;
    public static final int LOC_FRONT = 1;
    public static final int LOC_RIGHT = 2;
    public static final int LOC_LEFT = 3;
    public static final int LOC_REAR = 4;
    public static final int LOC_TURRET = 5;
    public static final int CRIT_NONE = -1;
    public static final int CRIT_DRIVER = 0;
    public static final int CRIT_WEAPON_JAM = 1;
    public static final int CRIT_WEAPON_DESTROYED = 2;
    public static final int CRIT_STABILIZER = 3;
    public static final int CRIT_SENSOR = 4;
    public static final int CRIT_COMMANDER = 5;
    public static final int CRIT_CREW_KILLED = 6;
    public static final int CRIT_CREW_STUNNED = 7;
    public static final int CRIT_CARGO = 8;
    public static final int CRIT_ENGINE = 9;
    public static final int CRIT_FUEL_TANK = 10;
    public static final int CRIT_AMMO = 11;
    public static final int CRIT_TURRET_JAM = 12;
    public static final int CRIT_TURRET_LOCK = 13;
    public static final int CRIT_TURRET_DESTROYED = 14;
    private static final int[] NUM_OF_SLOTS = new int[]{25, 25, 25, 25, 25, 25};
    protected static String[] LOCATION_ABBRS = new String[]{"BD", "FR", "RS", "LS", "RR", "TU"};
    protected static String[] LOCATION_NAMES = new String[]{"Body", "Front", "Right", "Left", "Rear", "Turret"};
    private int armorType = 0;
    private int structureType = 0;
    private int sensorHits = 0;
    private int stabiliserHits = 0;
    private boolean driverHit = false;
    private boolean commanderHit = false;

    @Override
    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    @Override
    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public boolean hasNoTurret() {
        return this.m_bHasNoTurret;
    }

    public void setHasNoTurret(boolean bl) {
        this.m_bHasNoTurret = bl;
    }

    @Override
    public int getWalkMP(boolean bl) {
        int n = this.getOriginalWalkMP();
        n = Math.max(0, n - this.getCargoMpReduction());
        n = bl ? this.applyGravityEffectsOnMP(n) : this.getOriginalWalkMP();
        if (this.game != null) {
            int n2 = this.game.getTemperatureDifference();
            return Math.max(n - n2, 0);
        }
        return n;
    }

    public boolean isTurretLocked() {
        return this.m_bTurretLocked;
    }

    @Override
    public int locations() {
        return this.m_bHasNoTurret ? 5 : 6;
    }

    @Override
    public boolean canChangeSecondaryFacing() {
        return !this.m_bHasNoTurret && !this.m_bTurretLocked;
    }

    @Override
    public boolean isValidSecondaryFacing(int n) {
        return !this.m_bTurretLocked;
    }

    @Override
    public int clipSecondaryFacing(int n) {
        return n;
    }

    @Override
    public void setSecondaryFacing(int n) {
        if (!this.m_bTurretLocked) {
            super.setSecondaryFacing(n);
            if (!this.m_bHasNoTurret) {
                this.m_nTurretOffset = n - this.getFacing();
            }
        }
    }

    @Override
    public void setFacing(int n) {
        super.setFacing(n);
        if (this.m_bTurretLocked) {
            int n2 = (n + this.m_nTurretOffset + 6) % 6;
            super.setSecondaryFacing(n2);
        }
    }

    public boolean isStabiliserHit(int n) {
        return (this.stabiliserHits & 1 << n) == 1 << n;
    }

    public void setStabiliserHit(int n) {
        this.stabiliserHits |= 1 << n;
    }

    public int getSensorHits() {
        return this.sensorHits;
    }

    public void setSensorHits(int n) {
        this.sensorHits = n;
    }

    public boolean isDriverHit() {
        return this.driverHit;
    }

    public void setDriverHit(boolean bl) {
        this.driverHit = bl;
    }

    public boolean isCommanderHit() {
        return this.commanderHit;
    }

    public void setCommanderHit(boolean bl) {
        this.commanderHit = bl;
    }

    public boolean isMovementHit() {
        return this.m_bImmobile;
    }

    public boolean isMovementHitPending() {
        return this.m_bImmobileHit;
    }

    public void immobilize() {
        this.m_bImmobileHit = true;
        this.setOriginalWalkMP(0);
    }

    @Override
    public boolean isImmobile() {
        if (this.game.getOptions().booleanOption("no_immobile_vehicles")) {
            return super.isImmobile();
        }
        return super.isImmobile() || this.m_bImmobile;
    }

    @Override
    public boolean isHexProhibited(IHex iHex) {
        if (iHex.containsTerrain(30)) {
            return true;
        }
        switch (this.movementMode) {
            case 3: {
                return iHex.terrainLevel(1) > 1 || iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20) || iHex.containsTerrain(23) || iHex.terrainLevel(24) > 1;
            }
            case 4: {
                return iHex.containsTerrain(1) || iHex.containsTerrain(2) || iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20) || iHex.containsTerrain(3) || iHex.containsTerrain(24) || iHex.containsTerrain(23) || iHex.containsTerrain(28) || iHex.terrainLevel(22) == 2;
            }
            case 5: {
                return iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.terrainLevel(24) > 1;
            }
            case 7: 
            case 8: {
                return iHex.terrainLevel(4) <= 0 || iHex.containsTerrain(20);
            }
            case 9: {
                return iHex.terrainLevel(4) <= 0;
            }
        }
        return false;
    }

    public void lockTurret() {
        this.m_bTurretLocked = true;
    }

    public int getStunnedTurns() {
        return this.m_nStunnedTurns;
    }

    public void setStunnedTurns(int n) {
        this.m_nStunnedTurns = n;
    }

    public void stunCrew() {
        this.m_nStunnedTurns = this.m_nStunnedTurns == 0 ? 2 : ++this.m_nStunnedTurns;
    }

    public int getJammedTurns() {
        return this.m_nJammedTurns;
    }

    public void setJammedTurns(int n) {
        if (null == this.m_jammedGun) {
            this.m_jammedGun = this.getMainWeapon();
            if (null != this.m_jammedGun) {
                this.m_jammedGun.setJammed(true);
            }
        }
        this.m_nJammedTurns = n;
    }

    @Override
    public void applyDamage() {
        this.m_bImmobile |= this.m_bImmobileHit;
    }

    @Override
    public void newRound(int n) {
        super.newRound(n);
        if (this.m_nStunnedTurns > 0) {
            --this.m_nStunnedTurns;
        }
        if (this.m_jammedGun != null) {
            if (this.m_nJammedTurns > 0) {
                --this.m_nJammedTurns;
            } else {
                this.m_jammedGun.setJammed(false);
                this.m_jammedGun = null;
            }
        }
        if (!this.m_bTurretLocked) {
            this.setSecondaryFacing(this.getFacing());
        }
    }

    public Mounted getMainWeapon() {
        double d = -1.0;
        Mounted mounted = null;
        for (Mounted mounted2 : this.getWeaponList()) {
            double d2;
            if (mounted2.isDestroyed() || !((d2 = mounted2.getType().getBV(this)) > d)) continue;
            d = d2;
            mounted = mounted2;
        }
        return mounted;
    }

    @Override
    public String getMovementString(int n) {
        switch (n) {
            case -2: {
                return "Skidded";
            }
            case 0: {
                return "None";
            }
            case 1: {
                return "Cruised";
            }
            case 2: {
                return "Flanked";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    @Override
    public String getMovementAbbr(int n) {
        switch (n) {
            case -2: {
                return "S";
            }
            case 0: {
                return "N";
            }
            case 1: {
                return "C";
            }
            case 2: {
                return "F";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    @Override
    public boolean hasRearArmor(int n) {
        return false;
    }

    @Override
    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        switch (mounted.getLocation()) {
            case 0: 
            case 1: 
            case 5: {
                return 1;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public boolean isSecondaryArcWeapon(int n) {
        return this.getEquipment(n).getLocation() == 5;
    }

    @Override
    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        return this.rollHitLocation(n, n2);
    }

    @Override
    public HitData rollHitLocation(int n, int n2) {
        int n3 = 1;
        boolean bl = false;
        int n4 = 0;
        if (n2 == 0 && this.isHullDown() && !this.m_bHasNoTurret) {
            n3 = 5;
        }
        if (n2 == 2) {
            n3 = 3;
            bl = true;
            n4 = 2;
        } else if (n2 == 3) {
            n3 = 2;
            bl = true;
            n4 = 2;
        } else if (n2 == 1) {
            n3 = 4;
            n4 = 1;
        }
        HitData hitData = new HitData(n3);
        switch (Compute.d6(2)) {
            case 2: {
                hitData.setEffect(1);
                break;
            }
            case 3: {
                hitData.setEffect(2);
                hitData.setMotiveMod(n4);
                break;
            }
            case 4: {
                hitData.setEffect(2);
                hitData.setMotiveMod(n4);
                break;
            }
            case 5: {
                hitData = bl ? new HitData(1, false, 2) : new HitData(2, false, 2);
                hitData.setMotiveMod(n4);
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                if (!bl) break;
                hitData.setEffect(1);
                break;
            }
            case 9: {
                hitData = bl ? new HitData(4, false, 2) : new HitData(3, false, 2);
                hitData.setMotiveMod(n4);
                break;
            }
            case 10: {
                if (this.m_bHasNoTurret) break;
                hitData = new HitData(5);
                break;
            }
            case 11: {
                if (this.m_bHasNoTurret) break;
                hitData = new HitData(5);
                break;
            }
            case 12: {
                if (this.m_bHasNoTurret || bl) {
                    hitData.setEffect(1);
                    break;
                }
                hitData = new HitData(5, false, 1);
            }
        }
        if (n == 3) {
            hitData.setEffect(hitData.getEffect() | 1);
        }
        return hitData;
    }

    @Override
    public HitData getTransferLocation(HitData hitData) {
        return new HitData(-2);
    }

    @Override
    public int getDependentLocation(int n) {
        return -1;
    }

    @Override
    public int calculateBattleValue() {
        return this.calculateBattleValue(false);
    }

    @Override
    public int calculateBattleValue(boolean bl) {
        Object object;
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        d2 += (double)this.getTotalArmor();
        d2 += (double)this.getTotalInternal() / 2.0;
        double d4 = 0.0;
        for (Mounted mounted : this.getEquipment()) {
            EquipmentType equipmentType = mounted.getType();
            if (mounted.isDestroyed() || !(equipmentType instanceof WeaponType && equipmentType.hasFlag(0x1000000L) || equipmentType instanceof AmmoType && ((AmmoType)equipmentType).getAmmoType() == 14) && !equipmentType.hasFlag(1024L)) continue;
            d4 += equipmentType.getBV(this);
        }
        d2 += d4;
        switch (this.getMovementMode()) {
            case 3: {
                d = 0.8;
                break;
            }
            case 4: {
                d = 0.7;
                break;
            }
            case 5: {
                d = 0.6;
                break;
            }
            case 6: {
                d = 0.4;
                break;
            }
            case 7: {
                d = 0.5;
                break;
            }
            default: {
                d = 0.5;
            }
        }
        d2 *= d;
        int n = Compute.getTargetMovementModifier(this.getOriginalRunMP(), false, false).getValue();
        if (n > 5) {
            n = 5;
        }
        double[] dArray = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5};
        d2 *= dArray[n];
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl2 = this.hasTargComp();
        for (Mounted mounted : this.getWeaponList()) {
            Mounted mounted2;
            object = (WeaponType)mounted.getType();
            double d8 = ((EquipmentType)object).getBV(this);
            if (mounted.isDestroyed() || ((EquipmentType)object).hasFlag(0x1000000L)) continue;
            if (mounted.getLinkedBy() != null && (mounted2 = mounted.getLinkedBy()).getType() instanceof MiscType && mounted2.getType().hasFlag(512L)) {
                d8 *= 1.2;
            }
            if (((EquipmentType)object).hasFlag(1L) && bl2) {
                d8 *= 1.2;
            }
            if (mounted.getLocation() == 4) {
                d7 += d8;
                continue;
            }
            d6 += d8;
        }
        if (d6 > d7) {
            d5 += d6;
            d5 += d7 * 0.5;
        } else {
            d5 += d7;
            d5 += d6 * 0.5;
        }
        double d9 = 0.0;
        for (Mounted mounted : this.getAmmo()) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14) continue;
            d9 += ammoType.getBV(this);
        }
        d5 += d9;
        object = new double[]{0.44, 0.54, 0.65, 0.77, 0.88, 1.0, 1.12, 1.24, 1.37, 1.5, 1.63, 1.76, 1.89, 2.02, 2.16, 2.3, 2.44, 2.58, 2.72, 2.86, 3.0, 3.15, 3.29, 3.44, 3.59, 3.74};
        Object object2 = 3.74;
        if (this.getOriginalRunMP() < ((Object)object).length) {
            object2 = object[this.getOriginalRunMP()];
        }
        d3 = d5 * object2;
        double d10 = 0.0;
        if (this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5 || bl) {
            d10 = Math.round(0.35 * d6 + 0.5 * d7);
        }
        if (this.getsTagBVPenalty()) {
            d2 += 200.0;
        }
        if (this.getsHomingBVPenalty()) {
            d2 += 200.0;
        }
        double d11 = this.crew.getBVSkillMultiplier();
        int n2 = (int)Math.round(d2 + d3 + d10);
        int n3 = (int)Math.round((double)n2 * d11);
        return n3;
    }

    @Override
    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        if (this.movementDamage > 0) {
            pilotingRollData.addModifier(this.movementDamage, "Steering Damage");
        }
        if (this.commanderHit) {
            pilotingRollData.addModifier(1, "commander injured");
        }
        if (this.driverHit) {
            pilotingRollData.addModifier(2, "driver injured");
        }
        return pilotingRollData;
    }

    @Override
    public Vector<Report> victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7035);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        vector.addAll(this.crew.getDescVector(false));
        report = new Report(7070, 0);
        report.add(this.getKillNumber());
        vector.addElement(report);
        if (this.isDestroyed()) {
            Entity entity = this.game.getEntity(this.killerId);
            if (entity == null) {
                entity = this.game.getOutOfGameEntity(this.killerId);
            }
            if (entity != null) {
                report = new Report(7072, 0);
                report.addDesc(entity);
            } else {
                report = new Report(7073, 0);
            }
            vector.addElement(report);
        }
        report.newlines = 2;
        return vector;
    }

    @Override
    public int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    @Override
    public int getRunMPwithoutMASC(boolean bl) {
        return this.getRunMP(bl);
    }

    @Override
    public int getHeatCapacity() {
        return 999;
    }

    @Override
    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    @Override
    public int getEngineCritHeat() {
        return 0;
    }

    @Override
    public void autoSetInternal() {
        int n = (int)Math.ceil((double)this.weight / 10.0);
        this.initializeInternal(-1, 0);
        for (int i = 1; i < this.locations(); ++i) {
            this.initializeInternal(n, i);
        }
    }

    @Override
    public int getMaxElevationChange() {
        return 1;
    }

    @Override
    public boolean isRepairable() {
        boolean bl = this.isSalvage();
        for (int i = 1; bl && i < 5; ++i) {
            int n = this.getInternal(i);
            bl = n != -2 && n != -3;
        }
        return bl;
    }

    @Override
    public void restore() {
        super.restore();
        if (this.m_nJammedTurns > 0 && null == this.m_jammedGun) {
            this.m_jammedGun = this.getMainWeapon();
        }
    }

    @Override
    public boolean canCharge() {
        return super.canCharge() && (!this.game.getOptions().booleanOption("no_hover_charge") || 5 != this.getMovementMode());
    }

    @Override
    public boolean canDFA() {
        return false;
    }

    @Override
    public int getArmorType() {
        return this.armorType;
    }

    @Override
    public void setArmorType(int n) {
        this.armorType = n;
    }

    @Override
    public int getStructureType() {
        return this.structureType;
    }

    @Override
    public void setStructureType(int n) {
        this.structureType = n;
    }

    public int getSuspensionFactor() {
        switch (this.movementMode) {
            case 5: {
                if (this.weight <= 10.0f) {
                    return 40;
                }
                if (this.weight <= 20.0f) {
                    return 85;
                }
                if (this.weight <= 30.0f) {
                    return 130;
                }
                if (this.weight <= 40.0f) {
                    return 175;
                }
                return 235;
            }
            case 8: {
                if (this.weight <= 10.0f) {
                    return 60;
                }
                if (this.weight <= 20.0f) {
                    return 105;
                }
                if (this.weight <= 30.0f) {
                    return 150;
                }
                if (this.weight <= 40.0f) {
                    return 195;
                }
                if (this.weight <= 50.0f) {
                    return 255;
                }
                if (this.weight <= 60.0f) {
                    return 300;
                }
                if (this.weight <= 70.0f) {
                    return 345;
                }
                if (this.weight <= 80.0f) {
                    return 390;
                }
                if (this.weight <= 90.0f) {
                    return 435;
                }
                return 480;
            }
            case 7: 
            case 9: {
                return 30;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 20;
            }
            case 6: {
                if (this.weight <= 10.0f) {
                    return 50;
                }
                if (this.weight <= 20.0f) {
                    return 95;
                }
                return 140;
            }
        }
        return 0;
    }

    @Override
    public double getCost() {
        double d;
        double d2 = 0.0;
        Engine engine = this.getEngine();
        d2 += (double)((float)(engine.getBaseCost() * engine.getRating()) * this.weight) / 75.0;
        double d3 = Math.ceil((double)this.weight * 0.05 * 2.0) / 2.0;
        d2 += 10000.0 * d3;
        d2 += (double)this.weight / 10.0 * 10000.0;
        double d4 = engine.getCountEngineHeatSinks();
        int n = 0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.hasFlag(4L) || weaponType.hasFlag(8L)) {
                n += weaponType.getHeat();
                d6 += (double)weaponType.getTonnage(this) / 10.0;
            }
            if (this.hasNoTurret() || mounted.getLocation() != 5) continue;
            d5 += (double)weaponType.getTonnage(this) / 10.0;
        }
        d6 = Math.ceil(d6 * 10.0) / 10.0;
        if (engine.isFusion()) {
            d6 = 0.0;
        }
        d5 = Math.ceil(d5 * 2.0) / 2.0;
        d2 += 20000.0 * d6;
        d2 += 2000.0 * Math.max(0.0, (double)n - d4);
        d2 += d5 * 5000.0;
        d2 += this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        switch (this.movementMode) {
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                d = (double)this.weight / 10.0;
                break;
            }
            default: {
                d = 0.0;
            }
        }
        d2 = this.movementMode != 6 ? (d2 += d * 20000.0) : (d2 += d * 40000.0);
        d2 += (double)this.getWeaponsAndEquipmentCost();
        double d7 = 1.0;
        switch (this.movementMode) {
            case 5: 
            case 9: {
                d7 += (double)this.weight / 50.0;
                break;
            }
            case 8: {
                d7 += (double)this.weight / 75.0;
                break;
            }
            case 4: 
            case 7: {
                d7 += (double)this.weight / 200.0;
                break;
            }
            case 3: {
                d7 += (double)this.weight / 100.0;
                break;
            }
            case 6: {
                d7 += (double)this.weight / 30.0;
            }
        }
        return Math.round(d2 * d7);
    }

    @Override
    public boolean doomedInVacuum() {
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(32768L)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canGoHullDown() {
        return this.game.getOptions().booleanOption("hull_down");
    }

    public void setOnFire(boolean bl) {
        this.infernoFire |= bl;
        this.burningLocations = (1 << this.locations()) - 1;
        this.extinguishLocation(0);
    }

    public boolean isOnFire() {
        return this.burningLocations != 0 || this.infernos.isStillBurning();
    }

    public boolean isInfernoFire() {
        return this.infernoFire;
    }

    public boolean isLocationBurning(int n) {
        int n2 = 1 << n;
        return (this.burningLocations & n2) == n2;
    }

    public void extinguishLocation(int n) {
        int n2 = ~(1 << n);
        this.burningLocations &= n2;
    }

    public void extinguishAll() {
        this.burningLocations = 0;
        this.infernoFire = false;
        this.infernos.clear();
    }

    public void addMovementDamage(int n) {
        this.movementDamage += n;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
        if (engine.engineValid) {
            this.setOriginalWalkMP(this.calculateWalk());
        }
    }

    protected int calculateWalk() {
        return (this.getEngine().getRating() + this.getSuspensionFactor()) / (int)this.weight;
    }

    @Override
    public boolean isNuclearHardened() {
        return true;
    }

    @Override
    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        super.addEquipment(mounted, n, bl);
        this.addCritical(n, new CriticalSlot(1, this.getEquipmentNum(mounted), true));
    }

    public int getCriticalEffect(int n, int n2) {
        if (n > 12) {
            n = 12;
        }
        if (n < 6) {
            return -1;
        }
        block36: for (int i = 0; i < 2; ++i) {
            if (i > 0) {
                n = 6;
            }
            if (n2 == 1) {
                switch (n) {
                    case 6: {
                        if (!this.isDriverHit() && !this.crew.isDead()) {
                            return 0;
                        }
                    }
                    case 7: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                            return 1;
                        }
                    }
                    case 8: {
                        if (!this.isStabiliserHit(n2)) {
                            return 3;
                        }
                    }
                    case 9: {
                        if (this.getSensorHits() < 4) {
                            return 4;
                        }
                    }
                    case 10: {
                        if (!this.isCommanderHit() && !this.crew.isDead()) {
                            return 5;
                        }
                    }
                    case 11: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                            return 2;
                        }
                    }
                    case 12: {
                        if (this.crew.isDead()) break;
                        return 6;
                    }
                }
                continue;
            }
            if (n2 == 4) {
                switch (n) {
                    case 6: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                            return 1;
                        }
                    }
                    case 7: {
                        if (this.getLoadedUnits().size() > 0) {
                            return 8;
                        }
                    }
                    case 8: {
                        if (!this.isStabiliserHit(n2)) {
                            return 3;
                        }
                    }
                    case 9: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                            return 2;
                        }
                    }
                    case 10: {
                        if (!this.isImmobile()) {
                            return 9;
                        }
                    }
                    case 11: {
                        for (Mounted mounted : this.getAmmo()) {
                            if (mounted.isDestroyed() || mounted.isHit()) continue;
                            return 11;
                        }
                    }
                    case 12: {
                        if (this.getEngine().isFusion() && !this.isImmobile()) {
                            return 9;
                        }
                        if (this.getEngine().isFusion()) break;
                        return 10;
                    }
                }
                continue;
            }
            if (n2 == 5) {
                switch (n) {
                    case 6: {
                        if (!this.isStabiliserHit(n2)) {
                            return 3;
                        }
                    }
                    case 7: {
                        if (!this.isTurretLocked()) {
                            return 12;
                        }
                    }
                    case 8: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed()) continue;
                            return 1;
                        }
                    }
                    case 9: {
                        if (!this.isTurretLocked()) {
                            return 13;
                        }
                    }
                    case 10: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                            return 2;
                        }
                    }
                    case 11: {
                        for (Mounted mounted : this.getAmmo()) {
                            if (mounted.isDestroyed() || mounted.isHit()) continue;
                            return 11;
                        }
                    }
                    case 12: {
                        return 14;
                    }
                }
                continue;
            }
            switch (n) {
                case 6: {
                    if (this.getLoadedUnits().size() > 0) {
                        return 8;
                    }
                }
                case 7: {
                    for (Mounted mounted : this.getWeaponList()) {
                        if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                        return 1;
                    }
                }
                case 8: {
                    if (!this.crew.isDead()) {
                        if (this.isCommanderHit() && this.isDriverHit()) {
                            return 6;
                        }
                        return 7;
                    }
                }
                case 9: {
                    if (!this.isStabiliserHit(n2)) {
                        return 3;
                    }
                }
                case 10: {
                    for (Mounted mounted : this.getWeaponList()) {
                        if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                        return 2;
                    }
                }
                case 11: {
                    if (!this.isImmobile()) {
                        return 9;
                    }
                }
                case 12: {
                    if (this.getEngine().isFusion() && !this.isImmobile()) {
                        return 9;
                    }
                    if (this.getEngine().isFusion()) continue block36;
                    return 10;
                }
            }
        }
        return -1;
    }

    @Override
    public void setOmni(boolean bl) {
        super.setOmni(bl);
        if (bl && !this.hasBattleArmorHandles()) {
            this.addTransporter(new BattleArmorHandlesTank());
        }
    }
}

