/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import megamek.common.Entity;
import megamek.common.Infantry;
import megamek.common.Transporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TroopSpace
implements Transporter {
    Vector troops = new Vector();
    double totalSpace;
    double currentSpace;

    protected TroopSpace() {
        this.totalSpace = 0.0;
        this.currentSpace = 0.0;
    }

    public TroopSpace(double d) {
        this.totalSpace = d;
        this.currentSpace = d;
    }

    @Override
    public boolean canLoad(Entity entity) {
        boolean bl = true;
        if (!(entity instanceof Infantry)) {
            bl = false;
        } else if (this.currentSpace < (double)entity.getWeight()) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void load(Entity entity) throws IllegalArgumentException {
        if (!this.canLoad(entity)) {
            throw new IllegalArgumentException("Can not load " + entity.getShortName() + " into this troop space.");
        }
        this.currentSpace -= (double)entity.getWeight();
        this.troops.addElement(entity);
    }

    public Vector getLoadedUnits() {
        return (Vector)this.troops.clone();
    }

    @Override
    public boolean unload(Entity entity) {
        boolean bl = this.troops.removeElement(entity);
        if (bl) {
            this.currentSpace += (double)entity.getWeight();
        }
        return bl;
    }

    @Override
    public String getUnusedString() {
        return "Troops - " + this.currentSpace + " tons";
    }

    @Override
    public boolean isWeaponBlockedAt(int n, boolean bl) {
        return false;
    }

    @Override
    public Entity getExteriorUnitAt(int n, boolean bl) {
        return null;
    }

    @Override
    public final List<Entity> getExternalUnits() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>(1);
        return arrayList;
    }

    @Override
    public int getCargoMpReduction() {
        return 0;
    }
}

