/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MoveStep;
import megamek.common.PilotingRollData;
import megamek.common.Tank;
import megamek.common.WeaponType;

public class VTOL
extends Tank {
    public static final int LOC_ROTOR = 5;
    protected static String[] LOCATION_ABBRS = new String[]{"BD", "FR", "RS", "LS", "RR", "RO"};
    protected static String[] LOCATION_NAMES = new String[]{"Body", "Front", "Right", "Left", "Rear", "Rotor"};
    public static final int CRIT_COPILOT = 15;
    public static final int CRIT_PILOT = 16;
    public static final int CRIT_ROTOR_DAMAGE = 17;
    public static final int CRIT_ROTOR_DESTROYED = 18;
    public static final int CRIT_FLIGHT_STABILIZER = 19;

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public PilotingRollData checkSkid(int n, IHex iHex, int n2, MoveStep moveStep, int n3, int n4, Coords coords, Coords coords2, boolean bl, int n5) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        pilotingRollData.addModifier(-2147483647, "Check false: VTOLs can't skid");
        return pilotingRollData;
    }

    public int calculateBattleValue(boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        d += (double)this.getTotalArmor();
        d += (double)this.getTotalInternal() / 2.0;
        double d3 = 0.0;
        for (Mounted mounted : this.getEquipment()) {
            EquipmentType equipmentType = mounted.getType();
            if (mounted.isDestroyed() || !(equipmentType instanceof WeaponType && ((WeaponType)equipmentType).getAmmoType() == 14 || equipmentType instanceof AmmoType && ((AmmoType)equipmentType).getAmmoType() == 14) && !equipmentType.hasFlag(1024L)) continue;
            d3 += equipmentType.getBV(this);
        }
        d += d3;
        double d4 = 0.4;
        d *= d4;
        int n = Compute.getTargetMovementModifier(this.getOriginalRunMP(), true, true).getValue();
        if (n > 5) {
            n = 5;
        }
        double[] dArray = new double[]{1.0, 1.1, 1.2, 1.3, 1.4, 1.5};
        d *= dArray[n];
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        boolean bl2 = this.hasTargComp();
        for (Mounted mounted : this.getWeaponList()) {
            Mounted mounted2;
            WeaponType weaponType = (WeaponType)mounted.getType();
            double d8 = weaponType.getBV(this);
            if (mounted.isDestroyed() || weaponType.getAmmoType() == 14) continue;
            if (mounted.getLinkedBy() != null && (mounted2 = mounted.getLinkedBy()).getType() instanceof MiscType && mounted2.getType().hasFlag(512L)) {
                d8 *= 1.2;
            }
            if (weaponType.hasFlag(1L) && bl2) {
                d8 *= 1.2;
            }
            if (mounted.getLocation() == 4) {
                d7 += d8;
                continue;
            }
            d6 += d8;
        }
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.isDestroyed()) continue;
            if (mounted.getName().equals("Beagle Active Probe")) {
                d6 += 10.0;
            }
            if (mounted.getName().equals("Active Probe")) {
                d6 += 12.0;
            }
            if (mounted.getName().equals("Clan Active Probe")) {
                d6 += 12.0;
            }
            if (!mounted.getName().equals("Light Active Probe")) continue;
            d6 += 7.0;
        }
        if (d6 > d7) {
            d5 += d6;
            d5 += d7 * 0.5;
        } else {
            d5 += d7;
            d5 += d6 * 0.5;
        }
        double d9 = 0.0;
        for (Mounted mounted : this.getAmmo()) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14) continue;
            d9 += ammoType.getBV(this);
        }
        d5 += d9;
        double d10 = 2 * this.getOriginalRunMP() - 5;
        d10 /= 10.0;
        d10 += 1.0;
        d10 = Math.pow(d10, 1.2);
        d10 = (double)Math.round(d10 * 100.0) / 100.0;
        d2 = d5 * d10;
        double d11 = 0.0;
        if (this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5 || bl) {
            d11 = Math.round(0.35 * d6 + 0.5 * d7);
        }
        if (this.getsTagBVPenalty()) {
            d += 200.0;
        }
        if (this.getsHomingBVPenalty()) {
            d += 200.0;
        }
        double d12 = this.crew.getBVSkillMultiplier();
        int n2 = (int)Math.round(d + d2 + d11);
        int n3 = (int)Math.round((double)n2 * d12);
        return n3;
    }

    public boolean canCharge() {
        return false;
    }

    public String getMovementString(int n) {
        switch (n) {
            case 4: {
                return "Cruised";
            }
            case 5: {
                return "Flanked";
            }
            case 0: {
                return "None";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case 4: {
                return "C";
            }
            case 5: {
                return "F";
            }
            case 0: {
                return "N";
            }
        }
        return "?";
    }

    public int getMaxElevationChange() {
        return 999;
    }

    public boolean isHexProhibited(IHex iHex) {
        return iHex.containsTerrain(30);
    }

    public boolean isRepairable() {
        boolean bl = this.isSalvage();
        for (int i = 1; bl && i < 5; ++i) {
            int n = this.getInternal(i);
            bl = n != -2 && n != -3;
        }
        return bl;
    }

    public HitData rollHitLocation(int n, int n2) {
        int n3 = 1;
        boolean bl = false;
        if (n2 == 2) {
            n3 = 3;
            bl = true;
        } else if (n2 == 3) {
            n3 = 2;
            bl = true;
        } else if (n2 == 1) {
            n3 = 4;
        }
        HitData hitData = new HitData(n3);
        switch (Compute.d6(2)) {
            case 2: {
                hitData.setEffect(1);
                break;
            }
            case 3: 
            case 4: {
                hitData = new HitData(5, false, 2);
                break;
            }
            case 5: {
                if (bl) {
                    hitData = new HitData(1);
                    break;
                }
                hitData = new HitData(2);
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                if (!bl) break;
                hitData.setEffect(1);
                break;
            }
            case 9: {
                if (bl) {
                    hitData = new HitData(4);
                    break;
                }
                hitData = new HitData(3);
                break;
            }
            case 10: 
            case 11: {
                hitData = new HitData(5, false, 2);
            }
            case 12: {
                hitData = new HitData(5, false, 3);
            }
        }
        if (n == 3) {
            hitData.setEffect(hitData.getEffect() | 1);
        }
        return hitData;
    }

    public boolean doomedInVacuum() {
        return true;
    }

    public void setOnFire(boolean bl) {
        super.setOnFire(bl);
        this.extinguishLocation(5);
    }

    public int getCriticalEffect(int n, int n2) {
        if (n > 12) {
            n = 12;
        }
        if (n < 6) {
            return -1;
        }
        block32: for (int i = 0; i < 2; ++i) {
            if (i > 0) {
                n = 6;
            }
            if (n2 == 1) {
                switch (n) {
                    case 6: {
                        if (!this.isDriverHit()) {
                            return 15;
                        }
                        return 6;
                    }
                    case 7: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                            return 1;
                        }
                    }
                    case 8: {
                        if (!this.isStabiliserHit(n2)) {
                            return 3;
                        }
                    }
                    case 9: {
                        if (this.getSensorHits() < 4) {
                            return 4;
                        }
                    }
                    case 10: {
                        if (!this.isCommanderHit()) {
                            return 16;
                        }
                        return 6;
                    }
                    case 11: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                            return 2;
                        }
                    }
                    case 12: {
                        if (this.crew.isDead()) break;
                        return 6;
                    }
                }
                continue;
            }
            if (n2 == 4) {
                switch (n) {
                    case 6: {
                        if (this.getLoadedUnits().size() > 0) {
                            return 8;
                        }
                    }
                    case 7: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                            return 1;
                        }
                    }
                    case 8: {
                        if (!this.isStabiliserHit(n2)) {
                            return 3;
                        }
                    }
                    case 9: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                            return 2;
                        }
                    }
                    case 10: {
                        if (this.getSensorHits() < 4) {
                            return 4;
                        }
                    }
                    case 11: {
                        if (!this.isImmobile()) {
                            return 9;
                        }
                    }
                    case 12: {
                        if (this.getEngine().isFusion() && !this.isImmobile()) {
                            return 9;
                        }
                        if (this.getEngine().isFusion()) break;
                        return 10;
                    }
                }
                continue;
            }
            if (n2 == 5) {
                switch (n) {
                    case 6: 
                    case 7: 
                    case 8: {
                        if (!this.isImmobile()) {
                            return 17;
                        }
                    }
                    case 9: 
                    case 10: {
                        if (!this.isStabiliserHit(n2)) {
                            return 19;
                        }
                    }
                    case 11: 
                    case 12: {
                        return 18;
                    }
                }
                continue;
            }
            switch (n) {
                case 6: {
                    for (Mounted mounted : this.getWeaponList()) {
                        if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                        return 1;
                    }
                }
                case 7: {
                    if (this.getLoadedUnits().size() > 0) {
                        return 8;
                    }
                }
                case 8: {
                    if (!this.isStabiliserHit(n2)) {
                        return 3;
                    }
                }
                case 9: {
                    for (Mounted mounted : this.getWeaponList()) {
                        if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                        return 2;
                    }
                }
                case 10: {
                    if (!this.isImmobile()) {
                        return 9;
                    }
                }
                case 11: {
                    for (Mounted mounted : this.getAmmo()) {
                        if (mounted.isDestroyed() || mounted.isHit()) continue;
                        return 11;
                    }
                }
                case 12: {
                    if (this.getEngine().isFusion() && !this.isImmobile()) {
                        return 9;
                    }
                    if (this.getEngine().isFusion()) continue block32;
                    return 10;
                }
            }
        }
        return -1;
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        if (this.movementDamage > 0) {
            pilotingRollData.addModifier(this.movementDamage, "Steering Damage");
        }
        if (this.isDriverHit()) {
            pilotingRollData.addModifier(2, "pilot injured");
        }
        if (this.isStabiliserHit(5)) {
            pilotingRollData.addModifier(3, "flight stabiliser damaged");
        }
        return pilotingRollData;
    }
}

