/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.BipedMech;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.VTOL;
import megamek.common.actions.PhysicalAttackAction;

public class ClubAttackAction
extends PhysicalAttackAction {
    private Mounted club;

    public ClubAttackAction(int n, int n2, Mounted mounted) {
        super(n, n2);
        this.club = mounted;
    }

    public ClubAttackAction(int n, int n2, int n3, Mounted mounted) {
        super(n, n2, n3);
        this.club = mounted;
    }

    public static int getDamageFor(Entity entity, Mounted mounted) {
        int n;
        MiscType miscType = (MiscType)mounted.getType();
        int n2 = (int)Math.floor((double)entity.getWeight() / 5.0);
        if (miscType.hasSubType(8)) {
            n2 = (int)(Math.ceil((double)entity.getWeight() / 10.0) + 1.0);
        } else if (miscType.hasSubType(16)) {
            n2 *= 2;
        } else if (miscType.hasSubType(64)) {
            n2 = (int)Math.floor((double)entity.getWeight() / 4.0);
        } else if (miscType.hasSubType(512)) {
            n2 = 10;
        } else if (miscType.hasSubType(256)) {
            n2 = 9;
        } else if (miscType.hasSubType(128)) {
            n2 = 7;
        } else if (miscType.hasSubType(0x100000)) {
            n2 = 5;
        } else if (miscType.hasSubType(262144)) {
            n2 = 6;
        } else if (miscType.isShield()) {
            n2 = mounted.getDamageAbsorption(entity, mounted.getLocation());
        } else if (miscType.hasSubType(131072)) {
            n2 = 8;
        } else if (miscType.hasSubType(0x400000)) {
            n2 = Compute.d6(2);
        } else if (miscType.isVibroblade()) {
            n2 = mounted.curMode().equals("Active") ? (miscType.hasSubType(65536) ? 14 : (miscType.hasSubType(32768) ? 10 : 7)) : (int)(Math.ceil((double)entity.getWeight() / 10.0) + 1.0);
        }
        if (!(entity.heat < 9 || miscType.hasSubType(128) || miscType.hasSubType(0x100000) || miscType.hasSubType(512) || miscType.isShield() || miscType.hasSubType(131072) || miscType.hasSubType(256) || miscType.isVibroblade() && mounted.curMode().equals("Active") || miscType.hasSubType(0x400000) || !((Mech)entity).hasTSM())) {
            n2 *= 2;
        }
        if ((n = mounted.getLocation()) == -1) {
            n = 4;
        }
        if (entity.getLocationStatus(n) == 2) {
            n2 = (int)((float)n2 / 2.0f);
        }
        return n2 + entity.getCrew().modifyPhysicalDamagaForMeleeSpecialist();
    }

    public ToHitData toHit(IGame iGame) {
        return ClubAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this.getClub());
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, Mounted mounted) {
        int n2;
        Entity entity = iGame.getEntity(n);
        if (entity == null || targetable == null) {
            throw new IllegalArgumentException("Attacker or target not valid");
        }
        if (mounted == null) {
            throw new IllegalArgumentException("Club is null");
        }
        if (mounted.getType() == null) {
            throw new IllegalArgumentException("Club type is null");
        }
        String string = ClubAttackAction.toHitIsImpossible(iGame, entity, targetable);
        if (string != null) {
            return new ToHitData(Integer.MAX_VALUE, string);
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't club");
        }
        if (entity.entityIsQuad()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is a quad");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        int n3 = entity.getElevation() + iHex.getElevation();
        int n4 = n3 + entity.height();
        int n5 = targetable.getElevation() + iHex2.getElevation();
        int n6 = n5 + targetable.getHeight();
        boolean bl = mounted.getType().hasFlag(0x8000000L) && ((MiscType)mounted.getType()).hasSubType(1);
        boolean bl2 = ((BipedMech)entity).hasClaw(4) || ((BipedMech)entity).hasClaw(5);
        boolean bl3 = ((MiscType)mounted.getType()).isShield();
        boolean bl4 = true;
        if (bl2 || ((MiscType)mounted.getType()).hasSubType(256) || ((MiscType)mounted.getType()).hasSubType(131072) || ((MiscType)mounted.getType()).hasSubType(8192) || ((MiscType)mounted.getType()).hasSubType(0x400000) || ((MiscType)mounted.getType()).hasSubType(128)) {
            bl4 = false;
        }
        if (bl) {
            if (entity.isLocationBad(4) || entity.isLocationBad(5)) {
                return new ToHitData(Integer.MAX_VALUE, "Arm missing");
            }
            if (entity.weaponFiredFrom(4) || entity.weaponFiredFrom(5)) {
                return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
            }
            if (!entity.hasWorkingSystem(7, 4) || !entity.hasWorkingSystem(7, 5)) {
                return new ToHitData(Integer.MAX_VALUE, "Shoulder actuator destroyed");
            }
            if (!(entity.hasWorkingSystem(10, 4) && entity.hasWorkingSystem(10, 5) || !bl4)) {
                return new ToHitData(Integer.MAX_VALUE, "Hand actuator destroyed");
            }
        } else if (bl3) {
            if (!entity.hasPassiveShield(mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Shield not in passive mode");
            }
        } else if (((MiscType)mounted.getType()).hasSubType(256)) {
            if (!entity.hasWorkingSystem(8, mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Upper actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Lower actuator destroyed");
            }
        } else {
            if (entity.isLocationBad(mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Arm missing");
            }
            if (entity.weaponFiredFrom(mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
            }
            if (!entity.hasWorkingSystem(7, mounted.getLocation())) {
                return new ToHitData(Integer.MAX_VALUE, "Shoulder actuator destroyed");
            }
            if (!entity.hasWorkingSystem(10, mounted.getLocation()) && bl4) {
                return new ToHitData(Integer.MAX_VALUE, "Hand actuator destroyed");
            }
        }
        if (!bl3 && entity.getBadCriticals(1, entity.getEquipmentNum(mounted), mounted.getLocation()) > 0) {
            return new ToHitData(Integer.MAX_VALUE, "Club is damaged");
        }
        int n7 = n4;
        if (targetable instanceof VTOL) {
            ++n7;
        }
        if (n6 < n3 || n5 > n7) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        int n8 = bl ? 1 : (n2 = mounted.getLocation() == 5 ? 2 : 3);
        if (!Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable.getPosition(), n2)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15 || targetable instanceof GunEmplacement) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        int n9 = entity.getCrew().getPiloting() - 1;
        if (((MiscType)mounted.getType()).hasSubType(8) || ((MiscType)mounted.getType()).isVibroblade()) {
            --n9;
        } else if (((MiscType)mounted.getType()).hasSubType(128) || ((MiscType)mounted.getType()).hasSubType(0x100000) || ((MiscType)mounted.getType()).hasSubType(256)) {
            ++n9;
        } else if (((MiscType)mounted.getType()).hasSubType(16) || ((MiscType)mounted.getType()).hasSubType(64) || ((MiscType)mounted.getType()).hasSubType(262144) || ((MiscType)mounted.getType()).hasSubType(8192) || ((MiscType)mounted.getType()).hasSubType(262144) || ((MiscType)mounted.getType()).hasSubType(131072)) {
            n9 += 2;
        } else if (((MiscType)mounted.getType()).hasSubType(512)) {
            n9 += 3;
        } else if (((MiscType)mounted.getType()).hasSubType(4096)) {
            n9 -= 3;
        } else if (((MiscType)mounted.getType()).hasSubType(2048)) {
            n9 -= 2;
        } else if (((MiscType)mounted.getType()).hasSubType(1024)) {
            --n9;
        }
        ToHitData toHitData = new ToHitData(n9, "base");
        ClubAttackAction.setCommonModifiers(toHitData, iGame, entity, targetable);
        if (bl) {
            if (!entity.hasWorkingSystem(8, 4)) {
                toHitData.addModifier(2, "Upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(8, 5)) {
                toHitData.addModifier(2, "Upper arm actuator destroyed");
            }
            if (!entity.hasWorkingSystem(9, 4)) {
                toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
            }
            if (!entity.hasWorkingSystem(9, 5)) {
                toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
            }
            if (bl2) {
                toHitData.addModifier(2, "Mek has claws");
            }
        } else {
            if (!entity.hasWorkingSystem(8, mounted.getLocation())) {
                toHitData.addModifier(2, "Upper arm actuator destroyed");
                if (((MiscType)mounted.getType()).hasSubType(8192)) {
                    return new ToHitData(Integer.MAX_VALUE, "Unable to use lance with upper arm actuator missing or destroyed");
                }
            }
            if (!entity.hasWorkingSystem(9, mounted.getLocation())) {
                toHitData.addModifier(2, "Lower arm actuator missing or destroyed");
                if (((MiscType)mounted.getType()).hasSubType(8192)) {
                    return new ToHitData(Integer.MAX_VALUE, "Unable to use lance with lower arm actuator missing or destroyed");
                }
            }
            if (bl2) {
                toHitData.addModifier(2, "Mek has claws");
            }
            if (!(((MiscType)mounted.getType()).hasSubType(8192) && entity.hasWorkingSystem(9, mounted.getLocation()) && entity.hasWorkingSystem(8, mounted.getLocation()))) {
                // empty if block
            }
        }
        if (n3 == n5) {
            if (bl3) {
                toHitData.setHitTable(1);
            } else {
                toHitData.setHitTable(0);
            }
        } else if (n3 < n5) {
            if (targetable.getHeight() == 0) {
                if (bl3) {
                    toHitData.setHitTable(1);
                } else {
                    toHitData.setHitTable(0);
                }
            } else {
                toHitData.setHitTable(2);
            }
        } else {
            toHitData.setHitTable(1);
        }
        toHitData.setSideTable(Compute.targetSideTable(entity, targetable));
        return toHitData;
    }

    public Mounted getClub() {
        return this.club;
    }

    public void setClub(Mounted mounted) {
        this.club = mounted;
    }
}

