/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.BipedMech;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.PhysicalAttackAction;

public class GrappleAttackAction
extends PhysicalAttackAction {
    public GrappleAttackAction(int n, int n2) {
        super(n, n2);
    }

    public GrappleAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public ToHitData toHit(IGame iGame) {
        return GrappleAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable) {
        int n2;
        boolean bl;
        Entity entity = iGame.getEntity(n);
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        if (!iGame.getOptions().booleanOption("maxtech_new_physicals")) {
            return new ToHitData(Integer.MAX_VALUE, "no MaxTech physicals");
        }
        String string = GrappleAttackAction.toHitIsImpossible(iGame, entity, targetable);
        if (string != null && !string.equals("Locked in Grapple")) {
            return new ToHitData(Integer.MAX_VALUE, "impossible");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        int n3 = entity.getElevation() + iHex.getElevation();
        int n4 = targetable.getElevation() + iHex2.getElevation();
        if (!(entity instanceof BipedMech) || !(targetable instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Only biped mechs can trip other mechs");
        }
        boolean bl2 = bl = ((Mech)entity).getGrappled() != -1 && !((Mech)entity).isGrappleAttacker();
        if (entity.isLocationBad(5) || entity.isLocationBad(4)) {
            return new ToHitData(Integer.MAX_VALUE, "Arm missing");
        }
        if (!entity.hasWorkingSystem(7, 4) || !entity.hasWorkingSystem(7, 5)) {
            return new ToHitData(Integer.MAX_VALUE, "Shoulder missing/destroyed");
        }
        int n5 = entity.getPosition().distance(targetable.getPosition());
        if (n5 != 1 && !bl) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (Math.abs(n3 - n4) > entity.getMaxElevationChange()) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (!bl && !Compute.isInArc(entity.getPosition(), entity.getFacing(), targetable.getPosition(), 1)) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in arc");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (((Entity)targetable).isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is prone");
        }
        if (!bl) {
            for (Mounted mounted : entity.getWeaponList()) {
                if (!mounted.isUsedThisRound()) continue;
                return new ToHitData(Integer.MAX_VALUE, "Fired weapons");
            }
        }
        int n6 = ((Mech)entity).getGrappled();
        int n7 = ((Mech)targetable).getGrappled();
        if ((n6 != -1 || n7 != -1) && n6 != targetable.getTargetId() && ((Mech)targetable).isGrappleAttacker()) {
            return new ToHitData(Integer.MAX_VALUE, "Already grappled");
        }
        int n8 = entity.getCrew().getPiloting();
        ToHitData toHitData = new ToHitData(n8, "base");
        GrappleAttackAction.setCommonModifiers(toHitData, iGame, entity, targetable);
        if (!entity.hasWorkingSystem(8, 5)) {
            toHitData.addModifier(2, "Left upper arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(9, 5)) {
            toHitData.addModifier(2, "Left lower arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(10, 5)) {
            toHitData.addModifier(1, "Left hand actuator destroyed");
        }
        if (!entity.hasWorkingSystem(8, 4)) {
            toHitData.addModifier(2, "Right upper arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(9, 4)) {
            toHitData.addModifier(2, "Right lower arm actuator destroyed");
        }
        if (!entity.hasWorkingSystem(10, 4)) {
            toHitData.addModifier(1, "Right hand actuator destroyed");
        }
        if ((n2 = ((Entity)targetable).getWeightClass() - entity.getWeightClass()) != 0) {
            toHitData.addModifier(n2, "Weight class difference");
        }
        return toHitData;
    }
}

