/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.preference;

import java.util.Properties;
import java.util.Vector;
import megamek.common.preference.IPreferenceChangeListener;
import megamek.common.preference.IPreferenceStore;
import megamek.common.preference.PreferenceChangeEvent;

class PreferenceStore
implements IPreferenceStore {
    protected boolean dirty = false;
    protected Properties properties;
    protected Properties defaultProperties;
    protected Vector listeners = new Vector();

    public PreferenceStore() {
        this.defaultProperties = new Properties();
        this.properties = new Properties(this.defaultProperties);
    }

    public boolean getDefaultBoolean(String string) {
        return this.getBoolean(this.defaultProperties, string);
    }

    public int getDefaultInt(String string) {
        return this.getInt(this.defaultProperties, string);
    }

    public long getDefaultLong(String string) {
        return this.getLong(this.defaultProperties, string);
    }

    public String getDefaultString(String string) {
        return this.getString(this.defaultProperties, string);
    }

    public double getDefaultDouble(String string) {
        return this.getDouble(this.defaultProperties, string);
    }

    public float getDefaultFloat(String string) {
        return this.getFloat(this.defaultProperties, string);
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(this.properties, string);
    }

    private boolean getBoolean(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return false;
        }
        return string2.equals("true");
    }

    public double getDouble(String string) {
        return this.getDouble(this.properties, string);
    }

    private double getDouble(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0.0;
        }
        double d = 0.0;
        try {
            d = new Double(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public float getFloat(String string) {
        return this.getFloat(this.properties, string);
    }

    private float getFloat(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0.0f;
        }
        float f = 0.0f;
        try {
            f = new Float(string2).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f;
    }

    public int getInt(String string) {
        return this.getInt(this.properties, string);
    }

    private int getInt(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public long getLong(String string) {
        return this.getLong(this.properties, string);
    }

    private long getLong(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return 0L;
        }
        long l = 0L;
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public String getString(String string) {
        return this.getString(this.properties, string);
    }

    private String getString(Properties properties, String string) {
        String string2;
        String string3 = string2 = properties != null ? properties.getProperty(string) : null;
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public void setDefault(String string, double d) {
        this.setValue(this.defaultProperties, string, d);
    }

    public void setDefault(String string, float f) {
        this.setValue(this.defaultProperties, string, f);
    }

    public void setDefault(String string, int n) {
        this.setValue(this.defaultProperties, string, n);
    }

    public void setDefault(String string, long l) {
        this.setValue(this.defaultProperties, string, l);
    }

    public void setDefault(String string, String string2) {
        this.setValue(this.defaultProperties, string, string2);
    }

    public void setDefault(String string, boolean bl) {
        this.setValue(this.defaultProperties, string, bl);
    }

    public void setValue(String string, double d) {
        double d2 = this.getDouble(string);
        if (d2 != d) {
            this.setValue(this.properties, string, d);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Double(d2), new Double(d));
        }
    }

    public void setValue(String string, float f) {
        float f2 = this.getFloat(string);
        if (f2 != f) {
            this.setValue(this.properties, string, f);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Float(f2), new Float(f));
        }
    }

    public void setValue(String string, int n) {
        int n2 = this.getInt(string);
        if (n2 != n) {
            this.setValue(this.properties, string, n);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Integer(n2), new Integer(n));
        }
    }

    public void setValue(String string, long l) {
        long l2 = this.getLong(string);
        if (l2 != l) {
            this.setValue(this.properties, string, l);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Long(l2), new Long(l));
        }
    }

    public void setValue(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null || !string3.equals(string2)) {
            this.setValue(this.properties, string, string2);
            this.dirty = true;
            this.firePropertyChangeEvent(string, string3, string2);
        }
    }

    public void setValue(String string, boolean bl) {
        boolean bl2 = this.getBoolean(string);
        if (bl2 != bl) {
            this.setValue(this.properties, string, bl);
            this.dirty = true;
            this.firePropertyChangeEvent(string, new Boolean(bl2), new Boolean(bl));
        }
    }

    public void putValue(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null || !string3.equals(string2)) {
            this.setValue(this.properties, string, string2);
            this.dirty = true;
        }
    }

    private void setValue(Properties properties, String string, double d) {
        this.put(properties, string, Double.toString(d));
    }

    private void setValue(Properties properties, String string, float f) {
        this.put(properties, string, Float.toString(f));
    }

    private void setValue(Properties properties, String string, int n) {
        this.put(properties, string, Integer.toString(n));
    }

    private void setValue(Properties properties, String string, long l) {
        this.put(properties, string, Long.toString(l));
    }

    private void setValue(Properties properties, String string, String string2) {
        this.put(properties, string, string2);
    }

    private void setValue(Properties properties, String string, boolean bl) {
        this.put(properties, string, bl ? "true" : "false");
    }

    protected void put(Properties properties, String string, String string2) {
        properties.put(string, string2);
    }

    public void addPreferenceChangeListener(IPreferenceChangeListener iPreferenceChangeListener) {
        if (!this.listeners.contains(iPreferenceChangeListener)) {
            this.listeners.addElement(iPreferenceChangeListener);
        }
    }

    public void removePreferenceChangeListener(IPreferenceChangeListener iPreferenceChangeListener) {
        this.listeners.removeElement(iPreferenceChangeListener);
    }

    protected void firePropertyChangeEvent(String string, Object object, Object object2) {
        if (!(this.listeners.size() <= 0 || object != null && object.equals(object2))) {
            PreferenceChangeEvent preferenceChangeEvent = new PreferenceChangeEvent(this, string, object, object2);
            for (int i = 0; i < this.listeners.size(); ++i) {
                IPreferenceChangeListener iPreferenceChangeListener = (IPreferenceChangeListener)this.listeners.elementAt(i);
                iPreferenceChangeListener.preferenceChange(preferenceChangeEvent);
            }
        }
    }

    public String[] getAdvancedProperties() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.properties.propertyNames();
        while (stringArray.hasMoreElements()) {
            String string = (String)stringArray.nextElement();
            if (!string.startsWith("Advanced")) continue;
            vector.addElement(string);
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }
}

