/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.util;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.IBoard;
import megamek.common.IHex;
import megamek.common.ITerrain;
import megamek.common.ITerrainFactory;
import megamek.common.MapSettings;
import megamek.common.Terrains;
import megamek.common.util.BuildingTemplate;

public class CityBuilder {
    static final int N = 0;
    static final int NE = 1;
    static final int SE = 2;
    static final int S = 3;
    static final int SW = 4;
    static final int NW = 5;
    static final int W = 6;
    static final int E = 7;
    private MapSettings mapSettings;
    private IBoard board;
    private HashSet<Coords> cityPlan;

    public CityBuilder(MapSettings mapSettings, IBoard iBoard) {
        this.mapSettings = mapSettings;
        this.board = iBoard;
    }

    public Vector generateCity(boolean bl) {
        int n = this.mapSettings.getBoardWidth();
        int n2 = this.mapSettings.getBoardHeight();
        int n3 = this.mapSettings.getCityBlocks();
        n3 = n3 * Math.min(n, n2) / 16;
        String string = this.mapSettings.getCityType();
        this.cityPlan = new HashSet();
        if (bl) {
            this.addGenericRoad();
        }
        if (string.equalsIgnoreCase("HUB")) {
            this.buildHubCity(n, n2, n3);
        } else if (string.equalsIgnoreCase("METRO")) {
            this.buildMetroCity(n, n2);
        } else if (string.equalsIgnoreCase("GRID")) {
            this.buildGridCity(n, n2, (n3 + 5) / 6);
        } else {
            if (string.equalsIgnoreCase("TOWN")) {
                return this.buildTown(n, n2, n3, this.mapSettings.getTownSize());
            }
            return new Vector();
        }
        return this.placeBuildings(0);
    }

    public Vector placeBuildings(int n) {
        int n2 = this.mapSettings.getBoardWidth();
        int n3 = this.mapSettings.getBoardHeight();
        Vector<BuildingTemplate> vector = new Vector<BuildingTemplate>();
        HashSet<Coords> hashSet = new HashSet<Coords>();
        Vector<Coords> vector2 = new Vector<Coords>();
        Coords coords = new Coords(n2 / 2, n3 / 2);
        double d = (double)this.mapSettings.getCityDensity() / (double)(n * n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                Coords coords2;
                int n4;
                Coords coords3 = new Coords(i, j);
                if (this.cityPlan.contains(coords3) || hashSet.contains(coords3) || !this.board.contains(coords3) || !this.isHexBuildable(this.board.getHex(coords3))) continue;
                int n5 = this.mapSettings.getCityDensity();
                if (n > 0) {
                    n4 = coords3.distance(coords);
                    n5 = (int)((double)this.mapSettings.getCityDensity() - d * (double)n4 * (double)n4);
                }
                if (Compute.randomInt(100) > n5) continue;
                vector2 = new Vector();
                vector2.add(coords3);
                hashSet.add(coords3);
                while (Compute.randomInt(100) < n5 && !this.cityPlan.contains(coords2 = coords3.translated(n4 = Compute.randomInt(6))) && !hashSet.contains(coords2) && this.board.contains(coords2) && this.isHexBuildable(this.board.getHex(coords2))) {
                    vector2.add(coords2);
                    hashSet.add(coords2);
                }
                n4 = this.mapSettings.getCityMaxFloors() - this.mapSettings.getCityMinFloors();
                n4 = n4 <= 0 ? this.mapSettings.getCityMinFloors() : Compute.randomInt(n4 + 1) + this.mapSettings.getCityMinFloors();
                int n6 = this.mapSettings.getCityMaxCF() - this.mapSettings.getCityMinCF();
                n6 = n6 <= 0 ? this.mapSettings.getCityMinCF() : Compute.randomInt(n6 + 1) + this.mapSettings.getCityMinCF();
                int n7 = CityBuilder.getBuildingTypeByCF(n6);
                vector.add(new BuildingTemplate(n7, vector2, n6, n4, -1));
            }
        }
        return vector;
    }

    private void buildGridCity(int n, int n2, int n3) {
        int n4;
        Coords coords;
        int n5;
        int n6;
        for (n6 = 0; n6 < n3; ++n6) {
            n5 = Compute.randomInt(n2 / n3) + n6 * n2 / n3;
            coords = new Coords(-1, n5);
            n4 = Compute.randomInt(2) + 1;
            int n7 = Compute.randomInt(2) + 1;
            this.buildStraightRoad(coords, n7, n4);
            n5 = Compute.randomInt(n2 / n3) + n6 * n2 / n3;
            coords = new Coords(n, n5);
            n7 = Compute.randomInt(2) + 4;
            this.buildStraightRoad(coords, n7, n4);
        }
        for (n6 = 0; n6 < n3; ++n6) {
            n5 = Compute.randomInt(n / n3) + n6 * (n / n3);
            coords = new Coords(n5, -1);
            n4 = Compute.randomInt(2) + 1;
            this.buildStraightRoad(coords, 3, n4);
        }
    }

    private Vector buildTown(int n, int n2, int n3, int n4) {
        this.buildHubCity(n, n2, n3 * n4 / 100);
        return this.placeBuildings(Math.min(n, n2) * n4 / 200);
    }

    private void buildHubCity(int n, int n2, int n3) {
        int n4 = n / 2;
        int n5 = n2 / 2;
        Vector<Integer> vector = new Vector<Integer>(8);
        vector.add(0);
        vector.add(1);
        vector.add(2);
        vector.add(3);
        vector.add(4);
        vector.add(5);
        vector.add(7);
        vector.add(6);
        n3 = Math.max(n3, 4);
        this.cityPlan.add(new Coords(n4, n5));
        int n6 = 0;
        int n7 = 0;
        block5: for (int i = 0; i < n3; ++i) {
            int n8 = -1;
            int n9 = Compute.randomInt(2) + 1;
            if (i < 8) {
                n6 = n4;
                n7 = n5;
                n8 = (Integer)vector.remove(Compute.randomInt(vector.size()));
            } else {
                switch (Compute.randomInt(4)) {
                    case 1: {
                        n6 = Compute.randomInt(n);
                        n7 = -1;
                        n8 = 3;
                        break;
                    }
                    case 2: {
                        n6 = Compute.randomInt(n);
                        n7 = n2;
                        n8 = 0;
                        break;
                    }
                    case 3: {
                        n6 = -1;
                        n7 = Compute.randomInt(n2);
                        n8 = 1 + Compute.randomInt(2);
                        break;
                    }
                    default: {
                        n6 = n;
                        n7 = Compute.randomInt(n2);
                        n8 = 4 + Compute.randomInt(2);
                    }
                }
            }
            Coords coords = new Coords(n6, n7);
            int n10 = n8;
            while (coords.x >= -1 && coords.x <= n && coords.y >= -1 && coords.y <= n2) {
                int n11 = Compute.randomInt(10);
                if (this.board.contains(coords) && n11 >= 4) {
                    n10 = n11 < 6 ? (5 + n10) % 6 : (n11 < 8 ? (1 + n10) % 6 : n8);
                }
                if ((coords = this.extendRoad(coords, n10, n9)) == null || this.cityPlan.contains(coords) && n6 != n4 && n7 != n5) continue block5;
                this.cityPlan.add(coords);
                n6 = coords.x;
                n7 = coords.y;
            }
        }
    }

    private void buildMetroCity(int n, int n2) {
        int n3 = n / 2;
        int n4 = n2 / 2;
        this.cityPlan.add(new Coords(n3, n4));
        for (int i = 0; i < 6; ++i) {
            this.cityPlan.add(new Coords(Coords.xInDir(n3, n4, i), Coords.yInDir(n3, n4, i)));
        }
        Coords coords = new Coords(-1, n4 / 2);
        this.buildStraightRoad(coords, 7, 1);
        coords = new Coords(-1, n4 + n4 / 2);
        this.buildStraightRoad(coords, 7, 1);
        coords = new Coords(n3 / 2, -1);
        this.buildStraightRoad(coords, 3, 1);
        coords = new Coords(n3 + n3 / 2, -1);
        this.buildStraightRoad(coords, 3, 1);
        for (int i = 0; i < 8; ++i) {
            coords = new Coords(n3, n4);
            this.buildStraightRoad(coords, i, 2);
        }
    }

    private Coords selectNextGrid(int n, Coords coords) {
        Coords coords2 = coords.translated(n);
        if (n == 7) {
            ++coords2.x;
        }
        if (n == 6) {
            --coords2.x;
        }
        return coords2;
    }

    private boolean isHexBuildable(IHex iHex) {
        if (iHex.containsTerrain(4) || iHex.containsTerrain(30) || iHex.containsTerrain(24) || iHex.containsTerrain(9)) {
            return false;
        }
        return iHex.getElevation() < 4;
    }

    private boolean hexNeedsBridge(IHex iHex) {
        if (iHex.containsTerrain(6) || iHex.containsTerrain(14)) {
            return false;
        }
        return iHex.containsTerrain(4) || iHex.containsTerrain(24);
    }

    private void addRoad(IHex iHex, int n, int n2) {
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        if (iHex.containsTerrain(4)) {
            iHex.removeTerrain(4);
            iHex.addTerrain(iTerrainFactory.createTerrain(4, 0));
            n2 = 1;
        }
        iHex.addTerrain(iTerrainFactory.createTerrain(6, n2, true, 1 << n & 0x3F));
    }

    private void addBridge(IHex iHex, int n, int n2, int n3) {
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        int n4 = n2 - iHex.getElevation();
        iHex.addTerrain(iTerrainFactory.createTerrain(14, CityBuilder.getBuildingTypeByCF(n3), true, n & 0x3F));
        iHex.addTerrain(iTerrainFactory.createTerrain(16, n4));
        iHex.addTerrain(iTerrainFactory.createTerrain(15, n3));
    }

    private void connectHexes(Coords coords, Coords coords2, int n) {
        if (this.board.contains(coords)) {
            IHex iHex = this.board.getHex(coords);
            ITerrain iTerrain = iHex.getTerrain(6);
            if (iTerrain == null) {
                iTerrain = iHex.getTerrain(14);
            }
            if (iTerrain == null) {
                this.addRoad(iHex, coords.direction(coords2), n);
            } else {
                iTerrain.setExit(coords.direction(coords2), true);
            }
        }
    }

    private Coords tryToBuildBridge(Coords coords, int n) {
        if (!this.board.contains(coords)) {
            return null;
        }
        Vector<Coords> vector = new Vector<Coords>(7);
        Coords coords2 = null;
        Coords coords3 = coords.translated(n);
        while (vector.size() < 6 && this.board.contains(coords3)) {
            if (!this.hexNeedsBridge(this.board.getHex(coords3))) {
                coords2 = coords3;
                break;
            }
            vector.add(coords3);
            coords3 = coords3.translated(n);
        }
        if (coords2 != null) {
            if (vector.size() == 0) {
                return null;
            }
            int n2 = this.board.getHex(coords).getElevation();
            int n3 = this.board.getHex(coords2).getElevation();
            int n4 = this.board.getHex(coords2).terrainLevel(14);
            if (n4 >= 0) {
                if (Math.abs(n3 + n4 - n2) > 2) {
                    return null;
                }
                n2 = n3 + n4;
            } else {
                if (Math.abs(n2 - n3) > 4) {
                    return null;
                }
                n2 = (n2 + n3) / 2;
            }
            int n5 = 1 << n | 1 << (n + 3) % 6;
            int n6 = this.mapSettings.getCityMinCF() + Compute.randomInt(1 + this.mapSettings.getCityMaxCF() - this.mapSettings.getCityMinCF());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Coords coords4 = (Coords)enumeration.nextElement();
                this.addBridge(this.board.getHex(coords4), n5, n2, n6);
            }
            this.connectHexes(coords, (Coords)vector.firstElement(), 1);
            this.connectHexes(coords2, (Coords)vector.lastElement(), 1);
        }
        return coords2;
    }

    private Coords extendRoad(Coords coords, int n, int n2) {
        Coords coords2 = this.selectNextGrid(n, coords);
        if (this.board.contains(coords2) && this.hexNeedsBridge(this.board.getHex(coords2))) {
            if (n == 7 || n == 6) {
                n = coords.direction(coords2);
            }
            Coords coords3 = this.tryToBuildBridge(coords, n);
            return coords3;
        }
        this.connectHexes(coords, coords2, n2);
        this.connectHexes(coords2, coords, n2);
        return coords2;
    }

    private Coords resumeAfterObstacle(Coords coords, int n) {
        Coords coords2 = this.selectNextGrid(n, coords);
        while (this.board.contains(coords2) && !this.isHexBuildable(this.board.getHex(coords2))) {
            coords2 = this.selectNextGrid(n, coords2);
        }
        return coords2;
    }

    private void buildStraightRoad(Coords coords, int n, int n2) {
        Coords coords2 = coords;
        while (coords2 != null && coords2.x <= this.board.getWidth() && coords2.x >= -1 && coords2.y <= this.board.getHeight() && coords2.y >= -1) {
            this.cityPlan.add(coords2);
            Coords coords3 = this.extendRoad(coords2, n, n2);
            if (coords3 == null) {
                coords2 = this.resumeAfterObstacle(coords2, n);
                continue;
            }
            coords2 = coords3;
        }
    }

    public static int getBuildingTypeByCF(int n) {
        if (n <= 15) {
            return 1;
        }
        if (n <= 40) {
            return 2;
        }
        if (n <= 90) {
            return 3;
        }
        return 4;
    }

    private void addGenericRoad() {
        Coords coords = new Coords(Compute.randomInt(this.board.getWidth()), Compute.randomInt(this.board.getHeight()));
        int n = Compute.randomInt(6);
        int n2 = Compute.randomInt(5);
        if (n2 >= n) {
            ++n2;
        }
        this.buildStraightRoad(coords, n, 1);
        this.buildStraightRoad(coords, n2, 1);
    }
}

