/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import megamek.common.util.Categorized;
import megamek.common.util.Collections;
import megamek.common.util.ItemFile;
import megamek.common.util.ItemFileFactory;
import megamek.common.util.StringUtil;

public class ZippedItems
implements Categorized {
    private String rootName;
    private TreeMap categories = new TreeMap(StringUtil.stringComparator());
    private ItemFileFactory factory = null;

    public static boolean isZipName(String string) {
        String string2 = string.toUpperCase();
        return string2.endsWith("ZIP") || string2.endsWith("JAR");
    }

    public ZippedItems(File file, String string, ItemFileFactory itemFileFactory) throws IllegalArgumentException, ZipException, IOException {
        Enumeration<ZipEntry> enumeration = null;
        ZipEntry zipEntry = null;
        String string2 = null;
        String string3 = null;
        TreeMap treeMap = null;
        if (null == file) {
            throw new IllegalArgumentException("A null ZIP file was passed.");
        }
        if (null == itemFileFactory) {
            throw new IllegalArgumentException("A null item factory was passed.");
        }
        this.rootName = string;
        this.factory = itemFileFactory;
        if (null == this.rootName) {
            this.rootName = file.getName();
        }
        ZipFile zipFile = new ZipFile(file);
        Vector<ZipEntry> vector = new Vector<ZipEntry>();
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>(StringUtil.stringComparator());
        enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            string3 = zipEntry.getName();
            if (zipEntry.isDirectory()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.rootName).append(" : ").append(string3);
                string2 = stringBuffer.toString();
                this.categories.put(string2, new TreeMap(StringUtil.stringComparator()));
                treeMap2.put(string3, string2);
                continue;
            }
            if (ZippedItems.isZipName(string3)) {
                System.out.print("... found a ZIP file **inside** a ZIP file: ");
                System.out.println(string3);
                continue;
            }
            if (!this.factory.accept(zipFile, string3)) continue;
            vector.addElement(zipEntry);
        }
        this.categories.put(this.rootName, new TreeMap(StringUtil.stringComparator()));
        treeMap2.put(this.rootName, this.rootName);
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            string3 = zipEntry.getName();
            int n = string3.lastIndexOf("/");
            if (n < 0) {
                string2 = this.rootName;
            } else {
                string2 = string3.substring(0, ++n);
                if (null == (string2 = (String)treeMap2.get(string2))) {
                    string2 = this.rootName;
                } else {
                    string3 = string3.substring(n);
                }
            }
            treeMap = (TreeMap)this.categories.get(string2);
            treeMap.put(string3, this.factory.getItemFile(zipEntry, zipFile));
        }
        enumeration = Collections.elements(treeMap2.values());
        while (enumeration.hasMoreElements()) {
            string2 = (String)((Object)enumeration.nextElement());
            treeMap = (TreeMap)this.categories.get(string2);
            if (!treeMap.isEmpty()) continue;
            this.categories.remove(string2);
        }
    }

    public Enumeration getCategoryNames() {
        return Collections.elements(this.categories.keySet());
    }

    public Enumeration getItemNames(String string) {
        TreeMap treeMap = (TreeMap)this.categories.get(string);
        return Collections.elements(treeMap.keySet());
    }

    public Object getItem(String string, String string2) throws Exception {
        TreeMap treeMap = (TreeMap)this.categories.get(string);
        if (!treeMap.containsKey(string2)) {
            return null;
        }
        ItemFile itemFile = (ItemFile)treeMap.get(string2);
        return itemFile.getItem();
    }
}

