/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

public final class IntQueue {
    private final int[] data;
    private int writePointer = 0;
    private int readPointer = 0;
    private boolean empty = true;

    public IntQueue(int n) {
        this.data = new int[n];
    }

    public void write(int n) {
        if (!this.empty && this.writePointer == this.readPointer) {
            throw new OverflowException();
        }
        this.data[this.writePointer++] = n;
        if (this.writePointer == this.data.length) {
            this.writePointer = 0;
        }
        this.empty = false;
    }

    public int read() {
        if (this.empty) {
            throw new NothingToReadException();
        }
        int n = this.data[this.readPointer++];
        if (this.readPointer == this.data.length) {
            this.readPointer = 0;
        }
        if (this.readPointer == this.writePointer) {
            this.empty = true;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public static class NothingToReadException
    extends RuntimeException {
    }

    public static class OverflowException
    extends RuntimeException {
    }
}

