/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.dialog.AdvanceTerrainDialog;
import admin.dialog.BannedAmmoDialog;
import admin.dialog.ServerConfigurationDialog;
import client.MWClient;
import client.gui.dialog.CommandDialog;
import client.gui.dialog.HouseNameDialog;
import client.gui.dialog.PlanetNameDialog;
import client.gui.dialog.TraitDialog;
import client.gui.dialog.UnitViewerDialog;
import common.Continent;
import common.Planet;
import common.PlanetEnvironment;
import common.UnitFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import megamek.client.ui.AWT.UnitLoadingDialog;

public class AdminMenu
extends JMenu {
    JMenu jMenuAdminSubSave = new JMenu();
    JMenu jMenuAdminSubSet = new JMenu();
    JMenu jMenuAdminSubCreate = new JMenu();
    JMenu jMenuAdminSubDestroy = new JMenu();
    JMenuItem jMenuAdminServerConfig = new JMenuItem();
    JMenuItem jMenuAdminTerminateAll = new JMenuItem();
    JMenuItem jMenuAdminCreatePlanet = new JMenuItem();
    JMenuItem jMenuAdminDestroyPlanet = new JMenuItem();
    JMenuItem jMenuAdminCreateFactory = new JMenuItem();
    JMenuItem jMenuAdminDestroyFactory = new JMenuItem();
    JMenuItem jMenuAdminCreateTerrain = new JMenuItem();
    JMenuItem jMenuAdminDestroyTerrain = new JMenuItem();
    JMenuItem jMenuAdminResetAllInfluence = new JMenuItem();
    JMenuItem jMenuAdminChangePlanetOwner = new JMenuItem();
    JMenuItem jMenuAdminHouseAmmoBan = new JMenuItem();
    JMenuItem jMenuAdminSetHouseFluFile = new JMenuItem();
    JMenuItem jMenuAdminSetHouseComponentMod = new JMenuItem();
    JMenuItem jMenuAdminSetHousePriceMod = new JMenuItem();
    JMenuItem jMenuAdminSetFactionTraits = new JMenuItem();
    JMenuItem jMenuAdminSaveTheUniverse = new JMenuItem();
    JMenuItem jMenuAdminSavePlanetsToXML = new JMenuItem();
    JMenuItem jMenuAdminSaveServerConfigs = new JMenuItem();
    JMenuItem jMenuAdminSaveCommandLevels = new JMenuItem();
    JMenuItem jMenuAdminGrantComponents = new JMenuItem();
    JMenuItem jMenuAdminExchangePlanetOwnership = new JMenuItem();
    JMenuItem jMenuAdminLockFactory = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetMapSize = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetBoardSize = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetTemperature = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetGravity = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetVacuum = new JMenuItem();
    JMenuItem jMenuAdminSetServerAmmoBan = new JMenuItem();
    JMenuItem jMenuAdminSetCommandLevel = new JMenuItem();
    JMenuItem jMenuAdminSetAdvanceTerrain = new JMenuItem();
    JMenuItem jMenuAdminSetMegaMekGameOptions = new JMenuItem();
    JMenuItem jMenuAdminRemoveOMG = new JMenuItem();
    JMenuItem jMenuAdminOmniVariantMod = new JMenuItem();
    JMenuItem jMenuAdminCommandLists = new JMenuItem();
    MWClient mwclient;
    private int userLevel = 0;

    public AdminMenu() {
        super("Server Configs");
    }

    public void createMenu(MWClient client) {
        this.mwclient = client;
        this.userLevel = this.mwclient.getUser(this.mwclient.getUsername()).getUserlevel();
        this.jMenuAdminSubSave.setText("Save");
        this.jMenuAdminSubSet.setText("Set");
        this.jMenuAdminSubCreate.setText("Create");
        this.jMenuAdminSubDestroy.setText("Destroy");
        this.jMenuAdminCreatePlanet.setText("Create Planet");
        this.jMenuAdminCreatePlanet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminCreatePlanet_actionPerformed(e);
            }
        });
        this.jMenuAdminDestroyPlanet.setText("Destroy Planet");
        this.jMenuAdminDestroyPlanet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminDestroyPlanet_actionPerformed(e);
            }
        });
        this.jMenuAdminCreateFactory.setText("Create Factory");
        this.jMenuAdminCreateFactory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminCreateFactory_actionPerformed(e);
            }
        });
        this.jMenuAdminDestroyFactory.setText("Destroy Factory");
        this.jMenuAdminDestroyFactory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminDestroyFactory_actionPerformed(e);
            }
        });
        this.jMenuAdminCreateTerrain.setText("Create Terrain");
        this.jMenuAdminCreateTerrain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminCreateTerrain_actionPerformed(e);
            }
        });
        this.jMenuAdminDestroyTerrain.setText("Destroy Terrain");
        this.jMenuAdminDestroyTerrain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminDestroyTerrain_actionPerformed(e);
            }
        });
        this.jMenuAdminResetAllInfluence.setText("Reset All Planet Influence");
        this.jMenuAdminResetAllInfluence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminResetAllInfluence_actionPerformed(e);
            }
        });
        this.jMenuAdminHouseAmmoBan.setText("Set Banned Ammo");
        this.jMenuAdminHouseAmmoBan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminHouseAmmoBan_actionPerformed(e);
            }
        });
        this.jMenuAdminChangePlanetOwner.setText("Change Planet Owner");
        this.jMenuAdminChangePlanetOwner.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminChangePlanetOwner_actionPerformed(e);
            }
        });
        this.jMenuAdminServerConfig.setText("Server Configuration");
        this.jMenuAdminServerConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new ServerConfigurationDialog(AdminMenu.this.mwclient);
            }
        });
        this.jMenuAdminTerminateAll.setText("Terminate All Games");
        this.jMenuAdminTerminateAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminTerminateAll_actionPerformed(e);
            }
        });
        this.jMenuAdminSetFactionTraits.setText("Faction Traits");
        this.jMenuAdminSetFactionTraits.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new TraitDialog(AdminMenu.this.mwclient, false);
            }
        });
        this.jMenuAdminSetHouseFluFile.setText("Set House Flu File");
        this.jMenuAdminSetHouseFluFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetHouseFluFile_actionPerformed(e);
            }
        });
        this.jMenuAdminSetHouseComponentMod.setText("Set House Componet Mod");
        this.jMenuAdminSetHouseComponentMod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetHouseComponentMod_actionPerformed(e);
            }
        });
        this.jMenuAdminSetHousePriceMod.setText("Set House Price Mod");
        this.jMenuAdminSetHousePriceMod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetHousePriceMod_actionPerformed(e);
            }
        });
        this.jMenuAdminSaveTheUniverse.setText("Save The Universe");
        this.jMenuAdminSaveTheUniverse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSaveTheUniverse_actionPerformed(e);
            }
        });
        this.jMenuAdminSavePlanetsToXML.setText("Save Planets to XML");
        this.jMenuAdminSavePlanetsToXML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSavePlanetsToXML_actionPerformed(e);
            }
        });
        this.jMenuAdminRemoveOMG.setText("List and Remove OMG Units");
        this.jMenuAdminRemoveOMG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminlistandremoveomg");
            }
        });
        this.jMenuAdminGrantComponents.setText("Grant Components");
        this.jMenuAdminGrantComponents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminGrantComponents_actionPerformed(e);
            }
        });
        this.jMenuAdminExchangePlanetOwnership.setText("Exchange Planet Ownership");
        this.jMenuAdminExchangePlanetOwnership.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminExchangePlanetOwnership_actionPerformed(e);
            }
        });
        this.jMenuAdminLockFactory.setText("Lock Factory");
        this.jMenuAdminLockFactory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminLockFactory_actionPerformed(e);
            }
        });
        this.jMenuAdminSaveServerConfigs.setText("Save Server Configuration");
        this.jMenuAdminSaveServerConfigs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c AdminSaveServerConfigs");
                AdminMenu.this.mwclient.reloadData();
            }
        });
        this.jMenuAdminSaveCommandLevels.setText("Save Command Levels");
        this.jMenuAdminSaveCommandLevels.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c AdminSaveCommandLevels");
            }
        });
        this.jMenuAdminSetPlanetMapSize.setText("Set Planet Map Size");
        this.jMenuAdminSetPlanetMapSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetPlanetMapSize_actionPerformed(e);
            }
        });
        this.jMenuAdminSetPlanetBoardSize.setText("Set Planet Board Size");
        this.jMenuAdminSetPlanetBoardSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetPlanetBoardSize_actionPerformed(e);
            }
        });
        this.jMenuAdminSetPlanetTemperature.setText("Set Planet Temperature");
        this.jMenuAdminSetPlanetTemperature.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetPlanetTemperature_actionPerformed(e);
            }
        });
        this.jMenuAdminSetPlanetGravity.setText("Set Planet Gravity");
        this.jMenuAdminSetPlanetGravity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetPlanetGravity_actionPerformed(e);
            }
        });
        this.jMenuAdminSetPlanetVacuum.setText("Set Planet Vacuum");
        this.jMenuAdminSetPlanetVacuum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c AdminSetPlanetVacuum");
                AdminMenu.this.mwclient.reloadData();
            }
        });
        this.jMenuAdminSetServerAmmoBan.setText("Set Server Ammo Ban");
        this.jMenuAdminSetServerAmmoBan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminServerAmmoBan_actionPerformed(e);
            }
        });
        this.jMenuAdminOmniVariantMod.setText("Set Omni Variant Mod");
        this.jMenuAdminOmniVariantMod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminOmniVariantMod_actionPerformed(e);
            }
        });
        this.jMenuAdminSetCommandLevel.setText("Set Command Level");
        this.jMenuAdminSetCommandLevel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetCommandLevel_actionPerformed(e);
            }
        });
        this.jMenuAdminSetAdvanceTerrain.setText("Advance Terrain");
        this.jMenuAdminSetAdvanceTerrain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetAdvanceTerrain_actionPerformed(e);
            }
        });
        this.jMenuAdminCommandLists.setText("List Commands");
        this.jMenuAdminCommandLists.setMnemonic('L');
        this.jMenuAdminCommandLists.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminCommandLists_actionPerformed(e);
            }
        });
        this.jMenuAdminSetMegaMekGameOptions.setText("Set MegaMek Game Options");
        this.jMenuAdminSetMegaMekGameOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.mwclient.LoadMegaMekClient();
            }
        });
        this.removeAll();
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminChangeServerConfig")) {
            this.add(this.jMenuAdminServerConfig);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminTerminateAll")) {
            this.add(this.jMenuAdminTerminateAll);
        }
        if (this.getItemCount() > 0) {
            this.addSeparator();
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminCreatePlanet")) {
            this.jMenuAdminSubCreate.add(this.jMenuAdminCreatePlanet);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminCreateFactory")) {
            this.jMenuAdminSubCreate.add(this.jMenuAdminCreateFactory);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminCreateTerrain")) {
            this.jMenuAdminSubCreate.add(this.jMenuAdminCreateTerrain);
        }
        if (this.jMenuAdminSubCreate.getItemCount() > 0) {
            this.add(this.jMenuAdminSubCreate);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminDestroyPlanet")) {
            this.jMenuAdminSubDestroy.add(this.jMenuAdminDestroyPlanet);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminDestroyFactory")) {
            this.jMenuAdminSubDestroy.add(this.jMenuAdminDestroyFactory);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminDestroyTerrain")) {
            this.jMenuAdminSubDestroy.add(this.jMenuAdminDestroyTerrain);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminListAndRemoveOMG")) {
            this.jMenuAdminSubDestroy.add(this.jMenuAdminRemoveOMG);
        }
        if (this.jMenuAdminSubDestroy.getItemCount() > 0) {
            this.add(this.jMenuAdminSubDestroy);
        }
        JMenu jMenuAdminSubSetHouse = new JMenu();
        JMenu jMenuAdminSubSetPlanet = new JMenu();
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminChangePlanetOwner")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminChangePlanetOwner);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetHouseFluFile")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminSetHouseFluFile);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetHousePriceMod")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminSetHousePriceMod);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSsetHouseComponentMod")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminSetHouseComponentMod);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminGrantComponents")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminGrantComponents);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminExchangePlanetOwnership")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminExchangePlanetOwnership);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetHouseAmmoBan")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminHouseAmmoBan);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AddTrait")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminSetFactionTraits);
        }
        jMenuAdminSubSetHouse.setText("Factions");
        if (jMenuAdminSubSetHouse.getItemCount() > 0) {
            this.jMenuAdminSubSet.add(jMenuAdminSubSetHouse);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminLockFactory")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminLockFactory);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetPlanetMapSize")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetMapSize);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetPlanetBoardSize")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetBoardSize);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetPlanetTemperature")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetTemperature);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetPlanetGravity")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetGravity);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetPlanetVacuum")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetVacuum);
        }
        jMenuAdminSubSetPlanet.setText("Planets");
        if (jMenuAdminSubSetPlanet.getItemCount() > 0) {
            this.jMenuAdminSubSet.add(jMenuAdminSubSetPlanet);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetServerAmmoBan")) {
            this.jMenuAdminSubSet.add(this.jMenuAdminSetServerAmmoBan);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetCommandLevel")) {
            this.jMenuAdminSubSet.add(this.jMenuAdminSetCommandLevel);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AddOmniVariantMod")) {
            this.jMenuAdminSubSet.add(this.jMenuAdminOmniVariantMod);
        }
        if (this.userLevel >= 200) {
            this.jMenuAdminSubSet.addSeparator();
            this.jMenuAdminSubSet.add(this.jMenuAdminSetMegaMekGameOptions);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("SetAdvancePlanetTerrain") && Boolean.valueOf(this.mwclient.getserverConfigs("UseStaticMaps")).booleanValue()) {
            this.jMenuAdminSubSet.add(this.jMenuAdminSetAdvanceTerrain);
        }
        if (this.jMenuAdminSubSet.getItemCount() > 0) {
            this.add(this.jMenuAdminSubSet);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSave")) {
            this.jMenuAdminSubSave.add(this.jMenuAdminSaveTheUniverse);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSavePlanetsToXML")) {
            this.jMenuAdminSubSave.add(this.jMenuAdminSavePlanetsToXML);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSaveServerConfigs")) {
            this.jMenuAdminSubSave.add(this.jMenuAdminSaveServerConfigs);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSaveCommandLevels")) {
            this.jMenuAdminSubSave.add(this.jMenuAdminSaveCommandLevels);
        }
        if (this.jMenuAdminSubSave.getItemCount() > 0) {
            this.add(this.jMenuAdminSubSave);
            this.addSeparator();
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminResetAllInfluence")) {
            this.add(this.jMenuAdminResetAllInfluence);
        }
        if (this.userLevel >= 101) {
            this.add(this.jMenuAdminCommandLists);
        }
    }

    public void jMenuAdminCreatePlanet_actionPerformed(ActionEvent e) {
        String planetName = JOptionPane.showInputDialog(null, (Object)"Planet Name?");
        if (planetName == null || planetName.length() == 0) {
            return;
        }
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false);
        factionDialog.setVisible(true);
        String planetFaction = factionDialog.getHouseName();
        factionDialog.dispose();
        if (planetFaction == null || planetFaction.length() == 0) {
            return;
        }
        String commodProduction = JOptionPane.showInputDialog(null, (Object)"Planet commodity production rate?");
        if (commodProduction == null || commodProduction.length() == 0) {
            return;
        }
        String xcord = JOptionPane.showInputDialog(null, (Object)"Planet x coord");
        if (xcord == null || xcord.length() == 0) {
            return;
        }
        String ycord = JOptionPane.showInputDialog(null, (Object)"Planet y coord?");
        if (ycord == null || ycord.length() == 0) {
            return;
        }
        String bays = JOptionPane.showInputDialog(null, (Object)"Planet warefactions?");
        if (bays == null || bays.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c admincreateplanet#" + planetFaction + "#" + planetName + "#" + commodProduction + "#" + xcord + "#" + ycord + "#" + bays);
        this.mwclient.reloadData();
    }

    public void jMenuAdminDestroyPlanet_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet");
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c admindestroyplanet#" + planetNamestr);
        this.mwclient.reloadData();
    }

    public void jMenuAdminCreateFactory_actionPerformed(ActionEvent e) {
        String factoryTimeZone;
        int i;
        Object[] factoryTypes = new Object[]{"All", "Mek", "Vehicles", "Mek & Vehicles", "Infantry", "Mek & Infantry", "Vehicles & Infantry", "Mek & Infantry & Vehicles", "ProtoMeks", "Mek & ProtoMeks", "Vehicles & ProtoMek", "Mek & Vehicles & ProtoMek", "Infantry & ProtoMek", "Mek & Infantry & ProtoMek", "Vehicles & Infantry & ProtoMek", "Mek & Vehicles & Infantry & ProtoMek", "BattleArmor", "Mek & BattleArmor", "Vehicles & BattleArmor", "Mek & Vehicles & BattleArmor", "Infantry & BattleArmor", "Mek & Infantry & BattleArmor", "Vehicles & Infantry & BattleArmor", "Mek & Vehicles & Infantry & BattleArmor", "ProtoMeks & BattleArmor", "Mek & ProtoMeks & BattleArmor", "Vehicles & ProtoMek & BattleArmor", "Mek & Vehicles & ProtoMek & BattleArmor", "Infantry & ProtoMek & BattleArmor", "Mek & Infantry & ProtoMek & BattleArmor", "Vehicles & Infantry & ProtoMek & BattleArmor"};
        Object[] factorySize = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet");
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String factoryName = JOptionPane.showInputDialog(null, (Object)"Factory Name");
        if (factoryName == null || factoryName.length() == 0) {
            return;
        }
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String factoryTypestr = (String)JOptionPane.showInputDialog(null, "Select factory production", "Factory Production", 1, null, factoryTypes, factoryTypes[0]);
        if (factoryTypestr == null || factoryTypestr.length() == 0) {
            return;
        }
        for (i = 0; i < factoryTypes.length && !factoryTypestr.equals(factoryTypes[i]); ++i) {
        }
        int factoryTypeint = i;
        String factorySizestr = (String)JOptionPane.showInputDialog(null, "Select a factory size", "FactorySize", 1, null, factorySize, factorySize[0]);
        if (factorySizestr == null || factorySizestr.length() == 0) {
            return;
        }
        String sendCommand = planetNamestr.trim() + "#" + factoryName.trim() + "#" + factorySizestr.trim() + "#" + factionName.trim() + "#" + factoryTypeint;
        while ((factoryTimeZone = JOptionPane.showInputDialog(null, (Object)"Factory Time Zone?")) != null && factoryTimeZone.length() != 0) {
            sendCommand = sendCommand + "#" + factoryTimeZone;
            String factoryTimeZoneProbability = JOptionPane.showInputDialog(null, (Object)"Factory Time Zone Probability?");
            if (factoryTimeZoneProbability == null || factoryTimeZoneProbability.length() == 0) {
                sendCommand = sendCommand + "#0";
                break;
            }
            sendCommand = sendCommand + "#" + factoryTimeZoneProbability;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c admincreatefactory#" + sendCommand);
        this.mwclient.reloadData();
    }

    public void jMenuAdminDestroyFactory_actionPerformed(ActionEvent e) {
        TreeSet<String> names = new TreeSet<String>();
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet");
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        Planet planet = this.mwclient.getData().getPlanetByName(planetNamestr);
        names.clear();
        Iterator UF = planet.getUnitFactories().iterator();
        while (UF.hasNext()) {
            names.add(((UnitFactory)UF.next()).getName());
        }
        JComboBox<Object> combo = new JComboBox<Object>(names.toArray());
        combo.setEditable(true);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select factory to destroy.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        String factoryName = (String)combo.getSelectedItem();
        if (factoryName == null || factoryName.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c admindestroyfactory#" + planetNamestr + "#" + factoryName);
        this.mwclient.reloadData();
    }

    public void jMenuAdminCreateTerrain_actionPerformed(ActionEvent e) {
        TreeSet<String> names = new TreeSet<String>();
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet");
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        Iterator it = this.mwclient.getData().getAllTerrains().iterator();
        while (it.hasNext()) {
            names.add(((PlanetEnvironment)it.next()).getName());
        }
        JComboBox<Object> combo = new JComboBox<Object>(names.toArray());
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select a Terrain Type.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        String terrainType = (String)combo.getSelectedItem();
        int value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        if (terrainType == null || terrainType.length() == 0) {
            return;
        }
        String terrainChance = JOptionPane.showInputDialog(null, "Terrain Chance", new Integer(100));
        if (terrainChance == null || terrainChance.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c admincreateterrain#" + planetNamestr + "#" + terrainType + "#" + terrainChance);
        this.mwclient.reloadData();
    }

    public void jMenuAdminDestroyTerrain_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet");
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String terrainType = JOptionPane.showInputDialog(null, (Object)"Select the Terrain position: start with 0 for the top most terrain in the information box");
        if (terrainType == null || terrainType.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c admindestroyterrain#" + planetNamestr + "#" + terrainType);
        this.mwclient.reloadData();
    }

    public void jMenuAdminChangePlanetOwner_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet");
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "New Owner", false);
        factionDialog.setVisible(true);
        String newOwner = factionDialog.getHouseName();
        factionDialog.dispose();
        if (newOwner == null || newOwner.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminchangeplanetowner#" + planetNamestr + "#" + newOwner);
        this.mwclient.reloadData();
    }

    public void jMenuAdminTerminateAll_actionPerformed(ActionEvent e) {
        int confirm = JOptionPane.showConfirmDialog(null, "Are you sure you want to terminate all waiting/running games?");
        if (confirm != 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminterminateall");
    }

    public void jMenuAdminResetAllInfluence_actionPerformed(ActionEvent e) {
        int confirm = JOptionPane.showConfirmDialog(null, "Are you sure you want to reset all the planets influence back to 100% for the owners?");
        if (confirm != 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminresetallinfluence");
        this.mwclient.reloadData();
    }

    public void jMenuAdminSetHouseFluFile_actionPerformed(ActionEvent e) {
        String factionName = JOptionPane.showInputDialog(null, (Object)"House Name:");
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        String fluFilePrefix = JOptionPane.showInputDialog(null, (Object)(this.mwclient.moneyOrFluMessage(false, true, -1) + " File Prefix:"));
        if (fluFilePrefix == null || fluFilePrefix.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsethouseflufile#" + factionName + "#" + fluFilePrefix);
    }

    public void jMenuAdminGrantComponents_actionPerformed(ActionEvent e) {
        Object[] Types = new Object[]{"Mek", "Vehicles", "Infantry", "ProtoMek", "BattleArmor"};
        Object[] Size = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        String Typestr = (String)JOptionPane.showInputDialog(null, "Select component type", "Component Type", 1, null, Types, Types[0]);
        if (Typestr == null || Typestr.length() == 0) {
            return;
        }
        String Sizestr = (String)JOptionPane.showInputDialog(null, "Select a component size", "Component Size", 1, null, Size, Size[0]);
        if (Sizestr == null || Sizestr.length() == 0) {
            return;
        }
        String components = JOptionPane.showInputDialog(null, (Object)"Amount of Components to add(negative number to subtract)");
        if (components == null || components.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c admingrantcomponents#" + factionName + "#" + Typestr + "#" + Sizestr + "#" + components);
    }

    public void jMenuAdminExchangePlanetOwnership_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Planet");
        planetDialog.setVisible(true);
        String planetName = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetName == null || planetName.length() == 0) {
            return;
        }
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Gaining Faction", false);
        factionDialog.setVisible(true);
        String winningHouseName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (winningHouseName == null || winningHouseName.length() == 0) {
            return;
        }
        factionDialog = new HouseNameDialog(this.mwclient, "Losing Faction", false);
        factionDialog.setVisible(true);
        String losingHouseName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (losingHouseName == null || losingHouseName.length() == 0) {
            return;
        }
        String amount = JOptionPane.showInputDialog(null, (Object)"Amount");
        if (amount == null || amount.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminexchangeplanetownership#" + planetName + "#" + winningHouseName + "#" + losingHouseName + "#" + amount);
    }

    public void jMenuAdminSetHousePriceMod_actionPerformed(ActionEvent e) {
        Object[] unitTypes = new Object[]{"Mek", "Vehicles", "Infantry"};
        Object[] unitClass = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        String unitTypestr = (String)JOptionPane.showInputDialog(null, "Select Unit Type", "Unit Type", 1, null, unitTypes, unitTypes[0]);
        if (unitTypestr == null || unitTypestr.length() == 0) {
            return;
        }
        String unitClassstr = (String)JOptionPane.showInputDialog(null, "Select Unit Class", "Unit Class", 1, null, unitClass, unitClass[0]);
        if (unitClassstr == null || unitClassstr.length() == 0) {
            return;
        }
        String priceMod = JOptionPane.showInputDialog(null, (Object)"Price Modifier:");
        if (priceMod == null || priceMod.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsethousepricemod#" + factionName + "#" + unitTypestr + "#" + unitClassstr + "#" + priceMod);
    }

    public void jMenuAdminSetHouseComponentMod_actionPerformed(ActionEvent e) {
        Object[] unitTypes = new Object[]{"Mek", "Vehicles", "Infantry"};
        Object[] unitClass = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        String unitTypestr = (String)JOptionPane.showInputDialog(null, "Select Unit Type", "Unit Type", 1, null, unitTypes, unitTypes[0]);
        if (unitTypestr == null || unitTypestr.length() == 0) {
            return;
        }
        String unitClassstr = (String)JOptionPane.showInputDialog(null, "Select Unit Class", "Unit Class", 1, null, unitClass, unitClass[0]);
        if (unitClassstr == null || unitClassstr.length() == 0) {
            return;
        }
        String componentMod = JOptionPane.showInputDialog(null, (Object)"Component Modifier:");
        if (componentMod == null || componentMod.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsethousecomponentmod#" + factionName + "#" + unitTypestr + "#" + unitClassstr + "#" + componentMod);
    }

    public void jMenuAdminSaveTheUniverse_actionPerformed(ActionEvent e) {
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsave");
    }

    public void jMenuAdminSavePlanetsToXML_actionPerformed(ActionEvent e) {
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsaveplanetstoxml");
    }

    public void jMenuAdminOmniVariantMod_actionPerformed(ActionEvent e) {
        UnitLoadingDialog unitLoadingDialog = new UnitLoadingDialog(this.mwclient.getMainFrame());
        UnitViewerDialog unitSelector = new UnitViewerDialog(this.mwclient.getMainFrame(), unitLoadingDialog, this.mwclient, 1);
        unitSelector.setName("Unit Selector");
        new Thread(unitSelector).start();
    }

    public void jMenuAdminServerAmmoBan_actionPerformed(ActionEvent e) {
        new BannedAmmoDialog(this.mwclient, null);
    }

    public void jMenuAdminHouseAmmoBan_actionPerformed(ActionEvent e) {
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Select Faction", false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        new BannedAmmoDialog(this.mwclient, this.mwclient.getData().getHouseByName(factionName));
    }

    public void jMenuAdminSetCommandLevel_actionPerformed(ActionEvent e) {
        TreeSet<String> names = new TreeSet<String>();
        Enumeration<String> commands = this.mwclient.getData().getCommandTable().keys();
        Enumeration<Integer> accessLevels = this.mwclient.getData().getCommandTable().elements();
        while (commands.hasMoreElements()) {
            String command = commands.nextElement();
            Integer accessLevel = accessLevels.nextElement();
            if (accessLevel > this.userLevel) continue;
            names.add(command);
        }
        JComboBox<Object> combo = new JComboBox<Object>(names.toArray());
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select Command");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        String command = (String)combo.getSelectedItem();
        int value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        String level = JOptionPane.showInputDialog(null, (Object)"Level");
        if (level == null || level.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsetCommandLevel#" + command + "#" + level);
    }

    public void jMenuAdminSetAdvanceTerrain_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select Planet");
        planetDialog.setVisible(true);
        String planetName = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetName == null || planetName.length() == 0) {
            return;
        }
        Planet cPlanet = this.mwclient.getData().getPlanetByName(planetName);
        TreeSet<String> names = new TreeSet<String>();
        Iterator envList = cPlanet.getEnvironments().iterator();
        while (envList.hasNext()) {
            Continent pEnv = (Continent)envList.next();
            names.add(pEnv.getEnvironment().getName());
        }
        JComboBox<Object> combo = new JComboBox<Object>(names.toArray());
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select terrain to edit");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        String terrainName = (String)combo.getSelectedItem();
        if (terrainName == null || terrainName.length() == 0) {
            return;
        }
        envList = cPlanet.getEnvironments().iterator();
        while (envList.hasNext()) {
            Continent pEnv = (Continent)envList.next();
            if (!pEnv.getEnvironment().getName().equalsIgnoreCase(terrainName)) continue;
            new AdvanceTerrainDialog(this.mwclient, planetName, pEnv.getEnvironment().getId());
            break;
        }
    }

    public void jMenuAdminLockFactory_actionPerformed(ActionEvent e) {
        TreeSet<String> names = new TreeSet<String>();
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet");
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        Planet planet = this.mwclient.getData().getPlanetByName(planetNamestr);
        Iterator UF = planet.getUnitFactories().iterator();
        while (UF.hasNext()) {
            names.add(((UnitFactory)UF.next()).getName());
        }
        JComboBox<Object> combo = new JComboBox<Object>(names.toArray());
        combo.setEditable(true);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select factory to toggle the lock on.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        String factoryName = (String)combo.getSelectedItem();
        if (factoryName == null || factoryName.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminlockfactory#" + planetNamestr + "#" + factoryName);
        this.mwclient.reloadData();
    }

    public void jMenuAdminSetPlanetMapSize_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet");
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String xSize = JOptionPane.showInputDialog(null, (Object)"X size");
        if (xSize == null || xSize.length() == 0) {
            return;
        }
        String ySize = JOptionPane.showInputDialog(null, (Object)"Y Size");
        if (ySize == null || ySize.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsetplanetmapsize#" + planetNamestr + "#" + xSize + "#" + ySize);
        this.mwclient.reloadData();
    }

    public void jMenuAdminSetPlanetBoardSize_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet");
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String xSize = JOptionPane.showInputDialog(null, (Object)"X size");
        if (xSize == null || xSize.length() == 0) {
            return;
        }
        String ySize = JOptionPane.showInputDialog(null, (Object)"Y Size");
        if (ySize == null || ySize.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsetplanetboardsize#" + planetNamestr + "#" + xSize + "#" + ySize);
        this.mwclient.reloadData();
    }

    public void jMenuAdminSetPlanetTemperature_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet");
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String lowTemp = JOptionPane.showInputDialog(null, (Object)"Low Temp");
        if (lowTemp == null || lowTemp.length() == 0) {
            return;
        }
        String hiTemp = JOptionPane.showInputDialog(null, (Object)"Hi Temp");
        if (hiTemp == null || hiTemp.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsetplanettemperature#" + planetNamestr + "#" + lowTemp + "#" + hiTemp);
        this.mwclient.reloadData();
    }

    public void jMenuAdminSetPlanetGravity_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet");
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String grav = JOptionPane.showInputDialog(null, (Object)"Gravity");
        if (grav == null || grav.length() == 0) {
            return;
        }
        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsetplanetgravity#" + planetNamestr + "#" + grav);
        this.mwclient.reloadData();
    }

    public void jMenuAdminCommandLists_actionPerformed(ActionEvent e) {
        CommandDialog cd = new CommandDialog(this.mwclient, "Command Name & Access Level");
        cd.setVisible(true);
        if (!cd.getName().equalsIgnoreCase("null")) {
            String input = MWClient.CAMPAIGN_PREFIX + "c " + cd.getCommandName() + "#";
            this.mwclient.getMainFrame().getMainPanel().getCommPanel().setInput(input);
            this.mwclient.getMainFrame().getMainPanel().getCommPanel().focusInputField();
        }
        cd.dispose();
    }
}

