/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import client.gui.SpringLayoutHelper;
import common.AdvanceTerrain;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public final class AdvanceTerrainDialog
implements ActionListener {
    private MWClient mwclient = null;
    private String planetName = "";
    private AdvanceTerrain aTerrain = new AdvanceTerrain();
    private int id = -1;
    private static final String okayCommand = "Okay";
    private static final String cancelCommand = "Cancel";
    private static final String windowName = "Advance Terrain Editor";
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final JTextField DisplayNameText = new JTextField(5);
    private final JTextField StaticMapNameText = new JTextField(5);
    private final JTextField XSizeText = new JTextField(5);
    private final JTextField YSizeText = new JTextField(5);
    private final JTextField XBoardSizeText = new JTextField(5);
    private final JTextField YBoardSizeText = new JTextField(5);
    private final JTextField LowTempText = new JTextField(5);
    private final JTextField HighTempText = new JTextField(5);
    private final JTextField GravityText = new JTextField(5);
    private final JTextField NightChanceText = new JTextField(5);
    private final JTextField NightTempModText = new JTextField(5);
    private final JCheckBox isStaticMapCB = new JCheckBox();
    private final JCheckBox isVacuumCB = new JCheckBox();
    private JDialog dialog;
    private JOptionPane pane;
    JTabbedPane ConfigPane = new JTabbedPane(1);

    public AdvanceTerrainDialog(MWClient c, String planetName, int id) {
        this.mwclient = c;
        this.planetName = planetName;
        this.id = id;
        this.aTerrain = (AdvanceTerrain)c.getData().getPlanetByName(planetName).getAdvanceTerrain().get(new Integer(id));
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save Options");
        this.cancelButton.setToolTipText("Exit without saving changes");
        JPanel aTerrainPanel = new JPanel();
        aTerrainPanel.setLayout(new BoxLayout(aTerrainPanel, 1));
        JPanel textPanel = new JPanel(new SpringLayout());
        JPanel checkboxPanel = new JPanel();
        textPanel.add(new JLabel("Display Name:", 11));
        this.DisplayNameText.setToolTipText("Name of the Continent to appear in planet info");
        textPanel.add(this.DisplayNameText);
        textPanel.add(new JLabel("Static Map Name:", 11));
        this.StaticMapNameText.setToolTipText("<HTML>Name of a static map you wish to use instead of the RMG<BR>Static Map must be checked to work<br>leave on surprise to grab a random map");
        textPanel.add(this.StaticMapNameText);
        textPanel.add(new JLabel("Map X Size:", 11));
        this.XSizeText.setToolTipText("For static maps X size of the Map");
        textPanel.add(this.XSizeText);
        textPanel.add(new JLabel("Map Y Size:", 11));
        this.YSizeText.setToolTipText("For static maps Y size of the Map");
        textPanel.add(this.YSizeText);
        textPanel.add(new JLabel("Board X Size:", 11));
        this.XBoardSizeText.setToolTipText("For static maps X size of the Board");
        textPanel.add(this.XBoardSizeText);
        textPanel.add(new JLabel("Board Y Size:", 11));
        this.YBoardSizeText.setToolTipText("For static maps Y size of the Board");
        textPanel.add(this.YBoardSizeText);
        textPanel.add(new JLabel("Low Temp:", 11));
        this.LowTempText.setToolTipText("The Lowest temp for this terrain");
        textPanel.add(this.LowTempText);
        textPanel.add(new JLabel("High Temp:", 11));
        this.HighTempText.setToolTipText("The Highest temp for this terrain");
        textPanel.add(this.HighTempText);
        textPanel.add(new JLabel("Gravity:", 11));
        this.GravityText.setToolTipText("Gravity for this terrain");
        textPanel.add(this.GravityText);
        textPanel.add(new JLabel("Night Chance:", 11));
        this.NightChanceText.setToolTipText("Chance for night to occur on this terrain");
        textPanel.add(this.NightChanceText);
        textPanel.add(new JLabel("Temp Reduction:", 11));
        this.NightTempModText.setToolTipText("<html>Calculated temp is reduced by <br> this much at night and 1/2 as much at dusk/down<br>i.e. if set to 10 and the temp is 50 the new temp with be 40</html>");
        textPanel.add(this.NightTempModText);
        textPanel.add(new JLabel("", 11));
        textPanel.add(new JLabel("", 11));
        SpringLayoutHelper.setupSpringGrid(textPanel, 6, 4);
        this.isStaticMapCB.setText("Use Static Maps");
        this.isStaticMapCB.setToolTipText("if you want to use static maps check this");
        checkboxPanel.add(this.isStaticMapCB);
        this.isVacuumCB.setText("Has a Vaccum");
        this.isVacuumCB.setToolTipText("if you want a vacuum for this terrain check");
        checkboxPanel.add(this.isVacuumCB);
        aTerrainPanel.add(checkboxPanel);
        aTerrainPanel.add(textPanel);
        JPanel mainPanel = new JPanel();
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(aTerrainPanel, -1, -1, null, options, null);
        this.dialog = this.pane.createDialog(mainPanel, windowName);
        this.dialog.getRootPane().setDefaultButton(this.okayButton);
        this.DisplayNameText.setText(this.aTerrain.getDisplayName());
        this.StaticMapNameText.setText(this.aTerrain.getStaticMapName());
        this.XSizeText.setText(Integer.toString(this.aTerrain.getXSize()));
        this.YSizeText.setText(Integer.toString(this.aTerrain.getYSize()));
        this.XBoardSizeText.setText(Integer.toString(this.aTerrain.getXBoardSize()));
        this.YBoardSizeText.setText(Integer.toString(this.aTerrain.getYBoardSize()));
        this.LowTempText.setText(Integer.toString(this.aTerrain.getLowTemp()));
        this.HighTempText.setText(Integer.toString(this.aTerrain.getHighTemp()));
        this.GravityText.setText(Double.toString(this.aTerrain.getGravity()));
        this.NightChanceText.setText(Integer.toString(this.aTerrain.getNightChance()));
        this.NightTempModText.setText(Integer.toString(this.aTerrain.getNightTempMod()));
        this.isStaticMapCB.setSelected(this.aTerrain.isStaticMap());
        this.isVacuumCB.setSelected(this.aTerrain.isVacuum());
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.pane.getValue() != this.okayButton) {
            this.dialog.dispose();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c SetAdvancePlanetTerrain#" + this.planetName + "#" + this.id + "#" + this.DisplayNameText.getText() + "#" + this.XSizeText.getText() + "#" + this.YSizeText.getText() + "#" + this.isStaticMapCB.isSelected() + "#" + this.XBoardSizeText.getText() + "#" + this.YBoardSizeText.getText() + "#" + this.LowTempText.getText() + "#" + this.HighTempText.getText() + "#" + this.GravityText.getText() + "#" + this.isVacuumCB.isSelected() + "#" + this.NightChanceText.getText() + "#" + this.NightTempModText.getText() + "#" + this.StaticMapNameText.getText());
            this.dialog.dispose();
        } else if (command.equals(cancelCommand)) {
            this.dialog.dispose();
        }
    }
}

