/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import client.gui.SpringLayoutHelper;
import common.House;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SpringLayout;

public final class BannedAmmoDialog
implements ActionListener {
    private MWClient mwclient = null;
    private House house = null;
    private static final String okayCommand = "Add";
    private static final String cancelCommand = "Close";
    private static final String removeCommand = "Remove";
    private static final String traitCommand = "BannedAmmo";
    private static final String factionCommand = "Faction";
    private String windowName = "Server Banned Ammo Editor";
    private static final String delimiter = "*";
    private Vector<JCheckBox> cBoxVector = new Vector();
    private final JButton okayButton = new JButton("Save");
    private final JButton cancelButton = new JButton("Close");
    private JDialog dialog;
    private JOptionPane pane;
    JTabbedPane ConfigPane = new JTabbedPane(1);

    public BannedAmmoDialog(MWClient c, House house) {
        this.mwclient = c;
        this.house = house;
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save");
        this.cancelButton.setToolTipText("Exit without saving changes");
        JPanel banPanel = new JPanel();
        banPanel.setLayout(new BoxLayout(banPanel, 1));
        JPanel ammoPanel = new JPanel(new SpringLayout());
        this.loadBannedAmmo();
        TreeSet<String> munitions = new TreeSet<String>(this.mwclient.getData().getMunitionsByName().keySet());
        int boxCount = 0;
        for (String munitionName : munitions) {
            JCheckBox cBox = new JCheckBox();
            cBox.setText(munitionName);
            cBox.setSelected(this.checkAmmoBan(munitionName));
            ammoPanel.add(cBox);
            this.cBoxVector.addElement(cBox);
            ++boxCount;
        }
        if (boxCount % 2 != 0) {
            ammoPanel.add(new JLabel("  "));
            ++boxCount;
        }
        SpringLayoutHelper.setupSpringGrid(ammoPanel, boxCount / 2, 2);
        banPanel.add(ammoPanel);
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(banPanel, -1, -1, null, options, null);
        if (house != null) {
            this.windowName = this.house.getName() + " Banned Ammo Dialog";
        }
        this.dialog = this.pane.createDialog(ammoPanel, this.windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        Hashtable<String, Long> munitionTypes = this.mwclient.getData().getMunitionsByName();
        if (command.equals(okayCommand)) {
            if (this.house == null) {
                Hashtable<String, String> bannedAmmo = this.mwclient.getData().getServerBannedAmmo();
                for (JCheckBox tempBox : this.cBoxVector) {
                    String ammo = Long.toString(munitionTypes.get(tempBox.getText()));
                    if (tempBox.isSelected() && !bannedAmmo.containsKey(ammo)) {
                        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsetserverammoban#" + munitionTypes.get(tempBox.getText()));
                        continue;
                    }
                    if (tempBox.isSelected() || !bannedAmmo.containsKey(ammo)) continue;
                    this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsetserverammoban#" + munitionTypes.get(tempBox.getText()));
                }
            } else {
                Hashtable<String, String> bannedAmmo = this.house.getBannedAmmo();
                for (JCheckBox tempBox : this.cBoxVector) {
                    String ammo = Long.toString(munitionTypes.get(tempBox.getText()));
                    if (tempBox.isSelected() && !bannedAmmo.containsKey(ammo)) {
                        this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsethouseammoban#" + this.house.getName() + "#" + munitionTypes.get(tempBox.getText()));
                        continue;
                    }
                    if (tempBox.isSelected() || !bannedAmmo.containsKey(ammo)) continue;
                    this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c adminsethouseammoban#" + this.house.getName() + "#" + munitionTypes.get(tempBox.getText()));
                }
            }
            this.dialog.dispose();
            return;
        }
        if (command.equals(cancelCommand)) {
            this.dialog.dispose();
        }
    }

    public void loadBannedAmmo() {
        if (this.house == null) {
            this.mwclient.loadServerBannedAmmo();
        } else {
            this.mwclient.loadHouseBannedAmmo();
        }
    }

    public boolean checkAmmoBan(String ammo) {
        if (this.house == null) {
            try {
                String munition = Long.toString(this.mwclient.getData().getMunitionsByName().get(ammo));
                return this.mwclient.getData().getServerBannedAmmo().containsKey(munition);
            }
            catch (Exception ex) {
                MWClient.mwClientLog.clientErrLog("Unable to find ammo " + ammo);
                return false;
            }
        }
        try {
            String munition = Long.toString(this.mwclient.getData().getMunitionsByName().get(ammo));
            return this.house.getBannedAmmo().containsKey(munition);
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("Unable to find ammo " + ammo);
            return false;
        }
    }
}

