/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CampaignData;
import common.dataFiles.HouseData;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import common.util.BinReader;
import common.util.BinWriter;
import common.util.HTML;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class House
implements MMNetSerializable {
    protected HouseData myData;

    public int getBaseGunner() {
        return this.getMyData().getBaseGunner();
    }

    public void setBaseGunner(int baseGunner) {
        this.getMyData().setBaseGunner(baseGunner);
    }

    public int getBasePilot() {
        return this.getMyData().getBasePilot();
    }

    public void setBasePilot(int basePilot) {
        this.getMyData().setBasePilot(basePilot);
    }

    public String getAbbreviation() {
        return this.getMyData().getAbbreviation();
    }

    public void setAbbreviation(String myAbbreviation) {
        this.getMyData().setAbbreviation(myAbbreviation);
    }

    public boolean isInHouseAttacks() {
        return this.getMyData().isInHouseAttacks();
    }

    public void setInHouseAttacks(boolean inHouseAttacks) {
        this.getMyData().setInHouseAttacks(inHouseAttacks);
    }

    public boolean isConquerable() {
        return this.getMyData().isConquerable();
    }

    public void setConquerable(boolean conquerable) {
        this.getMyData().setConquerable(conquerable);
    }

    public String getHouseColor() {
        return this.getMyData().getHouseColor();
    }

    public void setHouseColor(String factionColor) {
        this.getMyData().setHouseColor(factionColor);
    }

    public int getInitialHouseRanking() {
        return this.getMyData().getInitialHouseRanking();
    }

    public void setInitialHouseRanking(int initialHouseRanking) {
        this.getMyData().setInitialHouseRanking(initialHouseRanking);
    }

    public String getLogo() {
        return this.getMyData().getLogo();
    }

    public void setLogo(String logo) {
        this.getMyData().setLogo(logo);
    }

    public String getHouseFluFile() {
        return this.getMyData().getHouseFluFile();
    }

    public void setHouseFluFile(String factionFlu) {
        this.getMyData().setHouseFluFile(factionFlu);
    }

    public boolean isMayUseBM() {
        return this.getMyData().isMayUseBM();
    }

    public void setMayUseBM(boolean mayUseBM) {
        this.getMyData().setMayUseBM(mayUseBM);
    }

    public String getName() {
        return this.getMyData().getName();
    }

    public String getNameAsLink() {
        return "<a href=\"MEKWARS/c faction#" + this.getName() + "\">" + this.getName() + "</a>";
    }

    public void setName(String name) {
        this.getMyData().setName(name);
    }

    public int getId() {
        if (this.getMyData().getId() == null) {
            return -1;
        }
        return this.getMyData().getId();
    }

    public House(int id) {
        this.myData = new HouseData();
        this.getMyData().setId(new Integer(id));
    }

    public House() {
        this.myData = new HouseData();
    }

    public House(HouseData Data) {
        this.myData = Data;
    }

    public void binOut(BinWriter out) throws IOException {
        int weight;
        int type;
        out.println(this.getMyData().getId(), "id");
        out.println(this.getMyData().getName(), "name");
        out.println(this.getMyData().getLogo(), "logo");
        out.println(this.getMyData().getBaseGunner(), "baseGunner");
        out.println(this.getMyData().getBasePilot(), "basePilot");
        out.println(this.getMyData().getInitialHouseRanking(), "initialHouseRanking");
        out.println(this.getMyData().getHouseColor(), "factionColor");
        out.println(this.getMyData().getAbbreviation(), "abbreviation");
        out.println(this.getMyData().isConquerable(), "conquerable");
        out.println(this.getMyData().isInHouseAttacks(), "inHouseAttacks");
        out.println(this.getMyData().isMayUseBM(), "mayUseBM");
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                out.println(this.getMyData().getHouseUnitComponentMod(type, weight), "componentMod" + type + weight);
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                out.println(this.getMyData().getHouseUnitPriceMod(type, weight), "priceMod" + type + weight);
            }
        }
        out.println(this.getBannedAmmo().size(), "factionbannedammosize");
        Enumeration<String> banned = this.getBannedAmmo().keys();
        while (banned.hasMoreElements()) {
            String munition = banned.nextElement();
            out.println(munition, "munition");
        }
    }

    public House(BinReader in) throws IOException {
        int weight;
        int type;
        this.myData = new HouseData();
        this.getMyData().setId(new Integer(in.readInt("id")));
        this.getMyData().setName(HTML.br2cr(in.readLine("name")));
        this.getMyData().setLogo(HTML.br2cr(in.readLine("logo")));
        this.getMyData().setBaseGunner(in.readInt("baseGunner"));
        this.getMyData().setBasePilot(in.readInt("basePilot"));
        this.getMyData().setInitialHouseRanking(in.readInt("initialHouseRanking"));
        this.getMyData().setHouseColor(in.readLine("factionColor"));
        this.getMyData().setAbbreviation(in.readLine("abbreviation"));
        this.getMyData().setConquerable(in.readBoolean("conquerable"));
        this.getMyData().setInHouseAttacks(in.readBoolean("inHouseAttacks"));
        this.getMyData().setMayUseBM(in.readBoolean("mayUseBM"));
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                this.getMyData().setHouseUnitComponentMod(type, weight, in.readInt("componentMod" + type + weight));
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                this.getMyData().setHouseUnitPriceMod(type, weight, in.readInt("priceMod" + type + weight));
            }
        }
        for (int size = in.readInt("factionbannedammosize"); size > 0; --size) {
            this.getMyData().getBannedAmmo().put(in.readLine("munition"), "Banned");
        }
    }

    public String getMotd() {
        return this.getMyData().getMotd();
    }

    public void setMotd(String motd) {
        this.getMyData().setMotd(motd);
    }

    public void setId(int id) {
        this.getMyData().setId(new Integer(id));
    }

    @Override
    public void binOut(TreeWriter out) {
        int weight;
        int type;
        out.write(this.getMyData().getId(), "id");
        out.write(this.getMyData().getName(), "name");
        out.write(this.getMyData().getLogo(), "logo");
        out.write(this.getMyData().getBaseGunner(), "baseGunner");
        out.write(this.getMyData().getBasePilot(), "basePilot");
        out.write(this.getMyData().getInitialHouseRanking(), "initialHouseRanking");
        out.write(this.getMyData().getHouseColor(), "factionColor");
        out.write(this.getMyData().getAbbreviation(), "abbreviation");
        out.write(this.getMyData().isConquerable(), "conquerable");
        out.write(this.getMyData().isInHouseAttacks(), "inHouseAttacks");
        out.write(this.getMyData().isMayUseBM(), "mayUseBM");
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                out.write(this.getMyData().getHouseUnitComponentMod(type, weight), "componentMod" + type + weight);
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                out.write(this.getMyData().getHouseUnitPriceMod(type, weight), "priceMod" + type + weight);
            }
        }
        out.write(this.getBannedAmmo().size(), "factionbannedammosize");
        Enumeration<String> banned = this.getBannedAmmo().keys();
        while (banned.hasMoreElements()) {
            out.write(banned.nextElement(), "munition");
        }
    }

    @Override
    public void binIn(TreeReader in, CampaignData dataProvider) throws IOException {
        int weight;
        int type;
        this.getMyData().setId(new Integer(in.readInt("id")));
        this.getMyData().setName(HTML.br2cr(in.readString("name")));
        this.getMyData().setLogo(HTML.br2cr(in.readString("logo")));
        this.getMyData().setBaseGunner(in.readInt("baseGunner"));
        this.getMyData().setBasePilot(in.readInt("basePilot"));
        this.getMyData().setInitialHouseRanking(in.readInt("initialHouseRanking"));
        this.getMyData().setHouseColor(in.readString("factionColor"));
        this.getMyData().setAbbreviation(in.readString("abbreviation"));
        this.getMyData().setConquerable(in.readBoolean("conquerable"));
        this.getMyData().setInHouseAttacks(in.readBoolean("inHouseAttacks"));
        this.getMyData().setMayUseBM(in.readBoolean("mayUseBM"));
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                this.getMyData().setHouseUnitComponentMod(type, weight, in.readInt("componentMod" + type + weight));
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                this.getMyData().setHouseUnitPriceMod(type, weight, in.readInt("priceMod" + type + weight));
            }
        }
        for (int size = in.readInt("factionbannedammosize"); size > 0; --size) {
            this.getMyData().getBannedAmmo().put(in.readString("munition"), "Banned");
        }
    }

    public void HouseBannedAmmoOut(BinWriter out) {
        try {
            if (this.getBannedAmmo().size() <= 0) {
                return;
            }
            out.println(this.getName(), "HouseName");
            out.println(this.getBannedAmmo().size(), "factionbannedammosize");
            Enumeration<String> banned = this.getBannedAmmo().keys();
            while (banned.hasMoreElements()) {
                String munition = banned.nextElement();
                out.println(munition, "munition");
            }
        }
        catch (Exception ex) {
            System.err.println("Error in HouseBannedAmmoOut");
            ex.printStackTrace();
        }
    }

    public void HouseBannedAmmoIn(BinReader in) {
        try {
            this.getBannedAmmo().clear();
            for (int size = in.readInt("factionbannedammosize"); size > 0; --size) {
                this.getBannedAmmo().put(in.readLine("munition"), "Banned");
            }
        }
        catch (Exception ex) {
            System.err.println("Unable to load HouseBannedAmmoIn");
            ex.printStackTrace();
        }
    }

    public HouseData getMyData() {
        return this.myData;
    }

    public int getHouseUnitPriceMod(int type, int weight) {
        return this.getMyData().factionUnitPriceMod[type][weight];
    }

    public void setHouseUnitPriceMod(int type, int weight, int mod) {
        this.getMyData().factionUnitPriceMod[type][weight] = mod;
    }

    public int getHouseUnitComponentMod(int type, int weight) {
        return this.getMyData().factionUnitComponentMod[type][weight];
    }

    public void setHouseUnitComponentMod(int type, int weight, int mod) {
        this.getMyData().factionUnitComponentMod[type][weight] = mod;
    }

    public void setHousePlayerColors(int red, int green, int blue) {
        this.getMyData().setHousePlayerColors(red, green, blue);
    }

    public int getHousePlayerColor(int color) {
        return this.getMyData().getHousePlayerColor(color);
    }

    public void setBannedAmmo(Hashtable<String, String> ban) {
        this.getMyData().setBannedAmmo(ban);
    }

    public Hashtable<String, String> getBannedAmmo() {
        return this.getMyData().getBannedAmmo();
    }
}

