/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Army;
import common.CampaignData;
import common.campaign.pilot.Pilot;
import common.dataFiles.UnitData;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Tank;

public class Unit
implements MMNetSerializable {
    public static final int LIGHT = 0;
    public static final int MEDIUM = 1;
    public static final int HEAVY = 2;
    public static final int ASSAULT = 3;
    public static final int MEK = 0;
    public static final int VEHICLE = 1;
    public static final int INFANTRY = 2;
    public static final int PROTOMECH = 3;
    public static final int BATTLEARMOR = 4;
    public static final int QUAD = 5;
    public static final int MEKWARRIOR = 6;
    public static final int MAXBUILD = 5;
    public static final int C3_NONE = 0;
    public static final int C3_SLAVE = 1;
    public static final int C3_MASTER = 2;
    public static final int C3_IMPROVED = 3;
    public static final int C3_MMASTER = 4;
    public static final String[] TYPE_STR = new String[]{"Mek", "Vehicle", "Infantry", "BattleArmor", "ProtoMek"};
    public static int TOTALTYPES = 5;
    public static final int STATUS_OK = 1;
    public static final int STATUS_DESTROYED = 2;
    public static final int STATUS_UNMAINTAINED = 3;
    public int[] test = new int[4];
    private UnitData myData = new UnitData();

    public String getModelname() {
        return this.myData.getModelname();
    }

    public void setModelname(String modelname) {
        this.myData.setModelname(modelname);
    }

    public Unit() {
        this.myData = new UnitData();
    }

    public Unit(UnitData data) {
        this.myData = data;
    }

    public Pilot getPilot() {
        return this.myData.getPilot();
    }

    public void setPilot(Pilot pilot) {
        this.myData.setPilot(pilot);
    }

    public int getPosId() {
        return this.myData.getPosId();
    }

    public void setPosId(int posId) {
        this.myData.setPosId(posId);
    }

    public String getProducer() {
        return this.myData.getProducer();
    }

    public void setProducer(String producer) {
        this.myData.setProducer(producer);
    }

    public int getType() {
        return this.myData.getType();
    }

    public void setType(int type) {
        this.myData.setType(type);
    }

    public String getUnitFilename() {
        return this.myData.getUnitFilename().trim();
    }

    public void setUnitFilename(String unitFilename) {
        this.myData.setUnitFilename(unitFilename);
    }

    public int getWeightclass() {
        return this.myData.getWeightclass();
    }

    public void setWeightclass(int weightclass) {
        this.myData.setWeightclass(weightclass);
    }

    public int getStatus() {
        return this.myData.getStatus();
    }

    public void setStatus(int status) {
        this.myData.setStatus(status);
    }

    public int getMaintainanceLevel() {
        return this.myData.getMaintainanceLevel();
    }

    public void setMaintainanceLevel(int i) {
        if (i < 0) {
            i = 0;
        }
        if (i > 100) {
            i = 100;
        }
        this.myData.setMaintainanceLevel(i);
    }

    public void addToMaintainanceLevel(int i) {
        this.setMaintainanceLevel(this.getMaintainanceLevel() + i);
    }

    public int linkToC3Network(Army army, Unit master) {
        if (army == null || master == null) {
            return -1;
        }
        System.err.println("Return 1");
        if (army.getUnit(this.getId()) == null) {
            return -1;
        }
        System.err.println("Return 2");
        if (this.getC3Level() == 0) {
            return -1;
        }
        System.err.println("Return 3");
        if (this.getC3Level() == 1) {
            if (master.getC3Level() != 2 && master.getC3Level() != 4) {
                return -1;
            }
            System.err.println("Return 4");
            if (master.hasBeenC3LinkedTo(army) && !master.hasC3SlavesLinkedTo(army)) {
                return -1;
            }
            System.err.println("Return 5");
            if (!master.checkC3mNetworkHasOpen(army, this.getC3Level())) {
                return -1;
            }
            System.err.println("Return 6");
            army.getC3Network().put(new Integer(this.getId()), new Integer(master.getId()));
            return master.getId();
        }
        if (this.getC3Level() == 2 || this.getC3Level() == 4) {
            if (master.getC3Level() != 2 && master.getC3Level() != 4) {
                return -1;
            }
            System.err.println("Return 7");
            if (this.hasBeenC3LinkedTo(army) && !this.hasC3SlavesLinkedTo(army)) {
                return -1;
            }
            System.err.println("Return 8");
            if (master.getC3Level() != 4 && master.hasBeenC3LinkedTo(army) && master.hasC3SlavesLinkedTo(army)) {
                return -1;
            }
            System.err.println("Return 9");
            if (!master.checkC3mNetworkHasOpen(army, this.getC3Level())) {
                return -1;
            }
            System.err.println("Return 10");
            army.getC3Network().put(new Integer(this.getId()), new Integer(master.getId()));
            return master.getId();
        }
        if (this.getC3Level() == 3) {
            if (master.getC3Level() != 3) {
                return -1;
            }
            System.err.println("Return 11");
            if (this.hasBeenC3LinkedTo(army)) {
                return -1;
            }
            System.err.println("Return 12");
            if (!master.checkC3iNetworkHasOpen(army)) {
                return -1;
            }
            System.err.println("Return 13");
            army.getC3Network().put(new Integer(this.getId()), new Integer(master.getId()));
            return master.getId();
        }
        System.err.println("Return 14");
        return -1;
    }

    public boolean hasBeenC3LinkedTo(Army army) {
        if (army.getUnit(this.getId()) == null) {
            return false;
        }
        Enumeration c3Unit = army.getC3Network().elements();
        while (c3Unit.hasMoreElements()) {
            Integer c3U = (Integer)c3Unit.nextElement();
            if (c3U.intValue() != this.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean hasC3SlavesLinkedTo(Army army) {
        if (army.getUnit(this.getId()) == null) {
            return false;
        }
        Enumeration c3Slave = army.getC3Network().keys();
        Enumeration c3Unit = army.getC3Network().elements();
        while (c3Unit.hasMoreElements()) {
            Integer c3S = (Integer)c3Slave.nextElement();
            Integer c3U = (Integer)c3Unit.nextElement();
            if (c3U.intValue() != this.getId() || army.getUnit(c3S).getC3Level() == 1) continue;
            return false;
        }
        return true;
    }

    public boolean checkC3mNetworkHasOpen(Army army, int c3Type) {
        int MAX_UNITS = 4;
        int unitCount = 1;
        if (army == null) {
            return false;
        }
        if (army.getUnit(this.getId()) == null) {
            return false;
        }
        if (army.getC3Network().get(new Integer(this.getId())) != null) {
            return false;
        }
        if (this.getC3Level() == 4) {
            int slaveCount = 0;
            int masterCount = 0;
            int maxMasters = 2;
            int maxSlaves = 3;
            Enumeration c3Master = army.getC3Network().elements();
            Enumeration c3Slave = army.getC3Network().keys();
            while (c3Master.hasMoreElements()) {
                Integer c3M = (Integer)c3Master.nextElement();
                Integer c3S = (Integer)c3Slave.nextElement();
                if (c3M.intValue() != this.getId()) continue;
                Unit tempUnit = army.getUnit(c3S);
                if (tempUnit.getC3Level() == 1) {
                    ++slaveCount;
                    continue;
                }
                ++masterCount;
            }
            if (c3Type != 1 && masterCount >= maxMasters) {
                return false;
            }
            return c3Type != 1 || slaveCount < maxSlaves;
        }
        Enumeration c3Unit = army.getC3Network().elements();
        while (c3Unit.hasMoreElements()) {
            Integer c3U = (Integer)c3Unit.nextElement();
            if (c3U.intValue() != this.getId()) continue;
            ++unitCount;
        }
        return unitCount < MAX_UNITS;
    }

    public boolean checkC3iNetworkHasOpen(Army army) {
        int MAX_UNITS = 6;
        int unitCount = 1;
        if (army == null) {
            return false;
        }
        if (army.getUnit(this.getId()) == null) {
            return false;
        }
        if (army.getC3Network().get(new Integer(this.getId())) != null) {
            return false;
        }
        Enumeration c3Unit = army.getC3Network().elements();
        while (c3Unit.hasMoreElements()) {
            Integer c3U = (Integer)c3Unit.nextElement();
            if (c3U.intValue() != this.getId()) continue;
            ++unitCount;
        }
        return unitCount < MAX_UNITS;
    }

    public void binOut(TreeWriter out) {
        out.write(this.getType(), "type");
        out.write(this.getWeightclass(), "weightclass");
        out.write(this.getStatus(), "status");
        out.write(this.getProducer(), "producer");
        out.write(this.getUnitFilename(), "filename");
        out.write(this.getPosId(), "posID");
        out.write(this.getModelname(), "modelname");
        out.write(this.getPilot(), "pilot");
    }

    public void binIn(TreeReader in, CampaignData data) {
    }

    public int getId() {
        return this.myData.getId();
    }

    public void setId(int id) {
        this.myData.setId(new Integer(id));
    }

    public UnitData getMyData() {
        return this.myData;
    }

    public void setMyData(UnitData myData) {
        this.myData = myData;
    }

    public static int getTypeIDForName(String name) {
        if (name.toLowerCase().startsWith("v")) {
            return 1;
        }
        if (name.toLowerCase().startsWith("i")) {
            return 2;
        }
        if (name.toLowerCase().startsWith("p")) {
            return 3;
        }
        if (name.toLowerCase().startsWith("b")) {
            return 4;
        }
        return 0;
    }

    public static String getWeightClassDesc(int Weightclass) {
        if (Weightclass == 0) {
            return "Light";
        }
        if (Weightclass == 1) {
            return "Medium";
        }
        if (Weightclass == 2) {
            return "Heavy";
        }
        if (Weightclass == 3) {
            return "Assault";
        }
        return "unknown";
    }

    public static int getWeightIDForName(String name) {
        if (name.equalsIgnoreCase("LIGHT")) {
            return 0;
        }
        if (name.equalsIgnoreCase("MEDIUM")) {
            return 1;
        }
        if (name.equalsIgnoreCase("HEAVY")) {
            return 2;
        }
        if (name.equalsIgnoreCase("ASSAULT")) {
            return 3;
        }
        return 0;
    }

    public void getC3Type(Entity unit) {
        unit.setShutDown(false);
        if (unit.hasC3S()) {
            this.setC3Level(1);
        } else if (unit.hasC3MM()) {
            this.setC3Level(4);
        } else if (unit.hasC3M()) {
            this.setC3Level(2);
        } else if (unit.hasC3i()) {
            this.setC3Level(3);
        } else {
            this.setC3Level(0);
        }
    }

    public int getC3Level() {
        return this.getMyData().getC3Level();
    }

    public void setC3Level(int level) {
        this.getMyData().setC3Level(level);
    }

    public int getEntityWeight(Entity ent) {
        int weight = ent.getWeightClass();
        if (weight == 0) {
            return 0;
        }
        if (weight == 1) {
            return 1;
        }
        if (weight == 2) {
            return 2;
        }
        if (weight == 3) {
            return 3;
        }
        return 0;
    }

    public int getEntityType(Entity ent) {
        if (ent instanceof Mech || ent instanceof QuadMech) {
            return 0;
        }
        if (ent instanceof Tank) {
            return 1;
        }
        if (ent instanceof BattleArmor) {
            return 4;
        }
        if (ent instanceof Protomech) {
            return 3;
        }
        return 2;
    }

    public static String getDescriptionForID(int type) {
        if (type == 0) {
            return "Mek";
        }
        if (type == 1) {
            return "Vehicle";
        }
        if (type == 2) {
            return "Infantry";
        }
        if (type == 4) {
            return "BattleArmor";
        }
        if (type == 3) {
            return "ProtoMek";
        }
        return "Unknown";
    }

    public static String getTypeClassDesc(int type_id) {
        if (type_id == 0) {
            return "Mek";
        }
        if (type_id == 1) {
            return "Vehicle";
        }
        if (type_id == 2) {
            return "Infantry";
        }
        if (type_id == 4) {
            return "BattleArmor";
        }
        if (type_id == 3) {
            return "ProtoMek";
        }
        return "unknown";
    }

    public AmmoType getEntityAmmo(int weaponType, String ammoName) {
        Vector v_Ammo = AmmoType.getMunitionsFor(weaponType);
        AmmoType at = null;
        for (int count = 0; count < v_Ammo.size(); ++count) {
            at = (AmmoType)v_Ammo.elementAt(count);
            if (!at.getInternalName().equalsIgnoreCase(ammoName)) continue;
            return at;
        }
        return null;
    }
}

