/*
 * Decompiled with CFR 0.152.
 */
package common.util;

import java.awt.Color;

public class StringConverter {
    public static Color html2Color(String htmlColor) {
        try {
            return Color.decode(htmlColor);
        }
        catch (RuntimeException e) {
            try {
                return Color.decode("#" + htmlColor);
            }
            catch (RuntimeException ex) {
                return Color.lightGray;
            }
        }
    }

    private static String int2hex(int i) {
        String s = Integer.toHexString(i);
        return s.length() == 2 ? s : "0" + s;
    }

    public static String color2html(Color color) {
        return "#" + StringConverter.int2hex(color.getRed()) + StringConverter.int2hex(color.getGreen()) + StringConverter.int2hex(color.getBlue());
    }

    public static String replaceAllInString(String str, String from, String to, boolean caseSensitive) {
        int pos;
        String f;
        String s = caseSensitive ? str : str.toLowerCase();
        String string = f = caseSensitive ? from : from.toLowerCase();
        while ((pos = s.indexOf(f)) != -1) {
            str = str.substring(0, pos) + to + str.substring(pos + f.length());
            s = caseSensitive ? str : str.toLowerCase();
        }
        return str;
    }

    public static String string2html(String str) {
        str = StringConverter.replaceAllInString(str, "\n", "<br>", false);
        str = StringConverter.replaceAllInString(str, "&", "?amb;", false);
        str = StringConverter.replaceAllInString(str, "?", "&", false);
        str = StringConverter.replaceAllInString(str, "<", "&lt;", false);
        str = StringConverter.replaceAllInString(str, ">", "&gt;", false);
        return str;
    }
}

