/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.awt;

import com.lyrisoft.awt.HyperlinkReceiver;
import com.lyrisoft.awt.HyperlinkTextRun;
import com.lyrisoft.awt.TextRun;
import com.lyrisoft.awt.TextStyle;
import com.lyrisoft.awt.TextView;
import java.awt.Color;
import java.awt.Container;
import java.awt.Event;
import java.awt.Frame;

public class HyperlinkTextView
extends TextView {
    private HyperlinkReceiver _hyperlinkReceiver;
    private Frame _frame;

    public HyperlinkTextView(boolean autoScroll, HyperlinkReceiver receiver) {
        super(autoScroll);
        this._hyperlinkReceiver = receiver;
    }

    static int findStartOfEmail(String s, int idx) {
        char[] chars = s.toCharArray();
        int i = idx;
        while (i >= 0) {
            char c = chars[i];
            if (!Character.isLetterOrDigit(c) && (i <= 0 || c != '-' && c != '.' && c != '_')) {
                return i + 1;
            }
            --i;
        }
        return 0;
    }

    static int findEndOfHref(String s, int start) {
        char[] chars = s.toCharArray();
        int end = s.length();
        int i = start;
        while (i < end) {
            char c = chars[i];
            if (!Character.isLetterOrDigit(c)) {
                switch (c) {
                    case '#': 
                    case '%': 
                    case '&': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '=': 
                    case '?': 
                    case '_': 
                    case '~': {
                        break;
                    }
                    default: {
                        return i;
                    }
                }
            }
            ++i;
        }
        return end;
    }

    public void append(String s, TextStyle style) {
        boolean appendHttp = false;
        int lIndex = s.indexOf("<a href=\"");
        int hIndex = s.indexOf("http://");
        if (hIndex == -1) {
            hIndex = s.indexOf("www.");
            appendHttp = true;
        }
        int eIndex = s.indexOf("@");
        if (lIndex >= 0) {
            super.append(s.substring(0, lIndex), style);
            int endHrefIndex = s.indexOf("\">");
            int endLinkIndex = s.indexOf("</a>");
            if (endHrefIndex > lIndex & endLinkIndex > endHrefIndex) {
                int endIndex = endLinkIndex + 4;
                int startTextIndex = endHrefIndex + 2;
                int startHrefIndex = lIndex + 9;
                String href = s.substring(startHrefIndex, endHrefIndex);
                String text = s.substring(startTextIndex, endLinkIndex);
                TextStyle linkStyle = new TextStyle(this._defaultStyle);
                linkStyle.setColor(Color.blue);
                HyperlinkTextRun run = new HyperlinkTextRun(text, href, linkStyle);
                super.append(run);
                if (endIndex != s.length()) {
                    this.append(s.substring(endIndex, s.length()), style);
                }
            }
        } else if (hIndex >= 0) {
            super.append(s.substring(0, hIndex), style);
            int endIndex = HyperlinkTextView.findEndOfHref(s, hIndex);
            TextStyle linkStyle = new TextStyle(this._defaultStyle);
            linkStyle.setColor(Color.blue);
            String href = s.substring(hIndex, endIndex);
            HyperlinkTextRun run = appendHttp ? new HyperlinkTextRun(href, "http://" + href, linkStyle) : new HyperlinkTextRun(href, href, linkStyle);
            super.append(run);
            if (endIndex != s.length()) {
                this.append(s.substring(endIndex, s.length()), style);
            }
        } else if (eIndex >= 0) {
            int start = HyperlinkTextView.findStartOfEmail(s, eIndex - 1);
            super.append(s.substring(0, start));
            int endIndex = HyperlinkTextView.findEndOfHref(s, eIndex + 1);
            TextStyle linkStyle = new TextStyle(this._defaultStyle);
            linkStyle.setColor(Color.blue);
            String addr = s.substring(start, endIndex);
            HyperlinkTextRun run = new HyperlinkTextRun(addr, "mailto:" + addr, linkStyle);
            super.append(run);
            if (endIndex != s.length()) {
                this.append(s.substring(endIndex, s.length()), style);
            }
        } else {
            super.append(s, style);
        }
    }

    synchronized TextRun getRun(int x, int y) {
        if (this._firstRun == -1) {
            return null;
        }
        int len = this._runs.size();
        int i = this._firstRun;
        while (i < len) {
            TextRun run = (TextRun)this._runs.elementAt(i);
            if (run.contains(x, y, this._yTranslation)) {
                return run;
            }
            ++i;
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        this._frame = this.getFrame();
    }

    Frame getFrame() {
        Container c = this.getParent();
        do {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        } while ((c = c.getParent()) != null);
        return null;
    }

    void setCursor(int x, int y) {
        TextRun run = this.getRun(x, y);
        if (run == null) {
            this._frame.setCursor(0);
        } else if (run instanceof HyperlinkTextRun) {
            this._frame.setCursor(12);
        } else {
            this._frame.setCursor(0);
        }
    }

    public boolean handleEvent(Event e) {
        if (e.id == 501) {
            TextRun run = this.getRun(e.x, e.y);
            if (run == null) {
                return true;
            }
            if (run instanceof HyperlinkTextRun) {
                this._hyperlinkReceiver.handleHyperlink(((HyperlinkTextRun)run).getHref());
            }
            return true;
        }
        if (e.id == 503) {
            this.setCursor(e.x, e.y);
            return true;
        }
        return super.handleEvent(e);
    }
}

