/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.awt;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

public class ImageButton
extends Canvas {
    private Image image;
    private String command;
    private boolean selected = false;
    private Dimension size;

    public ImageButton(Image img, String command) {
        this.image = img;
        this.command = command;
        this.size = this.image == null ? new Dimension(0, 0) : new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        return this.size;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
        if (this.selected) {
            g.setColor(Color.yellow);
            g.drawRect(0, 0, this.image.getWidth(this) - 1, this.image.getHeight(this) - 1);
        }
    }

    public boolean handleEvent(Event e) {
        if (e.id == 502 && this.selected) {
            e.id = 1001;
            e.arg = this.command;
        }
        if (e.id == 504) {
            this.selected = true;
            this.repaint();
            return true;
        }
        if (e.id == 505) {
            this.selected = false;
            this.repaint();
            return true;
        }
        return super.handleEvent(e);
    }
}

