/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.awt;

import com.lyrisoft.awt.TextView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Event;
import java.awt.Panel;
import java.awt.Scrollbar;

public class ScrollView
extends Panel {
    TextView _view;
    Scrollbar _scrollbar;
    static boolean WORKAROUND_ENABLED = new Scrollbar(0, 20, 10, 0, 20).getValue() == 20;

    public ScrollView(TextView view) {
        this._view = view;
        this._scrollbar = new Scrollbar(1);
        this._scrollbar.setLineIncrement(10);
        this._scrollbar.setBackground(Color.lightGray);
        this.setLayout(new BorderLayout());
        this.add("Center", view);
        this.add("East", this._scrollbar);
        view.setScrollView(this);
    }

    public void scrollToBottom() {
        int max = this._scrollbar.getMaximum();
        this._scrollbar.setValue(max);
        this.scroll();
    }

    public void boundsChanged() {
        int viewableHeight = this._view.size().height;
        int fullHeight = this._view.preferredSize().height;
        if (WORKAROUND_ENABLED) {
            fullHeight -= viewableHeight;
        }
        this._scrollbar.setValues(this._scrollbar.getValue(), viewableHeight, 0, fullHeight);
        this.scroll();
    }

    void scroll() {
        this._view.setYTranslation(this._scrollbar.getValue());
        this._view.repaint();
    }

    public boolean handleEvent(Event event) {
        if (event.target == this._scrollbar) {
            this.scroll();
            return true;
        }
        return super.handleEvent(event);
    }
}

