/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.awt;

import com.lyrisoft.awt.Substring;
import com.lyrisoft.awt.TextStyle;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Vector;

public class TextRun {
    private String _text;
    private TextStyle _style;
    private char[] _chars;
    private FontMetrics _fm;
    private int _fmMaxDescent;
    private int _fmMaxAscent;
    private int _fmLeading;
    private int _fmHeight;
    private int[] _fmWidths;
    private Vector _substrings;
    private boolean _newLineFixed;
    private Rectangle _boundingRect = new Rectangle(0, 0, 0, 0);

    public TextRun(String text, TextStyle style) {
        this._text = text;
        this._style = style;
        this._fm = Toolkit.getDefaultToolkit().getFontMetrics(style.getFont());
        this._fmMaxDescent = this._fm.getMaxDescent();
        this._fmMaxAscent = this._fm.getMaxAscent();
        this._fmLeading = this._fm.getLeading();
        this._fmHeight = this._fm.getHeight();
        this._fmWidths = this._fm.getWidths();
        this._chars = this._text.toCharArray();
        this._substrings = new Vector();
    }

    public TextStyle getStyle() {
        return this._style;
    }

    public String getText() {
        return this._text;
    }

    public void setFont(Font f) {
        this._style.setFont(f);
    }

    public Rectangle getBoundingRect() {
        return this._boundingRect;
    }

    int findEnd(int begin, int xOff, int xMax) {
        int end = begin;
        int width = xOff;
        while (end != this._chars.length) {
            if (width + this._fmWidths[this._chars[end]] > xMax || this._chars[end] == '\n') break;
            width += this._fmWidths[this._chars[end]];
            ++end;
        }
        if (end == this._chars.length) {
            return end;
        }
        if (this._chars[end] == '\n') {
            this._newLineFixed = true;
            return end;
        }
        int oldEnd = end;
        while (end > begin) {
            if (this._chars[end - 1] == ' ') {
                return end;
            }
            --end;
        }
        return xOff == 0 ? oldEnd : end;
    }

    void prepare(int xMax, Dimension preferredSize, Point p) {
        this._substrings.removeAllElements();
        this._boundingRect.x = 0;
        this._boundingRect.y = p.y;
        int x = p.x;
        int y = p.y;
        if (xMax <= 0) {
            xMax = 600;
        }
        int yOff = y + this._fmMaxAscent;
        int xOff = x;
        int begin = 0;
        int len = this._chars.length;
        int end = 0;
        int width = 0;
        do {
            if (this._chars[begin] == '\n') {
                ++begin;
                if (!this._newLineFixed) {
                    yOff += this._fmHeight;
                    xOff = 0;
                } else {
                    this._newLineFixed = false;
                }
                if (begin == this._chars.length - 1) break;
            }
            end = this.findEnd(begin, xOff, xMax);
            width = xOff + this._fm.charsWidth(this._chars, begin, end - begin);
            this._substrings.addElement(new Substring(begin, end - begin, xOff, yOff));
            xOff = 0;
            if (end == len) continue;
            yOff += this._fmHeight;
            begin = end;
        } while (end != len);
        preferredSize.width = xMax;
        preferredSize.height = yOff - y + this._fmMaxDescent;
        p.x = width;
        p.y = yOff - this._fmMaxAscent;
        this._boundingRect.width = preferredSize.width;
        this._boundingRect.height = preferredSize.height;
    }

    public boolean contains(int x, int y, int yTranslation) {
        if (this._boundingRect.inside(x, y + yTranslation)) {
            Substring target = null;
            Enumeration e = this._substrings.elements();
            while (e.hasMoreElements()) {
                Substring sub = (Substring)e.nextElement();
                if (x < sub.xOff || y + yTranslation < sub.yOff - this._fmHeight) continue;
                target = sub;
            }
            if (target != null && x < target.xOff + this._fm.stringWidth(new String(this._chars, target.begin, target.length))) {
                return true;
            }
        }
        return false;
    }

    void draw(Graphics g, int yOff) {
        g.setColor(this._style.getColor());
        g.setFont(this._style.getFont());
        Enumeration e = this._substrings.elements();
        while (e.hasMoreElements()) {
            Substring substring = (Substring)e.nextElement();
            g.drawChars(this._chars, substring.begin, substring.length, substring.xOff, substring.yOff + yOff);
        }
    }

    public String toString() {
        return "TextRun[\"" + this._text + "\"]; Bounds = " + this._boundingRect;
    }
}

