/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.awt;

import com.lyrisoft.awt.ScrollView;
import com.lyrisoft.awt.TextRun;
import com.lyrisoft.awt.TextStyle;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class TextView
extends Canvas {
    public static Font DEFAULT_FONT = new Font("Dialog", 0, 10);
    protected Vector _runs;
    protected TextStyle _defaultStyle;
    private Image _image;
    private Graphics _graphics;
    private Dimension _bufferSize = new Dimension(0, 0);
    private int _fullHeight;
    private ScrollView _scrollView;
    protected int _yTranslation = 0;
    private Point _nextDrawPoint = new Point(0, 0);
    private Dimension _scratchDimension = new Dimension(0, 0);
    private boolean _autoScrolling;
    protected int _firstRun = 0;

    public TextView(boolean autoScrolling) {
        this._runs = new Vector();
        this.setFont(DEFAULT_FONT);
        this._autoScrolling = autoScrolling;
        this.reshape(0, 0, 1024, 768);
        this._defaultStyle = new TextStyle(this.getFont(), Color.black);
    }

    public TextView() {
        this(false);
    }

    public TextStyle getDefaultStyle() {
        return this._defaultStyle;
    }

    void setScrollView(ScrollView sv) {
        this._scrollView = sv;
    }

    public void setFont(String name) {
        Font oldFont = this.getFont();
        Font newFont = new Font(name, oldFont.getStyle(), oldFont.getSize());
        this.setFont(newFont);
    }

    public void setFontSize(int size) {
        Font oldFont = this.getFont();
        Font newFont = new Font(oldFont.getName(), oldFont.getStyle(), size);
        this.setFont(newFont);
    }

    public void setFont(Font f) {
        super.setFont(f);
        this._defaultStyle = new TextStyle(f, this.getForeground());
    }

    public void append(String s, TextStyle style) {
        if (s.length() == 0) {
            return;
        }
        TextRun run = new TextRun(s, style);
        this.append(run);
    }

    public synchronized void append(TextRun run) {
        this._runs.addElement(run);
        this.prepare(run);
        if (this._scrollView != null) {
            this._scrollView.boundsChanged();
            if (this._autoScrolling) {
                this._scrollView.scrollToBottom();
            }
        }
        this.repaint();
    }

    public void append(String s) {
        this.append(s, this._defaultStyle);
    }

    public void setYTranslation(int y) {
        this._yTranslation = y;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.renderViewable(g);
    }

    public void show() {
        if (this._autoScrolling) {
            this._scrollView.scrollToBottom();
        }
    }

    public void reshape(int x, int y, int w, int h) {
        boolean reRender = this.size().width != w;
        super.reshape(x, y, w, h);
        if (!this.createBuffer()) {
            return;
        }
        if (reRender) {
            this.prepareAll();
        }
        if (this._scrollView != null) {
            this._scrollView.boundsChanged();
            if (this._autoScrolling) {
                this._scrollView.scrollToBottom();
            }
        }
        this.repaint();
    }

    boolean createBuffer() {
        Dimension size = this.size();
        if (size.width <= 0 || size.height <= 0) {
            return false;
        }
        this._image = this.createImage(size.width, size.height);
        if (this._image == null) {
            return false;
        }
        if (this._graphics != null) {
            this._graphics.dispose();
        }
        this._graphics = this._image.getGraphics();
        return true;
    }

    public Dimension preferredSize() {
        return new Dimension(this.size().width, this._fullHeight);
    }

    void prepare(TextRun run) {
        int oldY = this._nextDrawPoint.y;
        run.prepare(this.size().width, this._scratchDimension, this._nextDrawPoint);
        this._fullHeight = oldY + this._scratchDimension.height;
    }

    synchronized void prepareAll() {
        this._nextDrawPoint.x = 0;
        this._nextDrawPoint.y = 0;
        int width = this.size().width;
        Enumeration e = this._runs.elements();
        while (e.hasMoreElements()) {
            TextRun run = (TextRun)e.nextElement();
            this.prepare(run);
        }
    }

    synchronized void renderViewable(Graphics g) {
        Dimension size = this.size();
        if (this._graphics == null && !this.createBuffer()) {
            return;
        }
        this._graphics.setColor(this.getBackground());
        this._graphics.fillRect(0, 0, size.width, size.height);
        TextRun run = null;
        this._firstRun = -1;
        int i = 0;
        Enumeration e = this._runs.elements();
        while (e.hasMoreElements()) {
            run = (TextRun)e.nextElement();
            Rectangle r = run.getBoundingRect();
            if (r.y - this._yTranslation + r.height >= 0) {
                if (this._firstRun == -1) {
                    this._firstRun = i;
                }
                if (r.y - this._yTranslation > size.height) break;
                run.draw(this._graphics, -this._yTranslation);
            }
            ++i;
        }
        g.drawImage(this._image, 0, 0, this);
    }
}

