/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client;

import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.Client;
import com.lyrisoft.chat.client.IChatClient;
import com.lyrisoft.chat.client.UserCommands;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IChatRoom;
import com.lyrisoft.chat.server.local.CommandProcessorLocal;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class ChatClientApplet
extends Applet {
    protected IChatGUIFactory _guiFactory;
    protected IChatClient _client;
    protected String _host;
    protected int _port = -1;
    protected Component _currentComponent;
    protected UserCommands _userCommands;
    protected CommandProcessorLocal _commandProcessor;
    protected String _room;
    protected String _autoLogin;
    protected boolean _keepAlive = false;
    protected String _tunnelReadUrl = null;
    protected String _tunnelWriteUrl = null;
    protected boolean _tunnelOnly = false;

    protected void readParams() {
        String guiFactoryName;
        String sPort;
        this._host = this.getParameter("host");
        if (this._host == null) {
            this._host = this.getCodeBase().getHost();
        }
        if ((sPort = this.getParameter("port")) != null) {
            this._port = Integer.parseInt(sPort);
        }
        if ((guiFactoryName = this.getParameter("guiFactory")) == null) {
            guiFactoryName = "com.lyrisoft.chat.client.gui.awt102.AppletGUIFactory";
        }
        try {
            this.installGuiFactory(guiFactoryName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error installing guiFactory: " + guiFactoryName);
        }
        this._room = this.getParameter("autojoin");
        this._autoLogin = this.getParameter("autologin");
        String sKeepAlive = this.getParameter("keepalive");
        if (sKeepAlive != null) {
            this._keepAlive = Boolean.valueOf(sKeepAlive);
        }
        this._tunnelReadUrl = this.fixUrl(this.getParameter("tunnelRead"));
        this._tunnelWriteUrl = this.fixUrl(this.getParameter("tunnelWrite"));
        String sTunnelOnly = this.getParameter("tunnelOnly");
        this._tunnelOnly = sTunnelOnly != null ? Boolean.valueOf(sTunnelOnly) : false;
        this.initTranslator();
        this.initCommandProcessor();
        this.initUserCommands();
    }

    void initTranslator() {
        String props = this.getParameter("messages");
        if (props == null) {
            props = "messages.properties";
        }
        Properties p = this.getProperties(props);
        Translator.init(p);
    }

    void initUserCommands() {
        Properties p = this.getProperties("userCommands.properties");
        if (p == null) {
            throw new RuntimeException("Failed to load userCommands.properties");
        }
        this._userCommands = new UserCommands(p);
    }

    void initCommandProcessor() {
        Properties p = this.getProperties("commandProcessors.properties");
        if (p == null) {
            throw new RuntimeException("Failed to load commandProcessors.properties");
        }
        this._commandProcessor = new CommandProcessorLocal(p);
    }

    String fixUrl(String url) {
        if (url == null || url.indexOf(":/") > 0) {
            return url;
        }
        URL codeBase = this.getCodeBase();
        String newUrl = codeBase.getProtocol() + "://" + codeBase.getHost() + ":" + codeBase.getPort() + url;
        System.err.println("new Url = " + newUrl);
        return newUrl;
    }

    void installGuiFactory(String guiFactoryName) throws Exception {
        Color bgColor = null;
        Color errorColor = null;
        Color userColor = null;
        try {
            String sbgColor = this.getParameter("bgColor");
            if (sbgColor != null) {
                bgColor = new Color(Integer.parseInt(sbgColor, 16));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            String serrorColor = this.getParameter("errorColor");
            if (serrorColor != null) {
                errorColor = new Color(Integer.parseInt(serrorColor, 16));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            String suserColor = this.getParameter("userColor");
            if (suserColor != null) {
                userColor = new Color(Integer.parseInt(suserColor, 16));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        System.err.println("Installing GUI Factory: " + guiFactoryName);
        this._guiFactory = (IChatGUIFactory)Class.forName(guiFactoryName).newInstance();
        if (bgColor != null) {
            this._guiFactory.setAttribute("bgColor", bgColor);
        }
        if (userColor != null) {
            this._guiFactory.setAttribute("userColor", userColor);
        }
        if (errorColor != null) {
            this._guiFactory.setAttribute("errorColor", errorColor);
        }
        this._guiFactory.setApplet(this);
    }

    public void init() {
        this.readParams();
        this.setLayout(new GridLayout(1, 1));
    }

    public boolean getKeepAlive() {
        return this._keepAlive;
    }

    protected IChatClient createClient(String readUrl, String writeUrl) {
        return new Client(readUrl, writeUrl);
    }

    protected IChatClient createClient(String host, int port) {
        return new Client(host, port);
    }

    protected IChatClient createClient(String host, int port, String readUrl, String writeUrl) {
        return new Client(host, port, readUrl, writeUrl);
    }

    public void start() {
        this._client = this._tunnelOnly ? this.createClient(this._tunnelReadUrl, this._tunnelWriteUrl) : (this._tunnelReadUrl != null && this._tunnelWriteUrl != null ? this.createClient(this._host, this._port, this._tunnelReadUrl, this._tunnelWriteUrl) : this.createClient(this._host, this._port));
        this._client.setAttribute("guiFactory", this._guiFactory);
        this._client.setAttribute("userCommands", this._userCommands);
        this._client.setAttribute("commandProcessor", this._commandProcessor);
        this._client.setApplet(this);
        this._client.setInitialRoom(this._room);
        this._client.init();
        this._client.showLogin();
        if (this._autoLogin != null) {
            this._client.getServerInterface().signOn(this._autoLogin, null);
        }
    }

    public void stop() {
        if (this._client != null && !this._keepAlive) {
            this._client.getServerInterface().signOff();
        }
    }

    public synchronized void setView(Component c) {
        if (this._currentComponent != null) {
            if (this._currentComponent instanceof IChatRoom) {
                IChatRoom room = (IChatRoom)((Object)this._currentComponent);
                this._client.getServerInterface().partRoom(room.getName());
            }
            this.removeView(this._currentComponent);
        }
        this.add(c);
        this._currentComponent = c;
        this.validate();
    }

    public synchronized void removeView(Component c) {
        Component[] children = this.getComponents();
        if (children.length > 0 && children[0] == c) {
            this.remove(c);
            this._currentComponent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties getProperties(String name) {
        InputStream is = null;
        URL docBase = new URL(this.getCodeBase(), "resources/");
        URL propsUrl = new URL(docBase, name);
        is = propsUrl.openStream();
        Properties p = new Properties();
        p.load(is);
        Properties properties = p;
        Object var8_8 = null;
        if (is == null) return properties;
        try {
            is.close();
            return properties;
        }
        catch (Exception e2) {
            // empty catch block
        }
        return properties;
        catch (Exception e) {
            Object var8_9 = null;
            if (is == null) return null;
            {
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                is.close();
                return null;
            }
            catch (Exception e2) {}
            return null;
        }
    }
}

