/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client;

import com.lyrisoft.chat.Constants;
import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.DumbClient;
import com.lyrisoft.chat.client.IChatClient;
import com.lyrisoft.chat.client.UserCommands;
import com.lyrisoft.chat.client.gui.ChatGUI;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.server.local.ChatServerLocal;
import com.lyrisoft.chat.server.local.IChatServer;
import java.applet.Applet;
import java.net.MalformedURLException;
import java.net.URL;

public class Client
extends DumbClient
implements IChatClientInputReceiver,
IChatClient,
Constants,
ICommands {
    protected IChatServer _serverInterface;
    protected ChatGUI _gui;
    protected String _initialRoom;
    protected Applet _applet;
    protected String _myName;
    protected UserCommands _userCommands = null;
    protected IChatGUIFactory _factory;

    public Client(String host, int port) {
        this._serverInterface = new ChatServerLocal(host, port, (IChatClient)this);
    }

    public Client(String host, int port, String readUrl, String writeUrl) {
        this._serverInterface = new ChatServerLocal(host, port, readUrl, writeUrl, this);
    }

    public Client(String readUrl, String writeUrl) {
        this._serverInterface = new ChatServerLocal(readUrl, writeUrl, (IChatClient)this);
    }

    protected Client() {
    }

    public ChatGUI getGUI() {
        return this._gui;
    }

    public void init() {
        this._factory = (IChatGUIFactory)this.getAttribute("guiFactory");
        if (this._factory == null) {
            throw new RuntimeException("Client: no GUI Factory");
        }
        this._gui = new ChatGUI(this._factory);
        this._factory.setInputReceiver(this);
        this._factory.setChatServer(this._serverInterface);
        this._factory.setMainGui(this._gui);
        this._userCommands = (UserCommands)this.getAttribute("userCommands");
        if (this._userCommands == null) {
            throw new RuntimeException("Client: no UserCommands object");
        }
        this._serverInterface.init();
    }

    public String getMyName() {
        return this._myName;
    }

    public void messageToUserPrivate(String rcpt, String msg) {
        this._gui.messageToUserPrivate(this._myName, rcpt, msg);
    }

    public void emoteToUserPrivate(String rcpt, String msg) {
        this._gui.emoteToUserPrivate(this._myName, rcpt, msg);
    }

    public void setInitialRoom(String room) {
        this._initialRoom = room;
    }

    public boolean runningAsApplet() {
        return this._applet != null;
    }

    public void setApplet(Applet a) {
        this._applet = a;
    }

    public IChatServer getServerInterface() {
        return this._serverInterface;
    }

    public void showLink(String link) {
        if (this._applet != null) {
            try {
                this._applet.getAppletContext().showDocument(new URL(link), "_nfcLinks");
            }
            catch (MalformedURLException e) {
                System.err.println(e);
            }
        } else {
            System.err.println("href=[" + link + "]");
        }
    }

    public void inputEvent(String room, String txt) {
        if (txt == null || txt.length() == 0) {
            return;
        }
        try {
            this._userCommands.process(txt, room, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loginEvent(String username, String password) {
        this._serverInterface.signOn(username, password);
    }

    public void loginCancelEvent() {
        this._gui.hideLogin();
        this.reset();
    }

    public void ackSignon(String myName) {
        this._gui.hideLogin();
        this._gui.generalMessage(Translator.getMessage("pleasewait"));
        this._myName = myName;
        this._gui.ackSignon();
        if (this._initialRoom != null) {
            this._serverInterface.joinRoom(this._initialRoom, null);
        }
        this._serverInterface.reportVersion(this.getVersion());
        this._serverInterface.requestRoomList();
        this._serverInterface.requestUserList();
    }

    public String getVersion() {
        return Translator.getMessage("client.version", System.getProperty("java.vendor"), System.getProperty("java.version"), System.getProperty("os.name"));
    }

    public void connectionLost() {
        this._gui.generalMessage(Translator.getMessage("connection.closed"));
        this.reset();
    }

    public void showLogin() {
        this._gui.showLogin();
    }

    public void reset() {
        if (this.runningAsApplet()) {
            this._gui.reset();
            this._gui.showLogin();
        } else {
            System.exit(1);
        }
    }

    public void ackJoinRoom(String room) {
        this._gui.ackRoomJoined(room);
        this._serverInterface.requestUsersInRoomList(room);
    }

    public void ackPartRoom(String room) {
        this._gui.ackRoomParted(room);
    }

    public void messageFromUser(String user, String room, String msg) {
        this._gui.messageFromUser(user, room, msg);
    }

    public void messageFromUserPrivate(String user, String msg) {
        this._gui.messageFromUserPrivate(user, msg);
    }

    public void emoteFromUserPrivate(String user, String msg) {
        this._gui.emoteFromUserPrivate(user, msg);
    }

    public void roomList(String[] roomList) {
        this._gui.roomList(roomList);
    }

    public void globalUserList(String[] users) {
        this._gui.globalUserList(users);
    }

    public void roomUserList(String room, String[] users) {
        this._gui.roomUserList(room, users);
    }

    public void userJoinedRoom(String user, String room) {
        this._gui.userJoinedRoom(user, room);
    }

    public void userPartedRoom(String user, String room, boolean signOff) {
        this._gui.userPartedRoom(user, room, signOff);
    }

    public void generalError(String message) {
        this._factory.playAudioClip("error.au");
        this._gui.generalError(message);
    }

    public void generalMessage(String message) {
        this._gui.generalMessage(message);
    }

    public void generalRoomMessage(String room, String message) {
        this._gui.generalRoomMessage(room, message);
    }

    public void ping(String user, String arg) {
        this._serverInterface.sendPong(user, arg);
        if (!"server".equals(user)) {
            this._gui.generalMessage(Translator.getMessage("ping.from", user));
        }
    }

    public void pong(String user, String arg) {
        long delta = System.currentTimeMillis() - Long.valueOf(arg);
        String s = Translator.getMessage("ping.reply", user, String.valueOf(delta), "ms");
        this._gui.generalMessage(s);
    }

    public void killed(String killer, String msg) {
        this.generalMessage(Translator.getMessage("killed.by", killer, msg));
    }

    public void ackKill(String victim) {
        this.generalMessage(Translator.getMessage("killed", victim));
    }

    public void emote(String from, String room, String message) {
        this.generalRoomMessage(room, from + " " + message);
    }

    public void userSignOn(String userId) {
        this._gui.userSignOn(userId);
    }

    public void userSignOff(String userId) {
        this._gui.userSignOff(userId);
    }

    public void roomCreated(String room) {
        this._gui.roomCreated(room);
    }

    public void roomDestroyed(String room) {
        this._gui.roomDestroyed(room);
    }

    public void userDoubleClick(String user) {
        this.inputEvent(null, "/msg " + user);
    }
}

