/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client;

import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.Client;
import com.lyrisoft.chat.client.UserCommands;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.server.local.CommandProcessorLocal;
import java.util.Properties;

public class Main {
    public static void main(String[] args) {
        String host = null;
        int port = 0;
        try {
            host = args[0];
            port = Integer.parseInt(args[1]);
        }
        catch (Exception e) {
            Main.showUsageAndQuit();
        }
        IChatGUIFactory factory = null;
        UserCommands userCommands = null;
        CommandProcessorLocal commandProcessor = null;
        Client client = new Client(host, port);
        try {
            String guiFactoryName = System.getProperty("guiFactory", "com.lyrisoft.chat.client.gui.awt102.GUIFactory");
            factory = (IChatGUIFactory)Class.forName(guiFactoryName).newInstance();
            Properties p = client.getProperties("commandProcessors.properties");
            if (p == null) {
                throw new Exception("Could not load commandProcessors.properties");
            }
            commandProcessor = new CommandProcessorLocal(p);
            p = client.getProperties("userCommands.properties");
            if (p == null) {
                throw new Exception("Could not load userCommands.properties");
            }
            userCommands = new UserCommands(p);
            p = client.getProperties("messages.properties");
            Main.initTranslator(p);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        client.setAttribute("guiFactory", factory);
        client.setAttribute("userCommands", userCommands);
        client.setAttribute("commandProcessor", commandProcessor);
        client.init();
        client.getGUI().showLogin();
    }

    protected static void initTranslator(Properties p) {
        Translator.init(p);
    }

    static void showUsageAndQuit() {
        System.err.println("usage: java com.lyrisoft.chat.client.Main host port");
        System.exit(1);
    }
}

