/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client;

import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.Client;
import com.lyrisoft.chat.client.command.NotEnoughArgumentsException;
import com.lyrisoft.chat.client.command.SayToRoom;
import com.lyrisoft.chat.client.command.UserCommandProcessor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class UserCommands {
    private Hashtable _processors;
    private UserCommandProcessor defaultProcessor = new SayToRoom();

    public UserCommands(Properties p) {
        this._processors = new Hashtable();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            try {
                String className = p.getProperty(name);
                UserCommandProcessor cp = (UserCommandProcessor)Class.forName(className).newInstance();
                this.extendCommandSet("/" + name, cp);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("Failed to initialize " + name + " user command");
            }
        }
    }

    public void extendCommandSet(String command, UserCommandProcessor p) {
        this._processors.put(command, p);
    }

    public void process(String input, String arg, Client client) {
        if ((input = input.trim()).length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(input, " ");
        String key = st.nextToken();
        UserCommandProcessor processor = (UserCommandProcessor)this._processors.get(key);
        try {
            if (processor != null) {
                processor.process(input, arg, client);
            } else if (key.charAt(0) != '/') {
                this.defaultProcessor.process(input, arg, client);
            } else {
                client.generalError(Translator.getMessage("no.such.command", key));
            }
        }
        catch (NotEnoughArgumentsException e) {
            client.generalError(e.getMessage());
            client.getServerInterface().help(key);
        }
    }
}

