/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui;

import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IChatRoom;
import com.lyrisoft.chat.client.gui.IConsole;
import com.lyrisoft.chat.client.gui.ILogin;
import com.lyrisoft.chat.client.gui.IMessageWindow;
import com.lyrisoft.chat.client.gui.IPrivateChatRoom;
import com.lyrisoft.chat.server.local.CommandProcessorLocal;
import java.util.Enumeration;
import java.util.Hashtable;

public class ChatGUI {
    private Hashtable _roomGUIs = new Hashtable();
    private Hashtable _privateChats = new Hashtable();
    private IMessageWindow _status;
    private IChatGUIFactory _guiFactory;
    private ILogin _login;
    private IConsole _console;

    public ChatGUI(IChatGUIFactory factory) {
        this._guiFactory = factory;
    }

    public void showLogin() {
        this._login = this._guiFactory.createLoginDialog();
        this._guiFactory.show(this._login);
    }

    public void hideLogin() {
        if (this._login != null) {
            this._guiFactory.hide(this._login);
            this._login = null;
        }
    }

    public void reset() {
        Enumeration e = this._roomGUIs.keys();
        while (e.hasMoreElements()) {
            IChatRoom room = (IChatRoom)this._roomGUIs.remove(e.nextElement());
            this._guiFactory.hide(room);
        }
        Enumeration e2 = this._privateChats.keys();
        while (e2.hasMoreElements()) {
            IPrivateChatRoom room = (IPrivateChatRoom)this._privateChats.remove(e2.nextElement());
            this._guiFactory.hide(room);
        }
        if (this._console != null) {
            this._guiFactory.hide(this._console);
        }
        if (this._login != null) {
            this._guiFactory.hide(this._login);
            this._login = null;
        }
        this._status = null;
        this._login = null;
    }

    static String roomKey(String room) {
        return room.toLowerCase();
    }

    public void setStatusGui(IMessageWindow window) {
        this._status = window;
    }

    public IMessageWindow getStatusGui() {
        return this._status;
    }

    public void ackSignon() {
        this.showConsole();
    }

    void showConsole() {
        this._console = this._guiFactory.createConsole();
        this._guiFactory.show(this._console);
        this.setStatusGui(this._console);
    }

    public void ackRoomJoined(String room) {
        IChatRoom chatRoom = this._guiFactory.createChatRoom(room);
        this._roomGUIs.put(ChatGUI.roomKey(room), chatRoom);
        this._guiFactory.show(chatRoom);
    }

    public void ackRoomParted(String room) {
        IChatRoom chatRoom = (IChatRoom)this._roomGUIs.remove(ChatGUI.roomKey(room));
        if (chatRoom != null) {
            this._guiFactory.hide(chatRoom);
        }
        if (this._roomGUIs.size() == 0) {
            System.err.println("Showing console because there are no more room windows.");
            this.showConsole();
        }
    }

    public void messageFromUser(String user, String room, String msg) {
        IChatRoom chatRoom = (IChatRoom)this._roomGUIs.get(ChatGUI.roomKey(room));
        if (chatRoom != null) {
            chatRoom.displayMessage(user, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPrivateChatRoom getPrivateRoom(String user) {
        IPrivateChatRoom pchat = null;
        Hashtable hashtable = this._privateChats;
        synchronized (hashtable) {
            pchat = (IPrivateChatRoom)this._privateChats.get(user.toUpperCase());
            if (pchat == null) {
                pchat = this._guiFactory.createPrivateChatRoom(user);
                this._guiFactory.show(pchat);
                this._guiFactory.playAudioClip("private.au");
                this._privateChats.put(user.toUpperCase(), pchat);
            }
        }
        return pchat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePrivateChatRoom(String name) {
        IPrivateChatRoom pchat = null;
        Hashtable hashtable = this._privateChats;
        synchronized (hashtable) {
            pchat = (IPrivateChatRoom)this._privateChats.remove(name.toUpperCase());
        }
        if (pchat != null) {
            this._guiFactory.hide(pchat);
        }
    }

    public void messageToUserPrivate(String me, String user, String msg) {
        IPrivateChatRoom pchat = this.getPrivateRoom(user);
        pchat.displayPrivateMessage(me, msg);
    }

    public void emoteToUserPrivate(String me, String user, String msg) {
        IPrivateChatRoom pchat = this.getPrivateRoom(user);
        pchat.displayPrivateEmote(me, msg);
    }

    public void messageFromUserPrivate(String user, String msg) {
        IPrivateChatRoom pchat = this.getPrivateRoom(user);
        pchat.displayPrivateMessage(user, msg);
    }

    public void emoteFromUserPrivate(String user, String msg) {
        IPrivateChatRoom pchat = this.getPrivateRoom(user);
        pchat.displayPrivateEmote(user, msg);
    }

    public void roomList(String[] roomList) {
        this._console.clearRooms();
        int i = 0;
        while (i < roomList.length) {
            String[] s = CommandProcessorLocal.decompose(roomList[i]);
            this._console.addRoom(s[0], s[1], false);
            ++i;
        }
    }

    public void globalUserList(String[] users) {
        this._console.clearUsers();
        int i = 0;
        while (i < users.length) {
            this._console.addUser(users[i], false);
            ++i;
        }
    }

    public void roomUserList(String room, String[] users) {
        IChatRoom chatRoom = (IChatRoom)this._roomGUIs.get(ChatGUI.roomKey(room));
        if (chatRoom != null) {
            chatRoom.setUserList(users);
        }
    }

    public void userJoinedRoom(String user, String room) {
        IChatRoom chatRoom = (IChatRoom)this._roomGUIs.get(ChatGUI.roomKey(room));
        if (chatRoom != null) {
            chatRoom.userJoinedRoom(user);
        }
    }

    public void userPartedRoom(String user, String room, boolean signOff) {
        IChatRoom chatRoom = (IChatRoom)this._roomGUIs.get(ChatGUI.roomKey(room));
        if (chatRoom != null) {
            chatRoom.userPartedRoom(user, signOff);
        }
    }

    public void generalError(String message) {
        if (this._status == null) {
            if (this._login != null) {
                this._login.setStatus(message);
            } else {
                System.err.println("ChatGUI.generalError():" + message);
            }
        } else {
            this._status.displayError(message);
        }
    }

    public void generalMessage(String message) {
        if (this._status == null) {
            if (this._login != null) {
                this._login.setStatus(message);
            } else {
                System.err.println("ChatGUI.generalMessage():" + message);
            }
        } else {
            this._status.displayMessage(message);
        }
    }

    public void generalRoomMessage(String room, String message) {
        IChatRoom chatRoom = (IChatRoom)this._roomGUIs.get(ChatGUI.roomKey(room));
        if (chatRoom != null) {
            chatRoom.displayMessage(message);
        }
    }

    public void userSignOn(String userId) {
        this._console.addUser(userId, true);
    }

    public void userSignOff(String userId) {
        this._console.removeUser(userId, true);
    }

    public void roomCreated(String room) {
        this._console.addRoom(room, "1", true);
    }

    public void roomDestroyed(String room) {
        this._console.removeRoom(room, true);
    }
}

