/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.awt.HyperlinkReceiver;
import com.lyrisoft.awt.HyperlinkTextRun;
import com.lyrisoft.awt.HyperlinkTextView;
import com.lyrisoft.awt.TextStyle;
import com.lyrisoft.awt.TextView;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Rectangle;

public class About
extends Dialog
implements HyperlinkReceiver {
    private Button ok = new Button(Translator.getMessage("label.ok"));
    private HyperlinkTextView textView;
    private IChatClientInputReceiver _inputReceiver;

    public About(Frame owner, IChatClientInputReceiver inputReceiver) {
        super(owner, Translator.getMessage("label.about.nfc"), true);
        this._inputReceiver = inputReceiver;
        this.setLayout(new BorderLayout());
        this.textView = new HyperlinkTextView(true, this);
        TextStyle linkStyle = new TextStyle(TextView.DEFAULT_FONT, Color.blue);
        this.textView.append(new HyperlinkTextRun("NFC Chat", "http://nfcchat.sourceforge.net/", linkStyle));
        this.textView.append("\n");
        this.textView.append("Copyright (c) 2000 Lyrisoft Solutions Inc.\n");
        this.textView.append(" \n");
        this.textView.append("Licensed under the ");
        this.textView.append(new HyperlinkTextRun("LGPL", "http://www.gnu.org/copyleft/lesser.txt", linkStyle));
        this.textView.append("\n");
        this.add("Center", this.textView);
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        p.add(this.ok);
        this.add("South", p);
        this.textView.resize(320, 200);
        this.pack();
        this.center();
        this.show();
    }

    public void handleHyperlink(String link) {
        this._inputReceiver.inputEvent("AboutBox", "/link " + link);
    }

    public boolean action(Event e, Object arg) {
        if (e.target == this.ok) {
            this.hide();
            return true;
        }
        return super.action(e, arg);
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        About about = new About(f, null);
    }

    public void center() {
        Rectangle pr = this.getParent().bounds();
        Rectangle r = this.bounds();
        this.move(Math.max(0, (pr.width - r.width) / 2 + pr.x), Math.max(0, (pr.height - r.height) / 2 + pr.y));
    }
}

