/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.ChatClientApplet;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IConsole;
import com.lyrisoft.chat.client.gui.ILogin;
import com.lyrisoft.chat.client.gui.awt102.GUIFactory;
import com.lyrisoft.chat.client.gui.awt102.LoginPanel;
import java.applet.AudioClip;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class AppletGUIFactory
extends GUIFactory
implements IChatGUIFactory {
    protected ChatClientApplet _applet;
    private TextArea _textArea;
    private URL _docBase;
    private MediaTracker _mediaTracker;

    public void setApplet(ChatClientApplet a) {
        this._applet = a;
        try {
            this._docBase = new URL(a.getCodeBase(), "resources/");
        }
        catch (MalformedURLException e) {
            return;
        }
        this._mediaTracker = new MediaTracker(a);
    }

    public IConsole createConsole() {
        IConsole console = super.createConsole();
        this.showTextArea();
        return console;
    }

    public ILogin createLoginDialog() {
        LoginPanel lp = new LoginPanel(this, this._inputReceiver);
        this._applet.setView(lp);
        return lp;
    }

    public void hide(ILogin login) {
        this._applet.removeView((LoginPanel)login);
    }

    public void show(ILogin login) {
        this._applet.setView((LoginPanel)login);
    }

    public void show(IConsole c) {
        this.showTextArea();
        super.show(c);
    }

    private void showTextArea() {
        if (this._textArea == null) {
            this._textArea = new TextArea();
            this._textArea.setEditable(false);
        }
        this._textArea.setText(Translator.getMessage("chat.running1"));
        this._textArea.appendText("\n\n");
        if (!this._applet.getKeepAlive()) {
            this._textArea.appendText(Translator.getMessage("chat.running2") + "\n");
            this._textArea.appendText(Translator.getMessage("chat.running3") + "\n");
        }
        this._applet.setView(this._textArea);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties getProperties(String name) {
        InputStream is = null;
        URL propsUrl = new URL(this._docBase, name);
        is = propsUrl.openStream();
        Properties p = new Properties();
        p.load(is);
        Properties properties = p;
        Object var7_7 = null;
        if (is == null) return properties;
        try {
            is.close();
            return properties;
        }
        catch (Exception e2) {
            // empty catch block
        }
        return properties;
        catch (Exception e) {
            Object var7_8 = null;
            if (is == null) return null;
            {
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                is.close();
                return null;
            }
            catch (Exception e2) {}
            return null;
        }
    }

    public Image getImage(String name) {
        try {
            URL url = new URL(this._docBase, name);
            Image i = Toolkit.getDefaultToolkit().getImage(url);
            this._mediaTracker.addImage(i, 0);
            this._mediaTracker.waitForAll();
            return i;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void playAudioClip(String name) {
        if (this._playSounds) {
            AudioClip clip = this._applet.getAudioClip(this._docBase, name);
            clip.play();
        }
    }
}

