/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.awt.ImageButton;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IChatRoom;
import com.lyrisoft.chat.client.gui.IQuery;
import com.lyrisoft.chat.client.gui.IQueryCallback;
import com.lyrisoft.chat.client.gui.awt102.Constraints;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;

public class ChatPanel
extends Panel
implements IChatRoom,
IQueryCallback {
    protected Color bgColor;
    protected IChatClientInputReceiver _inputReceiver;
    protected String _room;
    protected String _title;
    protected IChatGUIFactory _factory;
    protected GridBagLayout gridbag = new GridBagLayout();
    protected TextArea txtMessages;
    protected List lstUsers;
    protected TextField txtInput;
    protected Panel _buttonPanel;
    protected Component btnClose;
    protected Component btnEmote;
    protected Component btnPing;
    protected Component btnUserInfo;
    protected Component btnEmotePrivate;
    protected Component btnPrivate;
    protected Component btnStats;
    protected Component btnHelp;
    protected MenuItem miPrivate = new MenuItem(Translator.getMessage("label.private"));
    protected MenuItem miEmotePrivate = new MenuItem(Translator.getMessage("label.mesg"));
    protected MenuItem miEmote = new MenuItem(Translator.getMessage("label.emote"));
    protected MenuItem miStats = new MenuItem(Translator.getMessage("label.stats"));
    protected MenuItem miPing = new MenuItem(Translator.getMessage("label.ping"));
    protected MenuItem miWhois = new MenuItem(Translator.getMessage("label.whois"));
    protected boolean _showingBigButtons = true;
    protected static final int PING = 0;
    protected static final int PRIVATE = 1;
    protected static final int EMOTE = 2;
    protected static final int PRIVATE_EMOTE = 3;
    protected static final int WHOIS = 4;
    public static boolean s_useDialogs;

    public ChatPanel(IChatGUIFactory factory, String room, String title, IChatClientInputReceiver inputReceiver) {
        this._title = title;
        this._factory = factory;
        this.bgColor = (Color)factory.getAttribute("bgColor");
        if (this.bgColor == null) {
            this.bgColor = new Color(3689671);
        }
        this._room = room;
        this._inputReceiver = inputReceiver;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ChatPanel(IChatGUIFactory factory, String room, IChatClientInputReceiver inputReceiver) {
        this(factory, room, room, inputReceiver);
    }

    public String getName() {
        return this._room;
    }

    public void requestFocus() {
        this.txtInput.requestFocus();
    }

    public void inputEvent(String txt) {
        this._inputReceiver.inputEvent(this._room, txt);
    }

    public void displayPrivateMessage(String user, String message) {
        this.displayMessage(Translator.getMessage("private", user, message));
    }

    public void displayPrivateEmote(String user, String message) {
        this.displayMessage(Translator.getMessage("mesg", user, message));
    }

    public void displayMessage(String user, String message) {
        this.displayMessage(user + ": " + message);
    }

    public void displayMessage(String message) {
        this.txtMessages.appendText(message + "\n");
    }

    public void displayError(String error) {
        this.displayMessage(Translator.getMessage("error", error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserList(String[] users) {
        List list = this.lstUsers;
        synchronized (list) {
            this.lstUsers.clear();
            int i = 0;
            while (i < users.length) {
                this.lstUsers.addItem(users[i]);
                ++i;
            }
            this.forceUserListRepaint();
        }
    }

    void forceUserListRepaint() {
        this.lstUsers.invalidate();
        this.lstUsers.getParent().validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUserList() {
        List list = this.lstUsers;
        synchronized (list) {
            String[] list2 = new String[this.lstUsers.countItems()];
            int i = 0;
            while (i < list2.length) {
                list2[i] = this.lstUsers.getItem(i);
                ++i;
            }
            String[] stringArray = list2;
            return stringArray;
        }
    }

    public void userJoinedRoom(String user) {
        this.displayMessage(Translator.getMessage("joined", user));
        if (!this.listContains(user)) {
            this.lstUsers.addItem(user);
            this.forceUserListRepaint();
        }
    }

    private boolean listContains(String s) {
        int len = this.lstUsers.countItems();
        int i = 0;
        while (i < len) {
            if (s.equals(this.lstUsers.getItem(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void userPartedRoom(String user, boolean signoff) {
        if (signoff) {
            this.displayMessage(Translator.getMessage("part2", user));
        } else {
            this.displayMessage(Translator.getMessage("part1", user));
        }
        int len = this.lstUsers.countItems();
        int i = 0;
        while (i < len) {
            if (user.equals(this.lstUsers.getItem(i))) {
                this.lstUsers.delItem(i);
                this.forceUserListRepaint();
                break;
            }
            ++i;
        }
    }

    protected Component createTextWidget() {
        this.txtMessages = new TextArea();
        this.txtMessages.setBackground(Color.white);
        this.txtMessages.setText("");
        this.txtMessages.setEditable(false);
        return this.txtMessages;
    }

    protected Component createTitleArea() {
        Label l = new Label(this._title);
        l.setBackground(this.bgColor);
        l.setForeground(Color.white);
        l.setFont(new Font("Dialog", 1, 14));
        return l;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridbag);
        Component lblTitle = this.createTitleArea();
        if (lblTitle != null) {
            this.gridbag.setConstraints(lblTitle, Constraints.create(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(lblTitle);
        }
        Component c = this.createButtonPanel();
        this._buttonPanel = new Panel();
        this._buttonPanel.setBackground(this.bgColor);
        GridBagLayout gb2 = new GridBagLayout();
        this._buttonPanel.setLayout(gb2);
        gb2.setConstraints(c, Constraints.create(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._buttonPanel.add(c);
        this.gridbag.setConstraints(this._buttonPanel, Constraints.create(0, 1, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._buttonPanel);
        Component txtWidget = this.createTextWidget();
        this.gridbag.setConstraints(txtWidget, Constraints.create(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(txtWidget);
        this.lstUsers = new List();
        this.gridbag.setConstraints(this.lstUsers, Constraints.create(1, 2, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.lstUsers);
        this.txtInput = new TextField();
        this.txtInput.setBackground(Color.white);
        this.gridbag.setConstraints(this.txtInput, Constraints.create(0, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 4));
        this.add(this.txtInput);
    }

    protected Component createButton(String img, String name) {
        if (img != null) {
            try {
                Image i = this._factory.getImage(img);
                if (i != null && i.getHeight(this) > 0 && i.getWidth(this) > 0) {
                    return new ImageButton(i, name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Button b = new Button(name);
        b.setBackground(this.bgColor);
        b.setForeground(Color.yellow);
        return b;
    }

    protected GridBagConstraints createButtonConstraints(int number) {
        return Constraints.create(number, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0);
    }

    protected Component createButtonPanel() {
        Panel p = new Panel();
        p.setBackground(this.bgColor);
        GridBagLayout gb2 = new GridBagLayout();
        p.setLayout(gb2);
        int i = 0;
        this.btnPrivate = this.createButton("private.gif", Translator.getMessage("label.private"));
        gb2.setConstraints(this.btnPrivate, this.createButtonConstraints(i++));
        p.add(this.btnPrivate);
        this.btnEmote = this.createButton("emote.gif", Translator.getMessage("label.emote"));
        gb2.setConstraints(this.btnEmote, this.createButtonConstraints(i++));
        p.add(this.btnEmote);
        this.btnPing = this.createButton("ping.gif", Translator.getMessage("label.ping"));
        gb2.setConstraints(this.btnPing, this.createButtonConstraints(i++));
        p.add(this.btnPing);
        this.btnUserInfo = this.createButton("whois.gif", Translator.getMessage("label.whois"));
        gb2.setConstraints(this.btnUserInfo, this.createButtonConstraints(i++));
        p.add(this.btnUserInfo);
        this.btnStats = this.createButton("stats.gif", Translator.getMessage("label.stats"));
        gb2.setConstraints(this.btnStats, this.createButtonConstraints(i++));
        p.add(this.btnStats);
        this.btnHelp = this.createButton("help.gif", Translator.getMessage("label.help"));
        gb2.setConstraints(this.btnHelp, this.createButtonConstraints(i++));
        p.add(this.btnHelp);
        return p;
    }

    public boolean action(Event e, Object o) {
        if (e.id == 1001) {
            if (e.target == this.lstUsers) {
                this._inputReceiver.userDoubleClick((String)o);
                return true;
            }
            if (e.target == this.txtInput) {
                this._inputReceiver.inputEvent(this._room, (String)o);
                this.txtInput.setText("");
                return true;
            }
            if (e.target == this.btnStats || e.target == this.miStats) {
                this._inputReceiver.inputEvent(this._room, "/stats");
                return true;
            }
            if (e.target == this.btnClose) {
                this._inputReceiver.inputEvent(this._room, "/leave");
                return true;
            }
            if (e.target == this.btnPing || e.target == this.miPing) {
                if (!s_useDialogs) {
                    String user = this.lstUsers.getSelectedItem();
                    if (user != null) {
                        this._inputReceiver.inputEvent(this._room, "/ping " + user);
                    } else {
                        this.displayError(Translator.getMessage("error.ping"));
                    }
                } else {
                    IQuery q = this._factory.createQuery(Translator.getMessage("ping"), Translator.getMessage("label.user") + ":", this.getUserList(), false, null);
                    q.setCallbackParams(0, this);
                    String def = this.lstUsers.getSelectedItem();
                    if (def != null) {
                        q.setDefaultSelection(def);
                    }
                    q.show();
                }
                return true;
            }
            if (e.target == this.btnUserInfo || e.target == this.miWhois) {
                if (!s_useDialogs) {
                    String user = this.lstUsers.getSelectedItem();
                    if (user != null) {
                        this._inputReceiver.inputEvent(this._room, "/whois " + user);
                    } else {
                        this.displayError(Translator.getMessage("error.whois"));
                    }
                } else {
                    IQuery q = this._factory.createQuery(Translator.getMessage("label.compose.whois"), Translator.getMessage("label.user") + ":", this.getUserList(), false, null);
                    q.setCallbackParams(4, this);
                    String def = this.lstUsers.getSelectedItem();
                    if (def != null) {
                        q.setDefaultSelection(def);
                    }
                    q.show();
                }
                return true;
            }
            if (e.target == this.btnPrivate || e.target == this.miPrivate) {
                if (!s_useDialogs) {
                    String user = this.lstUsers.getSelectedItem();
                    if (user != null) {
                        String msg = this.txtInput.getText();
                        if (msg != null && msg.length() > 0) {
                            this._inputReceiver.inputEvent(this._room, "/msg " + user + " " + msg);
                            this.txtInput.setText("");
                        } else {
                            this.displayError(Translator.getMessage("error.private2"));
                        }
                    } else {
                        this.displayError(Translator.getMessage("error.private1"));
                    }
                } else {
                    IQuery q = this._factory.createQuery(Translator.getMessage("label.compose.private"), Translator.getMessage("label.to") + ":", this.getUserList(), true, Translator.getMessage("label.private") + ":");
                    q.setCallbackParams(1, this);
                    String def = this.lstUsers.getSelectedItem();
                    if (def != null) {
                        q.setDefaultSelection(def);
                    }
                    q.show();
                }
                return true;
            }
            if (e.target == this.btnEmotePrivate || e.target == this.miEmotePrivate) {
                if (!s_useDialogs) {
                    String user = this.lstUsers.getSelectedItem();
                    if (user != null) {
                        String msg = this.txtInput.getText();
                        if (msg != null && msg.length() > 0) {
                            this._inputReceiver.inputEvent(this._room, "/mesg " + user + " " + msg);
                            this.txtInput.setText("");
                        } else {
                            this.displayError(Translator.getMessage("error.mesg2"));
                        }
                    } else {
                        this.displayError(Translator.getMessage("error.mesg1"));
                    }
                } else {
                    IQuery q = this._factory.createQuery(Translator.getMessage("label.compose.mesg"), Translator.getMessage("label.to:"), this.getUserList(), true, Translator.getMessage("label.emote") + ":");
                    q.setCallbackParams(3, this);
                    String def = this.lstUsers.getSelectedItem();
                    if (def != null) {
                        q.setDefaultSelection(def);
                    }
                    q.show();
                }
                return true;
            }
            if (e.target == this.btnEmote || e.target == this.miEmote) {
                if (!s_useDialogs) {
                    String msg = this.txtInput.getText();
                    if (msg != null && msg.length() > 0) {
                        this._inputReceiver.inputEvent(this._room, "/me " + msg);
                        this.txtInput.setText("");
                    } else {
                        this.displayError(Translator.getMessage("error.emote"));
                    }
                } else {
                    IQuery q = this._factory.createQuery(Translator.getMessage("label.compose.emote"), null, null, true, Translator.getMessage("label.emote"));
                    q.setCallbackParams(2, this);
                    q.show();
                }
                return true;
            }
            if (e.target == this.btnHelp) {
                this._inputReceiver.inputEvent(this._room, "/help");
            }
        }
        return super.action(e, o);
    }

    public void handleQuery(int id, IQuery q) {
        if (q.getCanceled()) {
            q.dispose();
            return;
        }
        switch (id) {
            case 0: {
                String user = q.getSelection();
                this._inputReceiver.inputEvent(this._room, "/ping " + user);
                break;
            }
            case 1: {
                String user = q.getSelection();
                String msg = q.getText();
                this._inputReceiver.inputEvent(this._room, "/msg " + user + " " + msg);
                this.txtInput.setText("");
                break;
            }
            case 3: {
                String user = q.getSelection();
                String msg = q.getText();
                this._inputReceiver.inputEvent(this._room, "/mesg " + user + " " + msg);
                this.txtInput.setText("");
                break;
            }
            case 2: {
                String msg = q.getText();
                this._inputReceiver.inputEvent(this._room, "/me " + msg);
                this.txtInput.setText("");
                break;
            }
            case 4: {
                String user = q.getSelection();
                this._inputReceiver.inputEvent(this._room, "/whois " + user);
            }
        }
        q.dispose();
    }

    protected Menu createActionMenu() {
        Menu m = new Menu(Translator.getMessage("label.action"));
        m.add(this.miPrivate);
        m.add(this.miEmotePrivate);
        m.add(this.miEmote);
        m.add(this.miStats);
        m.add(this.miPing);
        m.add(this.miWhois);
        return m;
    }

    public void showBigButtons(boolean b) {
        if (b) {
            if (!this._showingBigButtons) {
                this.add(this._buttonPanel);
                this.gridbag.setConstraints(this._buttonPanel, Constraints.create(0, 1, 2, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
                this._buttonPanel.invalidate();
                this.validate();
            }
            this._showingBigButtons = true;
        } else if (this._showingBigButtons) {
            this.remove(this._buttonPanel);
            this.validate();
            this._showingBigButtons = false;
        }
    }

    static {
        PING = 0;
        PRIVATE = 1;
        EMOTE = 2;
        PRIVATE_EMOTE = 3;
        WHOIS = 4;
        s_useDialogs = false;
    }
}

