/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.gui.ChatGUI;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IChatRoom;
import com.lyrisoft.chat.client.gui.awt102.EnhancedChatPanel;
import com.lyrisoft.chat.server.local.IChatServer;
import java.awt.CheckboxMenuItem;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Toolkit;

public class ChatRoom
extends Frame
implements IChatRoom {
    protected EnhancedChatPanel _chatPanel;
    protected String _room;
    protected ChatGUI _mainGUI;
    protected IChatServer _server;
    protected IChatGUIFactory _factory;
    protected Menu fileMenu;
    protected Menu fontStyleMenu;
    protected Menu fontSizeMenu;
    protected Menu helpMenu;
    protected CheckboxMenuItem miButtonsOn = new CheckboxMenuItem(Translator.getMessage("label.on"));
    protected CheckboxMenuItem miButtonsOff = new CheckboxMenuItem(Translator.getMessage("label.off"));
    protected CheckboxMenuItem[] fontSizeMenuItems;
    protected CheckboxMenuItem[] fontStyleMenuItems;

    public ChatRoom(String room, String title, IChatGUIFactory factory, ChatGUI mainGui, IChatClientInputReceiver inputReceiver, IChatServer server) {
        this._factory = factory;
        this._server = server;
        this.setTitle(title);
        this._mainGUI = mainGui;
        this._room = room;
        this.resize(600, 400);
        this._chatPanel = this.createPanel(factory, room, title, inputReceiver);
        this.setLayout(new GridLayout(1, 1));
        this.add(this._chatPanel);
        this.setMenuBar(this.createMenuBar());
    }

    public ChatRoom(String room, IChatGUIFactory factory, ChatGUI mainGui, IChatClientInputReceiver inputReceiver, IChatServer server) {
        this(room, room, factory, mainGui, inputReceiver, server);
    }

    protected EnhancedChatPanel createPanel(IChatGUIFactory factory, String name, String title, IChatClientInputReceiver inputReceiver) {
        return new EnhancedChatPanel(factory, name, title, inputReceiver);
    }

    public void show() {
        super.show();
        this._chatPanel.requestFocus();
        this._mainGUI.hideLogin();
    }

    protected MenuBar createMenuBar() {
        MenuBar mb = new MenuBar();
        this.fileMenu = new Menu(Translator.getMessage("label.file"));
        this.fileMenu.add(new MenuItem(Translator.getMessage("label.close")));
        mb.add(this.fileMenu);
        Menu m = this.createFontMenu();
        mb.add(m);
        m = this._chatPanel.createActionMenu();
        mb.add(m);
        m = this.createOptionsMenu();
        mb.add(m);
        this.helpMenu = new Menu(Translator.getMessage("label.help"));
        this.helpMenu.add(new MenuItem(Translator.getMessage("label.about")));
        mb.setHelpMenu(this.helpMenu);
        return mb;
    }

    protected Menu createOptionsMenu() {
        Menu buttonBar = new Menu(Translator.getMessage("label.buttonbar"));
        buttonBar.add(this.miButtonsOn);
        this.miButtonsOn.setState(true);
        buttonBar.add(this.miButtonsOff);
        Menu m = new Menu(Translator.getMessage("label.options"));
        m.add(buttonBar);
        return m;
    }

    protected Menu createFontMenu() {
        this.fontSizeMenu = new Menu(Translator.getMessage("label.size"));
        this.fontSizeMenuItems = new CheckboxMenuItem[18];
        int i = 6;
        while (i < 24) {
            CheckboxMenuItem cb = new CheckboxMenuItem(String.valueOf(i));
            this.fontSizeMenu.add(cb);
            if (i == 10) {
                cb.setState(true);
            }
            this.fontSizeMenuItems[i - 6] = cb;
            ++i;
        }
        this.fontStyleMenu = new Menu(Translator.getMessage("label.style"));
        String[] fonts = Toolkit.getDefaultToolkit().getFontList();
        this.fontStyleMenuItems = new CheckboxMenuItem[fonts.length];
        int i2 = 0;
        while (i2 < fonts.length) {
            CheckboxMenuItem cb = new CheckboxMenuItem(fonts[i2]);
            this.fontStyleMenu.add(cb);
            if ("Dialog".equalsIgnoreCase(fonts[i2])) {
                cb.setState(true);
            }
            this.fontStyleMenuItems[i2] = cb;
            ++i2;
        }
        Menu m = new Menu(Translator.getMessage("label.font"));
        m.add(this.fontSizeMenu);
        m.add(this.fontStyleMenu);
        return m;
    }

    public String getName() {
        return this._room;
    }

    public boolean handleEvent(Event e) {
        if (e.target == this && e.id == 201) {
            this._server.partRoom(this._room);
        } else if (e.id == 1004) {
            this._mainGUI.setStatusGui(this);
        }
        return super.handleEvent(e);
    }

    public void setFont(String name) {
        this._chatPanel.setFont(name);
    }

    public void setFontSize(int size) {
        this._chatPanel.setFontSize(size);
    }

    public void handleMenuEvent(Event e, Object arg0) {
        if (arg0 == null) {
            return;
        }
        String arg = arg0.toString();
        if (Translator.getMessage("label.close").equals(arg)) {
            this._server.partRoom(this._room);
            return;
        }
        if (Translator.getMessage("label.about").equals(arg)) {
            this._factory.createAboutDialog();
            return;
        }
        if (e.target == this.miButtonsOn) {
            this._chatPanel.showBigButtons(true);
            this.miButtonsOn.setState(true);
            this.miButtonsOff.setState(false);
            return;
        }
        if (e.target == this.miButtonsOff) {
            this._chatPanel.showBigButtons(false);
            this.miButtonsOn.setState(false);
            this.miButtonsOff.setState(true);
            return;
        }
        if (e.target instanceof CheckboxMenuItem) {
            arg = ((CheckboxMenuItem)e.target).getLabel();
            try {
                int size = Integer.parseInt(arg);
                this.setFontSize(size);
                this.checkboxSelect(this.fontSizeMenuItems, arg);
                return;
            }
            catch (NumberFormatException ex) {
                String font = arg;
                this.setFont(arg);
                this.checkboxSelect(this.fontStyleMenuItems, arg);
                return;
            }
        }
        this._chatPanel.action(e, arg);
    }

    void checkboxSelect(CheckboxMenuItem[] items, String arg) {
        int i = 0;
        while (i < items.length) {
            if (!items[i].getLabel().equals(arg)) {
                items[i].setState(false);
            } else {
                items[i].setState(true);
            }
            ++i;
        }
    }

    public boolean action(Event e, Object arg) {
        if (e.target instanceof MenuItem) {
            this.handleMenuEvent(e, arg);
            return true;
        }
        return super.action(e, arg);
    }

    public void displayPrivateMessage(String user, String message) {
        this._chatPanel.displayPrivateMessage(user, message);
    }

    public void displayPrivateEmote(String user, String message) {
        this._chatPanel.displayPrivateEmote(user, message);
    }

    public void displayMessage(String user, String message) {
        this._chatPanel.displayMessage(user, message);
    }

    public void displayMessage(String message) {
        this._chatPanel.displayMessage(message);
    }

    public void displayError(String error) {
        this._chatPanel.displayError(error);
    }

    public void setUserList(String[] users) {
        this._chatPanel.setUserList(users);
    }

    public void userJoinedRoom(String user) {
        this._chatPanel.userJoinedRoom(user);
    }

    public void userPartedRoom(String user, boolean signoff) {
        this._chatPanel.userPartedRoom(user, signoff);
    }
}

