/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.awt.HyperlinkReceiver;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IConsole;
import com.lyrisoft.chat.client.gui.IQuery;
import com.lyrisoft.chat.client.gui.IQueryCallback;
import com.lyrisoft.chat.client.gui.awt102.Constraints;
import com.lyrisoft.chat.client.gui.awt102.FixedPanel;
import com.lyrisoft.chat.client.gui.awt102.MessageView;
import com.lyrisoft.chat.server.local.IChatServer;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;

public class Console
extends Panel
implements IConsole,
HyperlinkReceiver,
IQueryCallback {
    protected int roomCnt = 0;
    protected int userCnt = 0;
    protected Color bgColor;
    protected IChatClientInputReceiver _inputReceiver;
    private IChatServer _server;
    private List lstRooms;
    private List lstUsers;
    private IChatGUIFactory _factory;
    private Label lblUserCnt;
    private Label lblRoomCnt;
    private Button btnCreate;
    private Button btnUpdate;
    private Button btnJoin;
    private Button btnExit;
    private MessageView _txtMessages;
    private boolean _keepGoing = true;
    private static final int CREATE = 0;
    private static final int JOIN = 1;
    private static final int QUIT = 2;

    public Console(IChatServer server, IChatClientInputReceiver receiver, IChatGUIFactory f) {
        this._factory = f;
        this._server = server;
        this._inputReceiver = receiver;
        this.bgColor = (Color)f.getAttribute("bgColor");
        if (this.bgColor == null) {
            this.bgColor = new Color(3689671);
        }
        this.setupGUI();
    }

    public void handleHyperlink(String link) {
        this._inputReceiver.inputEvent("console", "/link " + link);
    }

    public void setupGUI() {
        GridBagLayout gridBag = new GridBagLayout();
        this.setLayout(gridBag);
        this.setBackground(this.bgColor);
        int row = 0;
        Label l = this.createLabel(Translator.getMessage("label.console"));
        gridBag.setConstraints(l, Constraints.create(0, row, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(l);
        this.btnUpdate = new Button(Translator.getMessage("label.update"));
        this.btnUpdate.setBackground(this.bgColor);
        this.btnUpdate.setForeground(Color.yellow);
        gridBag.setConstraints(this.btnUpdate, Constraints.create(2, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.btnUpdate);
        this.btnExit = new Button(Translator.getMessage("label.quit"));
        this.btnExit.setBackground(this.bgColor);
        this.btnExit.setForeground(Color.yellow);
        gridBag.setConstraints(this.btnExit, Constraints.create(3, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.btnExit);
        this._txtMessages = new MessageView(this);
        FixedPanel p = new FixedPanel(this._txtMessages, 400, 75);
        gridBag.setConstraints(p, Constraints.create(0, ++row, 4, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(p);
        l = this.createLabel(Translator.getMessage("label.rooms"));
        gridBag.setConstraints(l, Constraints.create(0, ++row, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(l);
        this.lblRoomCnt = this.createLabel("(0)");
        gridBag.setConstraints(this.lblRoomCnt, Constraints.create(1, row, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.lblRoomCnt);
        l = this.createLabel(Translator.getMessage("label.users"));
        gridBag.setConstraints(l, Constraints.create(2, row, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(l);
        this.lblUserCnt = this.createLabel("(0)");
        gridBag.setConstraints(this.lblUserCnt, Constraints.create(3, row, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.lblUserCnt);
        this.lstRooms = new List();
        this.lstRooms.setBackground(Color.lightGray);
        gridBag.setConstraints(this.lstRooms, Constraints.create(0, ++row, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.lstRooms);
        this.lstUsers = new List();
        this.lstUsers.setBackground(Color.lightGray);
        gridBag.setConstraints(this.lstUsers, Constraints.create(2, row, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.lstUsers);
        this.btnJoin = new Button(Translator.getMessage("label.join.room"));
        this.btnJoin.setForeground(Color.yellow);
        this.btnJoin.setBackground(this.bgColor);
        gridBag.setConstraints(this.btnJoin, Constraints.create(0, ++row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.btnJoin);
        this.btnCreate = new Button(Translator.getMessage("label.create.room"));
        this.btnCreate.setForeground(Color.yellow);
        this.btnCreate.setBackground(this.bgColor);
        gridBag.setConstraints(this.btnCreate, Constraints.create(1, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.btnCreate);
    }

    public Label createLabel(String label) {
        Label l = new Label(label);
        l.setBackground(this.bgColor);
        l.setForeground(Color.white);
        l.setFont(new Font("Dialog", 1, 14));
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String user, boolean inform) {
        List list = this.lstUsers;
        synchronized (list) {
            this.lstUsers.addItem(user);
        }
        ++this.userCnt;
        this.lblUserCnt.setText("(" + this.userCnt + ")");
        if (inform) {
            this.displayMessage(Translator.getMessage("signon", user));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRoom(String room, String count, boolean inform) {
        List list = this.lstRooms;
        synchronized (list) {
            String users = null;
            users = count.equals("1") ? Translator.getMessage("users1", "1") : Translator.getMessage("users2", count);
            this.lstRooms.addItem(room + " (" + users + ")");
        }
        ++this.roomCnt;
        this.lblRoomCnt.setText("(" + this.roomCnt + ")");
        if (inform) {
            this.displayMessage(Translator.getMessage("room.created", "\"" + room + "\""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoom(String room, boolean inform) {
        String upperCaseRoom = room.toUpperCase();
        boolean found = false;
        List list = this.lstRooms;
        synchronized (list) {
            int cnt = this.lstRooms.countItems();
            int i = 0;
            while (i < cnt) {
                if (this.lstRooms.getItem(i).toUpperCase().startsWith(upperCaseRoom)) {
                    this.lstRooms.delItem(i);
                    found = true;
                    break;
                }
                ++i;
            }
        }
        if (found) {
            --this.roomCnt;
            this.lblRoomCnt.setText("(" + this.roomCnt + ")");
            if (inform) {
                this.displayMessage(Translator.getMessage("room.destroyed", "\"" + room + "\""));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String user, boolean inform) {
        boolean found = false;
        List list = this.lstUsers;
        synchronized (list) {
            int cnt = this.lstUsers.countItems();
            int i = 0;
            while (i < cnt) {
                if (this.lstUsers.getItem(i).equals(user)) {
                    this.lstUsers.delItem(i);
                    found = true;
                    break;
                }
                ++i;
            }
        }
        if (found) {
            --this.userCnt;
            this.lblUserCnt.setText("(" + this.userCnt + ")");
            if (inform) {
                this.displayMessage(Translator.getMessage("signonff", user));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRooms() {
        List list = this.lstRooms;
        synchronized (list) {
            this.lstRooms.delItems(0, this.lstRooms.countItems() - 1);
            this.roomCnt = 0;
            this.lblRoomCnt.setText("(" + this.roomCnt + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUsers() {
        List list = this.lstUsers;
        synchronized (list) {
            this.lstUsers.delItems(0, this.lstUsers.countItems() - 1);
            this.userCnt = 0;
            this.lblUserCnt.setText("(" + this.userCnt + ")");
        }
    }

    public boolean action(Event e, Object arg) {
        if (e.id == 1001) {
            if (e.target == this.lstRooms) {
                String s = (String)arg;
                int idx = s.lastIndexOf("(");
                if (idx >= 0) {
                    String room = s.substring(0, idx - 1);
                    this._server.joinRoom(room, null);
                }
                return true;
            }
            if (e.target == this.lstUsers) {
                this._inputReceiver.userDoubleClick((String)arg);
                return true;
            }
        }
        return super.action(e, arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getRoomList() {
        List list = this.lstRooms;
        synchronized (list) {
            String[] list2 = new String[this.lstRooms.countItems()];
            int i = 0;
            while (i < list2.length) {
                list2[i] = this.lstRooms.getItem(i);
                ++i;
            }
            String[] stringArray = list2;
            return stringArray;
        }
    }

    public boolean handleEvent(Event e) {
        if (e.id == 1001) {
            IQuery q;
            if (e.target == this.btnCreate) {
                q = this._factory.createQuery(Translator.getMessage("label.creating.room"), null, null, true, Translator.getMessage("label.room.name") + ":");
                q.setCallbackParams(0, this);
                q.show();
            }
            if (e.target == this.btnJoin) {
                q = this._factory.createQuery(Translator.getMessage("label.joining.room"), Translator.getMessage("label.room") + ":", this.getRoomList(), false, null);
                q.setCallbackParams(1, this);
                q.show();
            }
            if (e.target == this.btnUpdate) {
                this._server.requestRoomList();
                this._server.requestUserList();
                return true;
            }
            if (e.target == this.btnExit) {
                q = this._factory.createQuery(Translator.getMessage("confirm.exit"), null, null, false, null);
                q.setCallbackParams(2, this);
                q.show();
                return true;
            }
        }
        return super.handleEvent(e);
    }

    public void displayPrivateMessage(String user, String message) {
        this._factory.playAudioClip("private.au");
        this._txtMessages.displayPrivateMessage(user, message);
    }

    public void displayMessage(String user, String message) {
        this._txtMessages.displayMessage(user, message);
    }

    public void displayMessage(String message) {
        this._txtMessages.displayMessage(message);
    }

    public void displayError(String error) {
        this._txtMessages.displayError(error);
    }

    public void displayPrivateEmote(String user, String message) {
        this._factory.playAudioClip("private.au");
        this._txtMessages.displayPrivateEmote(user, message);
    }

    public void pleaseStop() {
        this._keepGoing = false;
    }

    public void handleQuery(int id, IQuery q) {
        if (q.getCanceled()) {
            q.dispose();
            return;
        }
        switch (id) {
            case 0: {
                this._server.joinRoom(q.getText(), null);
                break;
            }
            case 1: {
                String s = q.getSelection();
                int idx = s.indexOf("(");
                if (idx < 0) break;
                String room = s.substring(0, idx - 1);
                this._server.joinRoom(room, null);
                break;
            }
            case 2: {
                this._server.signOff();
            }
        }
        q.dispose();
    }

    static {
        CREATE = 0;
        JOIN = 1;
        QUIT = 2;
    }
}

