/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.gui.ChatGUI;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IConsole;
import com.lyrisoft.chat.client.gui.IQuery;
import com.lyrisoft.chat.client.gui.awt102.Console;
import com.lyrisoft.chat.server.local.IChatServer;
import java.awt.CheckboxMenuItem;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;

public class ConsoleFrame
extends Frame
implements IConsole {
    protected ChatGUI _mainGUI;
    private Console _console;
    private IChatServer _server;
    private IChatGUIFactory _factory;
    private CheckboxMenuItem miSoundOn = new CheckboxMenuItem(Translator.getMessage("label.on"));
    private CheckboxMenuItem miSoundOff = new CheckboxMenuItem(Translator.getMessage("label.off"));
    private MenuItem miExit = new MenuItem(Translator.getMessage("label.exit"));
    private MenuItem miAbout = new MenuItem(Translator.getMessage("label.about"));

    public ConsoleFrame(IChatServer server, IChatClientInputReceiver receiver, ChatGUI mainGUI, IChatGUIFactory f) {
        this.setTitle(Translator.getMessage("label.console"));
        this._mainGUI = mainGUI;
        this._server = server;
        this._factory = f;
        this._console = new Console(server, receiver, f);
        this.setLayout(new GridLayout(1, 1));
        this.add(this._console);
        this.setMenuBar(this.createMenuBar());
        this.pack();
    }

    public MenuBar createMenuBar() {
        Menu file = new Menu(Translator.getMessage("label.file"));
        file.add(this.miExit);
        Menu options = new Menu(Translator.getMessage("label.options"));
        Menu sounds = new Menu(Translator.getMessage("label.sound"));
        this.miSoundOn = new CheckboxMenuItem(Translator.getMessage("label.on"));
        if (this._factory.getPlaySounds()) {
            this.miSoundOn.setState(true);
        }
        sounds.add(this.miSoundOn);
        if (this.miSoundOff == null && !this._factory.getPlaySounds()) {
            this.miSoundOn.setState(true);
        }
        sounds.add(this.miSoundOff);
        options.add(sounds);
        Menu help = new Menu(Translator.getMessage("label.help"));
        help.add(this.miAbout);
        MenuBar mb = new MenuBar();
        mb.add(file);
        mb.add(options);
        mb.setHelpMenu(help);
        return mb;
    }

    public void addRoom(String room, String count, boolean inform) {
        this._console.addRoom(room, count, inform);
    }

    public void addUser(String user, boolean inform) {
        this._console.addUser(user, inform);
    }

    public void removeUser(String user, boolean inform) {
        this._console.removeUser(user, inform);
    }

    public void removeRoom(String room, boolean inform) {
        this._console.removeRoom(room, inform);
    }

    public void clearRooms() {
        this._console.clearRooms();
    }

    public void clearUsers() {
        this._console.clearUsers();
    }

    public boolean handleEvent(Event e) {
        if (e.target == this && e.id == 201) {
            this._server.signOff();
            this.hide();
            return true;
        }
        if (e.id == 1004) {
            this._mainGUI.setStatusGui(this);
            return true;
        }
        return super.handleEvent(e);
    }

    public void displayPrivateMessage(String user, String message) {
        this._console.displayPrivateMessage(user, message);
    }

    public void displayMessage(String user, String message) {
        this._console.displayMessage(user, message);
    }

    public void displayMessage(String message) {
        this._console.displayMessage(message);
    }

    public void displayError(String error) {
        this._console.displayError(error);
    }

    public void displayPrivateEmote(String user, String message) {
        this._console.displayPrivateEmote(user, message);
    }

    public boolean action(Event e, Object arg) {
        if (e.target == this.miSoundOn) {
            this._factory.playSounds(true);
            this.miSoundOff.setState(false);
            return true;
        }
        if (e.target == this.miSoundOff) {
            this._factory.playSounds(false);
            this.miSoundOn.setState(false);
            return true;
        }
        if (e.target == this.miAbout) {
            this._factory.createAboutDialog();
            return true;
        }
        if (e.target == this.miExit) {
            IQuery q = this._factory.createQuery(Translator.getMessage("confirm.exit"), null, null, false, null);
            q.show();
            if (!q.getCanceled()) {
                this._server.signOff();
            }
            return true;
        }
        return super.action(e, arg);
    }

    public void show() {
        super.show();
    }

    public void hide() {
        super.hide();
        this._console.pleaseStop();
    }
}

