/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.awt.HyperlinkReceiver;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.awt102.ChatPanel;
import com.lyrisoft.chat.client.gui.awt102.MessageView;
import java.awt.Color;
import java.awt.Component;

public class EnhancedChatPanel
extends ChatPanel
implements HyperlinkReceiver {
    protected MessageView _txtMessages;

    public EnhancedChatPanel(IChatGUIFactory factory, String room, String title, IChatClientInputReceiver inputReceiver) {
        super(factory, room, title, inputReceiver);
    }

    public EnhancedChatPanel(IChatGUIFactory factory, String room, IChatClientInputReceiver inputReceiver) {
        this(factory, room, room, inputReceiver);
    }

    public void setFont(String name) {
        this._txtMessages.setFont(name);
        this.displayMessage(Translator.getMessage("newfont"));
    }

    public void setFontSize(int size) {
        this._txtMessages.setFontSize(size);
        this.displayMessage(Translator.getMessage("newfont"));
    }

    public void handleHyperlink(String link) {
        this._inputReceiver.inputEvent(this._room, "/link " + link);
    }

    protected Component createTextWidget() {
        Color errorColor;
        this._txtMessages = new MessageView(this);
        Color userColor = (Color)this._factory.getAttribute("userColor");
        if (userColor != null) {
            this._txtMessages.getUserStyle().setColor(userColor);
        }
        if ((errorColor = (Color)this._factory.getAttribute("errorColor")) != null) {
            this._txtMessages.getErrorStyle().setColor(errorColor);
        }
        return this._txtMessages;
    }

    public void displayPrivateMessage(String user, String message) {
        this._factory.playAudioClip("private.au");
        this._txtMessages.displayPrivateMessage(user, message);
    }

    public void displayMessage(String user, String message) {
        this._txtMessages.displayMessage(user, message);
    }

    public void displayMessage(String message) {
        this._txtMessages.displayMessage(message);
    }

    public void displayError(String error) {
        this._txtMessages.displayError(error);
    }

    public void displayPrivateEmote(String user, String message) {
        this._factory.playAudioClip("private.au");
        this._txtMessages.displayPrivateEmote(user, message);
    }

    public void showBigButtons(boolean b) {
        super.showBigButtons(b);
    }
}

