/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.chat.client.ChatClientApplet;
import com.lyrisoft.chat.client.gui.ChatGUI;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IChatRoom;
import com.lyrisoft.chat.client.gui.IConsole;
import com.lyrisoft.chat.client.gui.ILogin;
import com.lyrisoft.chat.client.gui.IPrivateChatRoom;
import com.lyrisoft.chat.client.gui.IQuery;
import com.lyrisoft.chat.client.gui.awt102.About;
import com.lyrisoft.chat.client.gui.awt102.ChatRoom;
import com.lyrisoft.chat.client.gui.awt102.ConsoleFrame;
import com.lyrisoft.chat.client.gui.awt102.LoginDialog;
import com.lyrisoft.chat.client.gui.awt102.PrivateChatRoom;
import com.lyrisoft.chat.client.gui.awt102.Query;
import com.lyrisoft.chat.server.local.IChatServer;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.util.Hashtable;

public class GUIFactory
implements IChatGUIFactory {
    protected ChatGUI _mainGui;
    protected IChatServer _server;
    protected IChatClientInputReceiver _inputReceiver;
    protected Applet _dummyApplet = new Applet();
    protected boolean _playSounds = true;
    protected Hashtable _attributes = new Hashtable();
    protected ConsoleFrame _console;

    private static String getNFC_HOME() {
        String s = System.getProperty("NFC_HOME");
        if (s == null) {
            System.err.println("Property NFC_HOME not set.  Aborting.");
            System.exit(1);
            return null;
        }
        return s;
    }

    void init() {
        String NFC_HOME = System.getProperty("NFC_HOME");
        if (NFC_HOME == null) {
            System.err.println("Property NFC_HOME not set.  Aborting.");
            System.exit(1);
        }
    }

    public void setMainGui(ChatGUI mainGui) {
        this._mainGui = mainGui;
    }

    public ChatGUI getMainGui() {
        return this._mainGui;
    }

    public void setInputReceiver(IChatClientInputReceiver inputReceiver) {
        this._inputReceiver = inputReceiver;
    }

    public void setChatServer(IChatServer server) {
        this._server = server;
    }

    public IChatRoom createChatRoom(String name) {
        return new ChatRoom(name, this, this._mainGui, this._inputReceiver, this._server);
    }

    public IPrivateChatRoom createPrivateChatRoom(String name) {
        return new PrivateChatRoom(name, this, this._mainGui, this._inputReceiver, this._server);
    }

    public ILogin createLoginDialog() {
        return new LoginDialog(this, this._inputReceiver);
    }

    public IConsole createConsole() {
        if (this._console == null) {
            this._console = new ConsoleFrame(this._server, this._inputReceiver, this._mainGui, this);
        }
        return this._console;
    }

    public IQuery createQuery(String title, String choiceLabel, String[] choices, boolean showTextField, String textFieldLabel) {
        return new Query((Frame)((Object)this._mainGui.getStatusGui()), title, choiceLabel, choices, showTextField, textFieldLabel);
    }

    public Component createAboutDialog() {
        return new About((Frame)((Object)this._mainGui.getStatusGui()), this._inputReceiver);
    }

    public void hide(IChatRoom room) {
        room.hide();
        if (room instanceof ChatRoom) {
            ((ChatRoom)room).dispose();
        }
    }

    public void show(IChatRoom room) {
        room.show();
    }

    public void hide(ILogin login) {
        login.hide();
        if (login instanceof LoginDialog) {
            ((LoginDialog)login).dispose();
        }
    }

    public void show(ILogin login) {
        login.show();
    }

    public void show(IConsole c) {
        c.show();
    }

    public void hide(IConsole c) {
        c.hide();
    }

    public void show(IPrivateChatRoom room) {
        ((PrivateChatRoom)room).show();
    }

    public void hide(IPrivateChatRoom room) {
        if (room instanceof PrivateChatRoom) {
            ((PrivateChatRoom)room).hide();
            ((PrivateChatRoom)room).dispose();
        }
    }

    public void setApplet(ChatClientApplet a) {
    }

    public Image getImage(String name) {
        String file = GUIFactory.getNFC_HOME() + File.separator + "web" + File.separator + "resources" + File.separator + name;
        Image i = Toolkit.getDefaultToolkit().getImage(file);
        try {
            MediaTracker _mediaTracker = new MediaTracker((Frame)((Object)this._mainGui.getStatusGui()));
            _mediaTracker.addImage(i, 0);
            _mediaTracker.waitForAll();
            return i;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void playAudioClip(String name) {
    }

    public void playSounds(boolean b) {
        this._playSounds = b;
    }

    public boolean getPlaySounds() {
        return this._playSounds;
    }

    public void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }
}

