/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.ILogin;
import com.lyrisoft.chat.client.gui.awt102.Constraints;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

public class LoginPanel
extends Panel
implements ILogin {
    TextField txtLogin = new TextField(25);
    TextField txtPassword = new TextField(25);
    GridBagLayout gridBag = new GridBagLayout();
    Label lblLogin = null;
    Label lblPassword = null;
    Label lblStatus = null;
    Button btnLogin = null;
    Button btnCancel = null;
    private IChatClientInputReceiver _inputReceiver;
    boolean showPassword;

    public LoginPanel(IChatGUIFactory factory, IChatClientInputReceiver client) {
        this(factory, client, Translator.getMessage("label.loginwindow"), Translator.getMessage("label.userid"), Translator.getMessage("label.password"), Translator.getMessage("label.login"), Translator.getMessage("label.cancel"), true);
    }

    public LoginPanel(IChatGUIFactory factory, IChatClientInputReceiver client, String label, String loginLabel, String passwordLabel, String loginButtonLabel, String cancelButtonLabel, boolean showPassword) {
        this._inputReceiver = client;
        this.lblStatus = new Label(label);
        this.lblStatus.setForeground(Color.white);
        this.lblLogin = new Label(loginLabel);
        this.lblLogin.setForeground(Color.white);
        this.lblPassword = new Label(passwordLabel);
        this.lblPassword.setForeground(Color.white);
        this.btnLogin = new Button(loginButtonLabel);
        this.btnLogin.setForeground(Color.yellow);
        this.btnCancel = new Button(cancelButtonLabel);
        this.btnCancel.setForeground(Color.yellow);
        this.showPassword = showPassword;
        Color bgColor = (Color)factory.getAttribute("bgColor");
        if (bgColor == null) {
            bgColor = new Color(3689671);
        }
        this.setBackground(bgColor);
        this.txtLogin.setBackground(Color.white);
        this.txtPassword.setBackground(Color.white);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setStatus(String txt) {
        this.lblStatus.setText(txt);
    }

    public boolean action(Event e, Object arg) {
        if (e.id == 1001) {
            if (e.target == this.btnCancel) {
                this._inputReceiver.loginCancelEvent();
                return true;
            }
            if (e.target == this.btnLogin || this.showPassword && e.target == this.txtPassword || !this.showPassword && e.target == this.txtLogin) {
                this._inputReceiver.loginEvent(this.txtLogin.getText(), this.txtPassword.getText());
                return true;
            }
            if (e.target == this.txtLogin) {
                this.txtPassword.requestFocus();
                return true;
            }
        }
        return super.action(e, arg);
    }

    public void requestFocus() {
        this.txtLogin.requestFocus();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBag);
        this.txtPassword.setEchoCharacter('*');
        this.gridBag.setConstraints(this.lblLogin, Constraints.create(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.gridBag.setConstraints(this.txtLogin, Constraints.create(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 5));
        this.gridBag.setConstraints(this.lblPassword, Constraints.create(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.gridBag.setConstraints(this.txtPassword, Constraints.create(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 5));
        this.gridBag.setConstraints(this.btnLogin, Constraints.create(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.gridBag.setConstraints(this.btnCancel, Constraints.create(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.gridBag.setConstraints(this.lblStatus, Constraints.create(0, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.txtLogin);
        this.add(this.lblLogin);
        if (this.showPassword) {
            this.add(this.txtPassword);
            this.add(this.lblPassword);
        }
        this.add(this.btnLogin);
        this.add(this.btnCancel);
        this.add(this.lblStatus);
    }
}

