/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.awt.HyperlinkReceiver;
import com.lyrisoft.awt.HyperlinkTextView;
import com.lyrisoft.awt.ScrollView;
import com.lyrisoft.awt.TextStyle;
import com.lyrisoft.awt.TextView;
import com.lyrisoft.chat.Translator;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;

public class MessageView
extends Panel {
    protected TextView textView;
    protected ScrollView scroller;
    protected TextStyle normalStyle;
    protected TextStyle errorStyle;
    protected TextStyle userStyle;
    protected TextStyle privateStyle;

    public MessageView(HyperlinkReceiver receiver) {
        this.textView = new HyperlinkTextView(true, receiver);
        this.setBackground(Color.white);
        this.setLayout(new GridLayout(1, 1));
        this.scroller = new ScrollView(this.textView);
        this.scroller.resize(100, 300);
        this.setupTextStyles();
        this.add(this.scroller);
    }

    public TextStyle getNormalStyle() {
        return this.normalStyle;
    }

    public void setNormalStyle(TextStyle style) {
        this.normalStyle = style;
    }

    public TextStyle getErrorStyle() {
        return this.errorStyle;
    }

    public void setErrorStyle(TextStyle style) {
        this.errorStyle = style;
    }

    public TextStyle getUserStyle() {
        return this.userStyle;
    }

    public void setUserStyle(TextStyle style) {
        this.userStyle = style;
    }

    public TextStyle getPrivateStyle() {
        return this.privateStyle;
    }

    public void setPrivateStyle(TextStyle style) {
        this.privateStyle = style;
    }

    protected void setupTextStyles() {
        this.normalStyle = this.textView.getDefaultStyle();
        this.errorStyle = new TextStyle(this.normalStyle);
        this.errorStyle.setColor(Color.red);
        this.userStyle = new TextStyle(this.normalStyle);
        this.userStyle.setColor(Color.blue);
        this.privateStyle = new TextStyle(this.normalStyle);
        Font f = this.privateStyle.getFont();
        this.privateStyle.setFont(new Font(f.getName(), 2, f.getSize()));
        this.privateStyle.setColor(Color.red);
    }

    public void setFont(String name) {
        this.textView.setFont(name);
        this.setupTextStyles();
    }

    public void setFontSize(int size) {
        this.textView.setFontSize(size);
        this.setupTextStyles();
    }

    public void displayPrivateMessage(String user, String message) {
        this.textView.append(user, this.userStyle);
        this.textView.append(" " + Translator.getMessage("privately"), this.privateStyle);
        this.textView.append(" " + message, this.normalStyle);
        this.textView.append("\n");
    }

    public void displayMessage(String user, String message) {
        this.textView.append(user, this.userStyle);
        this.textView.append(": " + message, this.normalStyle);
        this.textView.append("\n");
    }

    public void displayMessage(String message) {
        this.textView.append(message, this.normalStyle);
        this.textView.append("\n");
    }

    public void displayError(String error) {
        this.textView.append(Translator.getMessage("error2") + ":", this.errorStyle);
        this.textView.append(" " + error, this.normalStyle);
        this.textView.append("\n");
    }

    public void displayPrivateEmote(String user, String message) {
        this.textView.append(Translator.getMessage("privately"), this.privateStyle);
        this.textView.append(" " + user + " " + message, this.normalStyle);
        this.textView.append("\n");
    }
}

