/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.awt.HyperlinkReceiver;
import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.client.gui.ChatGUI;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IPrivateChatRoom;
import com.lyrisoft.chat.client.gui.awt102.Constraints;
import com.lyrisoft.chat.client.gui.awt102.MessageView;
import com.lyrisoft.chat.server.local.IChatServer;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.TextField;

public class PrivateChatPanel
extends Panel
implements IPrivateChatRoom,
HyperlinkReceiver,
ICommands {
    private MessageView _msgView;
    private GridBagLayout _gridBag;
    private String _name;
    private IChatGUIFactory _guiFactory;
    private ChatGUI _chatGui;
    private IChatClientInputReceiver _inputReceiver;
    private IChatServer _server;
    private TextField _inputField = new TextField();

    public PrivateChatPanel(String name, IChatGUIFactory factory, ChatGUI mainGui, IChatClientInputReceiver inputReceiver, IChatServer server) {
        this._name = name;
        this._guiFactory = factory;
        this._chatGui = mainGui;
        this._inputReceiver = inputReceiver;
        this._server = server;
        this.initGUI();
    }

    public void handleHyperlink(String link) {
        this._inputReceiver.inputEvent(this._name, "/link " + link);
    }

    public void requestFocus() {
        this._inputField.requestFocus();
    }

    public void initGUI() {
        Color errorColor;
        this._gridBag = new GridBagLayout();
        this.setLayout(this._gridBag);
        this._msgView = new MessageView(this);
        Color userColor = (Color)this._guiFactory.getAttribute("userColor");
        if (userColor != null) {
            this._msgView.getUserStyle().setColor(userColor);
        }
        if ((errorColor = (Color)this._guiFactory.getAttribute("errorColor")) != null) {
            this._msgView.getErrorStyle().setColor(errorColor);
        }
        this._inputField = new TextField();
        this._gridBag.setConstraints(this._msgView, Constraints.create(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._gridBag.setConstraints(this._inputField, Constraints.create(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 4));
        this.add(this._msgView);
        this.add(this._inputField);
    }

    public boolean action(Event e, Object o) {
        if (e.id == 1001 && e.target == this._inputField) {
            String text = (String)o;
            if (text.length() > 0) {
                if (text.charAt(0) == '/') {
                    this._inputReceiver.inputEvent("PRIVATE__" + this._name, text);
                } else {
                    this._inputReceiver.inputEvent(null, "/msg " + this._name + " " + o);
                }
            }
            this._inputField.setText("");
            return true;
        }
        return super.action(e, o);
    }

    public void displayPrivateMessage(String user, String message) {
        this._msgView.displayMessage(user, message);
    }

    public void displayPrivateEmote(String user, String message) {
        this._msgView.displayMessage(user + " " + message);
    }
}

