/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.awt102;

import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.gui.IQuery;
import com.lyrisoft.chat.client.gui.IQueryCallback;
import com.lyrisoft.chat.client.gui.awt102.Constraints;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;

public class Query
extends Frame
implements IQuery {
    private Choice choice;
    private TextField textField;
    private Button btnOk;
    private Button btnCancel;
    private boolean canceled = false;
    private IQueryCallback _callback;
    private int _callbackId;
    private Frame _parent;

    public Query(Frame owner, String title, String choiceLabel, String[] choices, boolean showTextField, String textFieldLabel) {
        super(title);
        this._parent = owner;
        int y = 0;
        GridBagLayout gridBag = new GridBagLayout();
        this.setLayout(gridBag);
        Label label = new Label(title);
        gridBag.setConstraints(label, Constraints.create(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(label);
        if (choiceLabel != null && choices != null) {
            this.choice = new Choice();
            int i = 0;
            while (i < choices.length) {
                this.choice.addItem(choices[i]);
                ++i;
            }
            label = new Label(choiceLabel);
            gridBag.setConstraints(label, Constraints.create(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(label);
            gridBag.setConstraints(this.choice, Constraints.create(1, y++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.choice);
        }
        if (showTextField) {
            this.textField = new TextField(40);
            if (textFieldLabel != null) {
                label = new Label(textFieldLabel);
                gridBag.setConstraints(label, Constraints.create(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                gridBag.setConstraints(this.textField, Constraints.create(1, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 4));
                this.add(label);
            } else {
                gridBag.setConstraints(this.textField, Constraints.create(0, y++, 2, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 4));
            }
            this.add(this.textField);
        }
        Panel p = new Panel();
        p.setLayout(new FlowLayout());
        this.btnOk = new Button(Translator.getMessage("label.ok"));
        this.btnCancel = new Button(Translator.getMessage("label.cancel"));
        p.add(this.btnOk);
        p.add(this.btnCancel);
        gridBag.setConstraints(p, Constraints.create(0, y++, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(p);
        this.pack();
    }

    public void setCallbackParams(int id, IQueryCallback cb) {
        this._callback = cb;
        this._callbackId = id;
    }

    public void setDefaultSelection(String s) {
        this.choice.select(s);
    }

    public String getSelection() {
        if (this.choice != null) {
            return this.choice.getSelectedItem();
        }
        return null;
    }

    public String getText() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return null;
    }

    public boolean getCanceled() {
        return this.canceled;
    }

    public boolean action(Event e, Object arg) {
        if (e.target == this.btnCancel) {
            this.canceled = true;
            this.hide();
            return true;
        }
        if (e.id == 1001) {
            if (e.target == this.textField || e.target == this.btnOk) {
                this.hide();
                if (this._callback != null) {
                    this._callback.handleQuery(this._callbackId, this);
                }
                return true;
            }
            new Throwable().printStackTrace();
        }
        return super.action(e, arg);
    }

    public boolean handleEvent(Event e) {
        if (e.target == this && e.id == 201) {
            this.canceled = true;
            this.hide();
            return true;
        }
        return super.handleEvent(e);
    }

    public void center() {
        Rectangle pr = this._parent.bounds();
        Rectangle r = this.bounds();
        this.move(Math.max(0, (pr.width - r.width) / 2 + pr.x), Math.max(0, (pr.height - r.height) / 2 + pr.y));
    }
}

