/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.jfc;

import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IChatRoom;
import com.lyrisoft.chat.client.gui.jfc.SimpleTextPanel;
import com.lyrisoft.chat.client.gui.jfc.SwingGuiFactory;
import com.lyrisoft.chat.server.local.IChatServer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class ChatPanel
extends JPanel
implements IChatRoom {
    private SimpleTextPanel _text;
    private String _name;
    private JList _list;
    private DefaultListModel _userModel;
    private Component _container;
    private IChatGUIFactory _guiFactory;
    private IChatClientInputReceiver _receiver;
    private IChatServer _server;
    private JSplitPane _splitPane;

    public ChatPanel(IChatGUIFactory factory, String room, IChatClientInputReceiver inputReceiver, IChatServer server) {
        this._guiFactory = factory;
        this._receiver = inputReceiver;
        this._name = room;
        this._server = server;
        this._splitPane = new JSplitPane(1, true);
        this._splitPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                ChatPanel.this._splitPane.setDividerLocation(0.8);
            }

            public void componentShown(ComponentEvent e) {
                ChatPanel.this._splitPane.setDividerLocation(0.8);
            }
        });
        this._text = new SimpleTextPanel();
        this._splitPane.add(this._text);
        this._splitPane.add(this.createUserList());
        this.setLayout(new BorderLayout());
        this.add((Component)this._splitPane, "Center");
        this.add(this.createInputField(), "South");
    }

    public void doLayout() {
        super.doLayout();
        this._splitPane.setDividerLocation(0.8);
    }

    Component createUserList() {
        this._userModel = new DefaultListModel();
        this._list = new JList(this._userModel);
        this._list.setSelectionMode(0);
        this._list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 8) == 8 || (e.getModifiers() & 4) == 4) {
                    Point p = new Point(e.getX(), e.getY());
                    int idx = ChatPanel.this._list.locationToIndex(p);
                    if (idx >= 0) {
                        String user = (String)ChatPanel.this._userModel.getElementAt(idx);
                        JPopupMenu menu = ((SwingGuiFactory)ChatPanel.this._guiFactory).createUserPopupMenu(user);
                        menu.show(ChatPanel.this._list, e.getX(), e.getY());
                    }
                } else if (e.getClickCount() == 2) {
                    Point p = new Point(e.getX(), e.getY());
                    int idx = ChatPanel.this._list.locationToIndex(p);
                    if (idx >= 0) {
                        String user = (String)ChatPanel.this._list.getSelectedValue();
                        ChatPanel.this._guiFactory.getMainGui().getPrivateRoom(user);
                    }
                }
            }
        });
        return new JScrollPane(this._list);
    }

    Component createInputField() {
        final JTextField tf = new JTextField();
        SwingGuiFactory.tweakTextFieldSize(tf);
        tf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatPanel.this._receiver.inputEvent(ChatPanel.this._name, tf.getText());
                tf.setText("");
            }
        });
        return tf;
    }

    public Component getContainer() {
        return this._container;
    }

    public void setContainer(Component c) {
        this._container = c;
    }

    public void displayPrivateMessage(String user, String message) {
        this._text.displayPrivateMessage(user, message);
    }

    public void displayPrivateEmote(String user, String message) {
        this._text.displayPrivateEmote(user, message);
    }

    public void displayMessage(String user, String message) {
        this._text.displayMessage(user, message);
    }

    public void displayMessage(String message) {
        this._text.displayMessage(message);
    }

    public void displayError(String error) {
        this._text.displayError(error);
    }

    public void setUserList(String[] users) {
        this._list.setListData(users);
    }

    public void userJoinedRoom(String user) {
        this._userModel.addElement(user);
        this.displayMessage(user + " joined the room");
    }

    public void userPartedRoom(String user, boolean signoff) {
        this._userModel.removeElement(user);
        this.displayMessage(user + " left the room" + (signoff ? " (signoff)" : "."));
    }

    public String getName() {
        return this._name;
    }

    public static void main(String[] args) {
        ChatPanel p = new ChatPanel(null, "test", null, null);
        JFrame f = new JFrame("test");
        f.getContentPane().add(p);
        f.setSize(500, 300);
        f.setVisible(true);
    }
}

