/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.jfc;

import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IConsole;
import com.lyrisoft.chat.client.gui.jfc.SimpleTextPanel;
import com.lyrisoft.chat.client.gui.jfc.SwingGuiFactory;
import com.lyrisoft.chat.server.local.IChatServer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class Console
extends JPanel
implements IConsole {
    private IChatServer _server;
    private IChatClientInputReceiver _receiver;
    private IChatGUIFactory _guiFactory;
    private SimpleTextPanel _text;
    private DefaultListModel _roomModel;
    private DefaultListModel _userModel;
    private Component _container;

    public Console(IChatServer server, IChatClientInputReceiver receiver, IChatGUIFactory f) {
        this._server = server;
        this._receiver = receiver;
        this._guiFactory = f;
        this._text = new SimpleTextPanel();
        this._text.setMinimumSize(new Dimension(1, 50));
        JSplitPane p = new JSplitPane(0, true);
        p.add(this._text);
        p.add(this.createRoomAndUserPanel());
        p.setDividerLocation(0.5);
        this.setLayout(new GridLayout());
        this.add(p);
    }

    public Component getContainer() {
        return this._container;
    }

    public void setContainer(Component c) {
        this._container = c;
    }

    Component createRoomAndUserPanel() {
        JSplitPane p = new JSplitPane(1, true);
        p.add(this.createRoomPanel());
        p.add(this.createUserPanel());
        p.setDividerLocation(0.5);
        return p;
    }

    Component createRoomPanel() {
        Box b = new Box(1);
        JLabel label = new JLabel("Rooms");
        this._roomModel = new DefaultListModel();
        final JList rooms = new JList(this._roomModel);
        rooms.setSelectionMode(0);
        rooms.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Point p;
                int idx;
                if ((e.getModifiers() & 8) == 8 || (e.getModifiers() & 4) == 4) {
                    Point p2 = new Point(e.getX(), e.getY());
                    int idx2 = rooms.locationToIndex(p2);
                    if (idx2 >= 0) {
                        String room = (String)Console.this._roomModel.getElementAt(idx2);
                        JPopupMenu menu = ((SwingGuiFactory)Console.this._guiFactory).createRoomPopupMenu(room);
                        menu.show(rooms, e.getX(), e.getY());
                    }
                } else if (e.getClickCount() == 2 && (idx = rooms.locationToIndex(p = new Point(e.getX(), e.getY()))) >= 0) {
                    String room = (String)rooms.getSelectedValue();
                    Console.this._server.joinRoom(room, null);
                }
            }
        });
        JButton button = new JButton("update");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this._server.requestRoomList();
            }
        });
        b.add(label);
        b.add(new JScrollPane(rooms));
        b.add(button);
        return b;
    }

    Component createUserPanel() {
        Box b = new Box(1);
        JLabel label = new JLabel("Users");
        this._userModel = new DefaultListModel();
        final JList users = new JList(this._userModel);
        users.setSelectionMode(0);
        users.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Point p;
                int idx;
                if ((e.getModifiers() & 8) == 8 || (e.getModifiers() & 4) == 4) {
                    Point p2 = new Point(e.getX(), e.getY());
                    int idx2 = users.locationToIndex(p2);
                    if (idx2 >= 0) {
                        String user = (String)Console.this._userModel.getElementAt(idx2);
                        JPopupMenu menu = ((SwingGuiFactory)Console.this._guiFactory).createUserPopupMenu(user);
                        menu.show(users, e.getX(), e.getY());
                    }
                } else if (e.getClickCount() == 2 && (idx = users.locationToIndex(p = new Point(e.getX(), e.getY()))) >= 0) {
                    String user = (String)users.getSelectedValue();
                    Console.this._guiFactory.getMainGui().getPrivateRoom(user);
                }
            }
        });
        JButton button = new JButton("update");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Console.this._server.requestUserList();
            }
        });
        b.add(label);
        b.add(new JScrollPane(users));
        b.add(button);
        return b;
    }

    public void displayPrivateMessage(String user, String message) {
        this._text.displayPrivateMessage(user, message);
    }

    public void displayPrivateEmote(String user, String message) {
        this._text.displayPrivateEmote(user, message);
    }

    public void displayMessage(String user, String message) {
        this._text.displayMessage(user, message);
    }

    public void displayMessage(String message) {
        this._text.displayMessage(message);
    }

    public void displayError(String error) {
        this._text.displayError(error);
    }

    public void addRoom(String room, String userCount, boolean inform) {
        this._roomModel.addElement(room);
    }

    public void addUser(String user, boolean inform) {
        this._userModel.addElement(user);
    }

    public void removeRoom(String room, boolean inform) {
        this._roomModel.removeElement(room);
    }

    public void removeUser(String user, boolean inform) {
        this._userModel.removeElement(user);
    }

    public void clearRooms() {
        this._roomModel.removeAllElements();
    }

    public void clearUsers() {
        this._userModel.removeAllElements();
    }

    public static void main(String[] args) {
        Console c = new Console(null, null, null);
        JFrame frame = new JFrame("test");
        frame.getContentPane().add(c);
        frame.setSize(400, 300);
        frame.setVisible(true);
    }
}

