/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.jfc;

import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.ILogin;
import com.lyrisoft.chat.client.gui.jfc.SwingGuiFactory;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginPanel
extends JPanel
implements ILogin {
    private IChatClientInputReceiver _receiver;
    private JTextField _textField;
    private JPasswordField _passField;
    private JLabel _status;
    private Component _container;

    public LoginPanel(IChatClientInputReceiver receiver) {
        this._receiver = receiver;
        Box b = new Box(1);
        b.add(this.createInputAreas());
        b.add(Box.createVerticalStrut(5));
        b.add(this.createButtonArea());
        b.add(Box.createVerticalStrut(5));
        b.add(this.createStatusArea());
        this.setLayout(new GridLayout(1, 1));
        this.add(b);
    }

    public Component getContainer() {
        return this._container;
    }

    public void setContainer(Component c) {
        this._container = c;
    }

    Component createInputAreas() {
        Box b = new Box(0);
        b.add(this.createLabels());
        b.add(this.createInputFields());
        return b;
    }

    Component createButtonArea() {
        Box b = new Box(0);
        JButton loginButton = new JButton("Login");
        loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.doLogin();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPanel.this._receiver.loginCancelEvent();
            }
        });
        b.add(loginButton);
        b.add(cancelButton);
        return b;
    }

    Component createLabels() {
        Box b = new Box(1);
        b.add(new JLabel("name"));
        b.add(new JLabel("password"));
        return b;
    }

    Component createInputFields() {
        Box b = new Box(1);
        this._textField = new JTextField();
        this._textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPanel.this._passField.requestFocus();
            }
        });
        this._passField = new JPasswordField();
        this._passField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginPanel.this.doLogin();
            }
        });
        SwingGuiFactory.tweakTextFieldSize(this._textField);
        SwingGuiFactory.tweakTextFieldSize(this._passField);
        b.add(this._textField);
        b.add(this._passField);
        return b;
    }

    Component createStatusArea() {
        Box b = new Box(0);
        this._status = new JLabel("Enter your credentials and click login", 2);
        b.add(this._status);
        b.add(Box.createHorizontalGlue());
        return b;
    }

    void doLogin() {
        String name = this._textField.getText();
        String pass = this._passField.getText();
        this._textField.setText("");
        this._passField.setText("");
        this._receiver.loginEvent(name, pass);
    }

    public void setStatus(String txt) {
        this._status.setText(txt);
    }
}

