/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.jfc;

import com.lyrisoft.chat.client.gui.ChatGUI;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IPrivateChatRoom;
import com.lyrisoft.chat.client.gui.jfc.SimpleTextPanel;
import com.lyrisoft.chat.client.gui.jfc.SwingGuiFactory;
import com.lyrisoft.chat.server.local.IChatServer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JTextField;

public class PrivateChatPanel
extends Box
implements IPrivateChatRoom {
    private SimpleTextPanel _text;
    private JTextField _inputField;
    private Component _container;
    private IChatServer _server;
    private IChatClientInputReceiver _receiver;
    private IChatGUIFactory _guiFactory;
    private String _name;

    public PrivateChatPanel(String name, IChatGUIFactory factory, ChatGUI mainGui, IChatClientInputReceiver inputReceiver, IChatServer server) {
        super(1);
        this._name = "PRIVATE__" + name;
        this._server = server;
        this._receiver = inputReceiver;
        this._guiFactory = factory;
        this._text = new SimpleTextPanel();
        this._inputField = new JTextField();
        SwingGuiFactory.tweakTextFieldSize(this._inputField);
        this._inputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrivateChatPanel.this._receiver.inputEvent(PrivateChatPanel.this._name, PrivateChatPanel.this._inputField.getText());
                PrivateChatPanel.this._inputField.setText("");
            }
        });
        this.add(this._text);
        this.add(this._inputField);
    }

    public String getName() {
        return this._name;
    }

    public Component getContainer() {
        return this._container;
    }

    public void setContainer(Component c) {
        this._container = c;
    }

    public void displayPrivateMessage(String user, String message) {
        this._text.displayPrivateMessage(user, message);
    }

    public void displayPrivateEmote(String user, String message) {
        this._text.displayPrivateEmote(user, message);
    }
}

