/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.jfc;

import com.lyrisoft.chat.client.gui.IMessageWindow;
import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SimpleTextPanel
extends JPanel
implements IMessageWindow {
    private JTextPane _textArea = new JTextPane();
    private Position _endPosition;
    private SimpleAttributeSet _userAttributes;
    private SimpleAttributeSet _normalAttributes;
    private SimpleAttributeSet _privateAttributes;
    private SimpleAttributeSet _privateTextAttributes;
    private SimpleAttributeSet _errorAttributes;

    public SimpleTextPanel() {
        this._textArea.setEditable(false);
        this.setLayout(new GridLayout());
        JScrollPane scroller = new JScrollPane(this._textArea, 20, 31);
        this.add(scroller);
        StyledDocument doc = this._textArea.getStyledDocument();
        this._endPosition = doc.getEndPosition();
        AttributeSet baseAttributes = doc.getDefaultRootElement().getAttributes();
        this._normalAttributes = new SimpleAttributeSet(baseAttributes);
        this._normalAttributes.addAttribute(StyleConstants.Foreground, Color.black);
        this._normalAttributes.addAttribute(StyleConstants.FontFamily, "SansSerif");
        this._userAttributes = new SimpleAttributeSet(this._normalAttributes);
        this._userAttributes.addAttribute(StyleConstants.Foreground, Color.blue);
        this._errorAttributes = new SimpleAttributeSet(this._normalAttributes);
        this._errorAttributes.addAttribute(StyleConstants.Foreground, Color.red);
        this._errorAttributes.addAttribute(StyleConstants.Bold, new Boolean(true));
        this._privateAttributes = new SimpleAttributeSet(this._normalAttributes);
        this._privateAttributes.addAttribute(StyleConstants.Foreground, Color.red);
        this._privateTextAttributes = new SimpleAttributeSet(this._normalAttributes);
        this._privateTextAttributes.addAttribute(StyleConstants.Foreground, Color.black);
        this._privateTextAttributes.addAttribute(StyleConstants.Italic, new Boolean(true));
    }

    public void displayPrivateMessage(String user, String message) {
        this.append(user, this._userAttributes);
        this.append(" (privately)", this._privateAttributes);
        this.append(": " + message + "\n", this._privateTextAttributes);
    }

    public void displayPrivateEmote(String user, String message) {
        this.append("(privately) ", this._privateAttributes);
        this.append(user, this._userAttributes);
        this.append(" " + message + "\n", this._privateTextAttributes);
    }

    public void displayMessage(String user, String message) {
        this.append(user, this._userAttributes);
        this.append(": " + message + "\n", this._normalAttributes);
    }

    public void displayMessage(String message) {
        this.append(message + "\n", this._normalAttributes);
    }

    public void displayError(String error) {
        this.append(error + "\n", this._errorAttributes);
    }

    void append(String text, AttributeSet attributes) {
        Document doc = this._textArea.getDocument();
        try {
            doc.insertString(this._endPosition.getOffset() - 1, text, attributes);
            this._textArea.setCaretPosition(this._endPosition.getOffset() - 1);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

