/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.client.gui.jfc;

import com.lyrisoft.chat.client.ChatClientApplet;
import com.lyrisoft.chat.client.gui.ChatGUI;
import com.lyrisoft.chat.client.gui.IChatClientInputReceiver;
import com.lyrisoft.chat.client.gui.IChatGUIFactory;
import com.lyrisoft.chat.client.gui.IChatRoom;
import com.lyrisoft.chat.client.gui.IConsole;
import com.lyrisoft.chat.client.gui.ILogin;
import com.lyrisoft.chat.client.gui.IPrivateChatRoom;
import com.lyrisoft.chat.client.gui.IQuery;
import com.lyrisoft.chat.client.gui.jfc.ChatPanel;
import com.lyrisoft.chat.client.gui.jfc.Console;
import com.lyrisoft.chat.client.gui.jfc.LoginPanel;
import com.lyrisoft.chat.client.gui.jfc.PrivateChatPanel;
import com.lyrisoft.chat.server.local.IChatServer;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class SwingGuiFactory
implements IChatGUIFactory {
    private ChatGUI _mainGui;
    private IChatClientInputReceiver _inputReceiver;
    private IChatServer _server;
    private Hashtable _attributes;
    private boolean _playSounds = true;
    private Applet _applet;
    private URL _docBase;
    private JFrame _outterFrame;
    private Hashtable _clips = new Hashtable();

    public SwingGuiFactory() {
        this._attributes = new Hashtable();
        this._outterFrame = this.createOutterFrame("NFC Chat");
        this._outterFrame.setSize(640, 480);
        this._outterFrame.show();
        this._outterFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (SwingGuiFactory.this._server != null && SwingGuiFactory.this._server.isConnected()) {
                    SwingGuiFactory.this._server.signOff();
                }
                if (SwingGuiFactory.this._applet == null) {
                    System.exit(0);
                }
            }
        });
    }

    private static String getNFC_HOME() {
        String s = System.getProperty("NFC_HOME");
        if (s == null) {
            System.err.println("Property NFC_HOME not set.  Aborting.");
            System.exit(1);
            return null;
        }
        return s;
    }

    public Component createAboutDialog() {
        return null;
    }

    public void setMainGui(ChatGUI mainGui) {
        this._mainGui = mainGui;
    }

    public ChatGUI getMainGui() {
        return this._mainGui;
    }

    public void setInputReceiver(IChatClientInputReceiver inputReceiver) {
        this._inputReceiver = inputReceiver;
    }

    public void setChatServer(IChatServer server) {
        this._server = server;
    }

    public ILogin createLoginDialog() {
        LoginPanel lp = new LoginPanel(this._inputReceiver);
        JInternalFrame frame = new JInternalFrame("NFC Login");
        this.moveWindow(frame);
        frame.setContentPane(lp);
        lp.setContainer(frame);
        frame.pack();
        this._outterFrame.getLayeredPane().add(frame);
        return lp;
    }

    public void show(ILogin login) {
        ((LoginPanel)login).getContainer().setVisible(true);
    }

    public void hide(ILogin login) {
        System.err.println("hide login..");
        ((LoginPanel)login).getContainer().setVisible(false);
    }

    public IConsole createConsole() {
        final Console console = new Console(this._server, this._inputReceiver, this);
        JInternalFrame frame = new JInternalFrame("Chat Console", true, false, true, true);
        this.moveWindow(frame);
        frame.setContentPane(console);
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameActivated(InternalFrameEvent e) {
                SwingGuiFactory.this._mainGui.setStatusGui(console);
            }
        });
        console.setContainer(frame);
        frame.pack();
        this._outterFrame.getLayeredPane().add(frame);
        return console;
    }

    public void show(IConsole console) {
        ((Console)console).getContainer().setVisible(true);
    }

    public void hide(IConsole console) {
        ((Console)console).getContainer().setVisible(false);
    }

    public IChatRoom createChatRoom(final String name) {
        final ChatPanel panel = new ChatPanel(this, name, this._inputReceiver, this._server);
        JInternalFrame frame = new JInternalFrame(name, true, true, true, true);
        this.moveWindow(frame);
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                SwingGuiFactory.this._server.partRoom(name);
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                SwingGuiFactory.this._mainGui.setStatusGui(panel);
            }
        });
        frame.setContentPane(panel);
        panel.setContainer(frame);
        frame.setSize(400, 300);
        this._outterFrame.getLayeredPane().add(frame);
        return panel;
    }

    public void show(IChatRoom room) {
        ((ChatPanel)room).getContainer().setVisible(true);
    }

    public void hide(IChatRoom room) {
        ((ChatPanel)room).getContainer().setVisible(false);
    }

    public IPrivateChatRoom createPrivateChatRoom(String name) {
        final PrivateChatPanel panel = new PrivateChatPanel(name, this, this._mainGui, this._inputReceiver, this._server);
        JInternalFrame frame = new JInternalFrame("Private chat with " + name, true, true, true, true);
        this.moveWindow(frame);
        frame.setContentPane(panel);
        panel.setContainer(frame);
        frame.setSize(300, 200);
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                SwingGuiFactory.this._mainGui.closePrivateChatRoom(panel.getName());
            }
        });
        this._outterFrame.getLayeredPane().add(frame);
        return panel;
    }

    public void show(IPrivateChatRoom room) {
        ((PrivateChatPanel)room).getContainer().setVisible(true);
    }

    public void hide(IPrivateChatRoom room) {
        ((PrivateChatPanel)room).getContainer().setVisible(false);
    }

    public IQuery createQuery(String title, String choiceLabel, String[] choices, boolean showTextField, String textFieldLabel) {
        return null;
    }

    public void setApplet(ChatClientApplet a) {
        this._applet = a;
        try {
            this._docBase = new URL(a.getCodeBase(), "resources/");
        }
        catch (MalformedURLException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties getProperties(String name) {
        if (this._docBase == null) {
            String file = SwingGuiFactory.getNFC_HOME() + File.separator + "web" + File.separator + "resources" + File.separator + name;
            FileInputStream fis = null;
            fis = new FileInputStream(file);
            Properties p = new Properties();
            p.load(fis);
            Properties properties = p;
            Object var7_12 = null;
            if (fis == null) return properties;
            try {
                fis.close();
                return properties;
            }
            catch (Exception e2) {
                // empty catch block
            }
            return properties;
            catch (Exception e) {
                e.printStackTrace();
                Object var7_13 = null;
                if (fis == null) return null;
                {
                    catch (Throwable throwable) {
                        Object var7_14 = null;
                        if (fis == null) throw throwable;
                        try {
                            fis.close();
                            throw throwable;
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    fis.close();
                    return null;
                }
                catch (Exception e2) {}
                return null;
            }
        }
        InputStream is = null;
        URL propsUrl = new URL(this._docBase, name);
        is = propsUrl.openStream();
        Properties p = new Properties();
        p.load(is);
        Properties properties = p;
        Object var10_19 = null;
        if (is == null) return properties;
        try {
            is.close();
            return properties;
        }
        catch (Exception e3) {
            // empty catch block
        }
        return properties;
        catch (Exception e) {
            Object var10_20 = null;
            if (is == null) return null;
            {
                catch (Throwable throwable) {
                    Object var10_21 = null;
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            try {
                is.close();
                return null;
            }
            catch (Exception e3) {}
            return null;
        }
    }

    public Image getImage(String name) {
        return null;
    }

    public void playAudioClip(String name) {
        if (!this._playSounds) {
            return;
        }
        AudioClip clip = (AudioClip)this._clips.get(name);
        if (clip != null) {
            clip.play();
            return;
        }
        try {
            if (this._docBase == null) {
                if (this._applet == null) {
                    String nfcHome = System.getProperty("NFC_HOME");
                    if (nfcHome == null) {
                        System.err.println("Warning:  NFC_HOME is not set and Applet is not set. Cannot play audio.");
                        return;
                    }
                    File f = new File(nfcHome);
                    String sUrl = "file:///" + f.getAbsolutePath() + File.separator + "web" + File.separator + "resources" + File.separator;
                    this._docBase = new URL(sUrl);
                } else {
                    this._docBase = new URL(this._applet.getDocumentBase(), "resources/");
                }
            }
            URL url = new URL(this._docBase, name);
            clip = Applet.newAudioClip(url);
            this._clips.put(name, clip);
            clip.play();
        }
        catch (MalformedURLException e) {
            System.err.println("Malformed URL");
            e.printStackTrace();
        }
    }

    public void playSounds(boolean b) {
        this._playSounds = b;
    }

    public boolean getPlaySounds() {
        return this._playSounds;
    }

    public void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    JFrame createOutterFrame(String title) {
        JFrame f = new JFrame(title);
        JDesktopPane desktop = new JDesktopPane();
        f.setLayeredPane(desktop);
        f.setJMenuBar(this.createMenuBar());
        return f;
    }

    public static void tweakTextFieldSize(JTextField tf) {
        Dimension m = tf.getMaximumSize();
        Dimension p = tf.getPreferredSize();
        tf.setMaximumSize(new Dimension(m.width, p.height));
        tf.setMinimumSize(new Dimension(400, p.height));
        tf.setPreferredSize(new Dimension(400, p.height));
    }

    JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem item = new JMenuItem("Exit");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SwingGuiFactory.this._applet == null) {
                    System.exit(0);
                } else {
                    SwingGuiFactory.this._server.signOff();
                    SwingGuiFactory.this._outterFrame.hide();
                }
            }
        });
        menu.add(item);
        item = new JMenuItem("New room");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String roomName = JOptionPane.showInputDialog("Please enter the name of a room to join");
                if (roomName == null) {
                    return;
                }
                if (SwingGuiFactory.this._server != null && SwingGuiFactory.this._server.isConnected()) {
                    SwingGuiFactory.this._server.joinRoom(roomName, null);
                }
            }
        });
        menu.add(item);
        menuBar.add(menu);
        return menuBar;
    }

    void moveWindow(Component c) {
        c.move(0, this._outterFrame.getJMenuBar().getHeight());
    }

    JPopupMenu createUserPopupMenu(final String user) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("/ping " + user);
        menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingGuiFactory.this._server.sendPing(user, String.valueOf(System.currentTimeMillis()));
            }
        });
        item = new JMenuItem("/whois " + user);
        menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingGuiFactory.this._server.requestUserInfo(user);
            }
        });
        return menu;
    }

    JPopupMenu createRoomPopupMenu(final String room) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("/join " + room);
        menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingGuiFactory.this._server.joinRoom(room, null);
            }
        });
        return menu;
    }
}

