/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.local;

import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.IConnectionHandler;
import com.lyrisoft.chat.IConnectionListener;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.client.IChatClient;
import com.lyrisoft.chat.client.ICommandProcessorFactory;
import com.lyrisoft.chat.server.local.CommandMakerLocal;
import com.lyrisoft.chat.server.local.CommandProcessorLocal;
import com.lyrisoft.chat.server.local.ConnectionHandlerLocal;
import com.lyrisoft.chat.server.local.HttpConnectionHandler;
import com.lyrisoft.chat.server.local.IChatServer;
import com.lyrisoft.chat.server.local.SocketOpener;
import java.io.IOException;
import java.net.Socket;

public class ChatServerLocal
implements IChatServer,
IConnectionListener,
ICommands {
    protected String _host;
    protected int _port;
    protected boolean _connected = false;
    protected IConnectionHandler _connectionHandler;
    protected IChatClient _responseInterface;
    protected SocketOpener _socketOpener;
    protected boolean _alwaysTunnel = false;
    protected boolean _attemptToTunnel = true;
    protected String _readUrl;
    protected String _writeUrl;
    protected CommandProcessorLocal _commandProcessor;

    public ChatServerLocal(String readUrl, String writeUrl, IChatClient responseInterface) {
        this._readUrl = readUrl;
        this._writeUrl = writeUrl;
        this._responseInterface = responseInterface;
        this._attemptToTunnel = true;
        this._alwaysTunnel = true;
    }

    public ChatServerLocal(String host, int port, IChatClient responseInterface) {
        this._host = host;
        this._port = port;
        this._responseInterface = responseInterface;
        this._socketOpener = new SocketOpener(host, port);
        this._attemptToTunnel = false;
    }

    public ChatServerLocal(String host, int port, String readUrl, String writeUrl, IChatClient responseInterface) {
        this._readUrl = readUrl;
        this._writeUrl = writeUrl;
        this._host = host;
        this._port = port;
        this._responseInterface = responseInterface;
        this._socketOpener = new SocketOpener(host, port);
        this._attemptToTunnel = true;
    }

    public boolean isConnected() {
        return this._connected;
    }

    public void init() {
        this._commandProcessor = (CommandProcessorLocal)this._responseInterface.getAttribute("commandProcessor");
        if (this._commandProcessor == null) {
            try {
                ICommandProcessorFactory factory = (ICommandProcessorFactory)Class.forName("com.lyrisoft.chat.client.DefaultCommandProcessorFactory").newInstance();
                this._commandProcessor = factory.createCommandProcessor();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create default CommandProcessor");
            }
        }
    }

    public void incomingMessage(String message) {
        this._commandProcessor.process(message, this._responseInterface);
    }

    public void socketClosed() {
        this._connected = false;
        this._responseInterface.connectionLost();
    }

    public void help(String command) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructHelpMessage(command));
    }

    public void signOn(String userId, String password) {
        if (userId == null || userId.length() == 0) {
            this._responseInterface.generalError(Translator.getMessage("error.need.userid"));
            return;
        }
        try {
            this.connect();
        }
        catch (IOException e) {
            e.printStackTrace();
            this._responseInterface.generalError(Translator.getMessage("error.cannot.connect", this._host + ":" + this._port));
            return;
        }
        this._responseInterface.generalMessage(Translator.getMessage("connected.logging.in"));
        this._connectionHandler.queueMessage(CommandMakerLocal.constructSignonMessage(userId, password));
    }

    public void signOff() {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructSignoffMessage());
    }

    public void requestRoomList() {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructRequestRoomListMessage());
    }

    public void requestUserList() {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructRequestUserListMessage());
    }

    public void requestUsersInRoomList(String room) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructRequestUsersInRoomListMessage(room));
    }

    public void joinRoom(String room, String password) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructJoinRoomMessage(room, password));
    }

    public void partRoom(String room) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructPartRoomMessage(room));
    }

    public void sayToRoom(String room, String message) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructSayToRoomMessage(room, message));
    }

    public void sayToUser(String userId, String message) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructSayToUserMessage(userId, message));
    }

    public void emoteToRoom(String room, String message) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructEmoteToRoomMessage(room, message));
    }

    public void emoteToUser(String userId, String message) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructEmoteToUserMessage(userId, message));
    }

    public void kill(String userId, String message) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructKillMessage(userId, message));
    }

    public void sendPing(String user, String arg) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructPing(user, arg));
    }

    public void sendPong(String user, String arg) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructPong(user, arg));
    }

    public void requestStats() {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructStats());
    }

    public void requestUserInfo(String user) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructUserInfo(user));
    }

    public void ignore(String userId, String message) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructIgnoreMessage(userId, message));
    }

    public void unignore(String userId) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructUnIgnoreMessage(userId));
    }

    public void reportVersion(String version) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructVersionMessage(version));
    }

    public void op(String userId, String room) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructOpMessage(userId, room));
    }

    public void deop(String userId, String room) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructDeopMessage(userId, room));
    }

    public void kick(String userId, String room) {
        this._connectionHandler.queueMessage(CommandMakerLocal.constructKickMessage(userId, room));
    }

    public void send(ICommands c) {
        this._connectionHandler.queueMessage(c.toString());
    }

    public void connect() throws IOException {
        if (this._connected) {
            System.err.println("already connected...");
            return;
        }
        IOException ioexception = null;
        if (!this._alwaysTunnel) {
            System.err.println("Opening socket connection to " + this._host + ":" + this._port);
            this._responseInterface.generalMessage(Translator.getMessage("connecting.to", this._host + ":" + this._port));
            Socket s = null;
            try {
                s = !this._attemptToTunnel ? new Socket(this._host, this._port) : this._socketOpener.makeSocket(5000L);
                System.err.println("ChatServerLocal: connected to " + this._host + ":" + this._port);
                this._connectionHandler = new ConnectionHandlerLocal(s);
                this._connectionHandler.setListener(this);
                this._connected = true;
                return;
            }
            catch (IOException e) {
                ioexception = e;
            }
        }
        if (this._attemptToTunnel) {
            this._responseInterface.generalMessage(Translator.getMessage("connecting.to", this._readUrl));
            System.err.println("Opening tunnel connetion to " + this._readUrl);
            this._connectionHandler = new HttpConnectionHandler(this._readUrl, this._writeUrl);
            System.err.println("Got the connection.");
            this._connectionHandler.setListener(this);
            this._connected = true;
            return;
        }
        System.err.println("giving up");
        if (ioexception != null) {
            throw ioexception;
        }
    }
}

