/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.local;

import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.client.IChatClient;
import com.lyrisoft.chat.server.local.command.ICommandProcessorLocal;
import com.lyrisoft.chat.server.local.command.UnknownCommand;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandProcessorLocal
implements ICommands {
    private Hashtable _processors;
    private UnknownCommand unknownCommandProcessor = new UnknownCommand();

    public CommandProcessorLocal(Properties p) {
        this._processors = new Hashtable();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            try {
                String className = p.getProperty(name);
                ICommandProcessorLocal cp = (ICommandProcessorLocal)Class.forName(className).newInstance();
                this.extendCommandSet("/" + name, cp);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("Failed to initialize " + name + " command processor");
            }
        }
    }

    public void extendCommandSet(String command, ICommandProcessorLocal processor) {
        this._processors.put(command, processor);
    }

    public void process(String input, IChatClient client) {
        String[] args = CommandProcessorLocal.decompose(input);
        if (args.length == 0) {
            return;
        }
        ICommandProcessorLocal processor = (ICommandProcessorLocal)this._processors.get(args[0]);
        if (processor == null) {
            client.generalMessage(input);
        } else {
            processor.process(client, args);
        }
    }

    public static String[] decompose(String input) {
        StringTokenizer st = new StringTokenizer(input, "\t");
        Vector<String> v = new Vector<String>(5);
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        Object[] args = new String[v.size()];
        v.copyInto(args);
        return args;
    }
}

