/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.local;

import com.lyrisoft.chat.IConnectionHandler;
import com.lyrisoft.chat.IConnectionListener;
import com.lyrisoft.chat.server.local.ConnectionHandlerLocal;
import com.lyrisoft.chat.server.local.HttpWriterThread;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class HttpConnectionHandler
implements IConnectionHandler,
Runnable {
    private IConnectionListener _listener;
    private String _readURL;
    private String _writeURL;
    private String _id;
    private DataInputStream _in;
    private int _linesRead = 0;
    private Thread _reader;
    private boolean _keepGoing = true;
    private HttpWriterThread _writer;

    public HttpConnectionHandler(String readURL, String writeURL) throws IOException {
        this._readURL = readURL;
        this._writeURL = writeURL;
        URL read = new URL(this._readURL);
        URLConnection urlConn = read.openConnection();
        urlConn.setUseCaches(false);
        this._in = new DataInputStream(urlConn.getInputStream());
        this._id = this._in.readLine();
        ++this._linesRead;
        this._reader = new Thread(this);
        this._writer = new HttpWriterThread(this._id, this._writeURL);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            URL read = null;
            read = this._readURL.indexOf("?") >= 0 ? new URL(this._readURL + "&id=" + this._id) : new URL(this._readURL + "?id=" + this._id);
            while (true) {
                if (!this._keepGoing) {
                    System.err.println("HttpReaderThread: stopping gracefully.");
                    return;
                }
                while (true) {
                    void var2_3;
                    String line;
                    if ((line = this._in.readLine()) == null) {
                        if (this._linesRead != 0) break;
                        this.shutdown(true);
                        return;
                    }
                    ConnectionHandlerLocal.DEBUG("< " + (String)var2_3);
                    ++this._linesRead;
                    this._listener.incomingMessage((String)var2_3);
                }
                if (!this._keepGoing) continue;
                URLConnection urlConn = read.openConnection();
                urlConn.setUseCaches(false);
                this._in = new DataInputStream(urlConn.getInputStream());
                this._linesRead = 0;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            this.shutdown(true);
        }
    }

    public void queueMessage(String message) {
        this._writer.queueMessage(message);
    }

    public void sendImmediately(String s) {
        this._writer.send(s);
    }

    public void shutdown(boolean notify) {
        this._keepGoing = false;
        this._writer.pleaseStop();
        this._writer.flushOutputQueue();
        if (notify) {
            this._listener.socketClosed();
        }
    }

    public void setListener(IConnectionListener listener) {
        this._listener = listener;
        this._reader.start();
        this._writer.start();
    }
}

