/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.MMGame;
import client.MWClient;
import client.campaign.CArmy;
import client.campaign.CUnit;
import common.AdvanceTerrain;
import common.MegaMekPilotOption;
import common.PlanetEnvironment;
import common.campaign.Buildings;
import common.util.UnitUtils;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import megamek.client.Client;
import megamek.client.CloseClientListener;
import megamek.client.ui.AWT.ClientGUI;
import megamek.common.BattleArmor;
import megamek.common.Board;
import megamek.common.Building;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.MapSettings;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.Pilot;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Tank;
import megamek.common.event.GameBoardChangeEvent;
import megamek.common.event.GameBoardNewEvent;
import megamek.common.event.GameEndEvent;
import megamek.common.event.GameEntityChangeEvent;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityNewOffboardEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GameMapQueryEvent;
import megamek.common.event.GameNewActionEvent;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GamePlayerConnectedEvent;
import megamek.common.event.GamePlayerDisconnectedEvent;
import megamek.common.event.GameReportEvent;
import megamek.common.event.GameSettingsChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.options.IOption;
import megamek.common.options.IOptionGroup;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.BuildingTemplate;
import megamek.common.util.StringUtil;

class ClientThread
extends Thread
implements GameListener,
CloseClientListener {
    private String gameid;
    private String myname;
    private String serverip;
    private int serverport;
    private MWClient mwclient;
    private Client client;
    private int turn = 0;
    private boolean isHost = false;
    private Vector mechs = new Vector();
    private Vector autoarmy = new Vector();

    public ClientThread(String gameid, String name, String ip, int port, MWClient mwclient, boolean isHost) {
        this(gameid, name, ip, port, mwclient, isHost, new Vector(), new Vector());
    }

    public ClientThread(String gameid, String name, String ip, int port, MWClient mwclient, boolean isHost, Vector mechs, Vector autoarmy) {
        this.gameid = gameid;
        this.myname = name;
        this.serverip = ip;
        this.serverport = port;
        this.mwclient = mwclient;
        this.isHost = isHost;
        this.mechs = mechs;
        this.autoarmy = autoarmy;
        if (this.serverip.indexOf("127.0.0.1") != -1) {
            this.serverip = "127.0.0.1";
        }
    }

    public void setTurn(int t) {
        this.turn = t;
    }

    public int getTurn() {
        return this.turn;
    }

    public void addTurn(int a) {
        this.turn += a;
    }

    public Client getClient() {
        return this.client;
    }

    public void run() {
        block28: {
            boolean playerUpdate = false;
            this.client = new Client(this.myname, this.serverip, this.serverport);
            this.client.game.addGameListener(this);
            this.client.addCloseClientListener(this);
            ClientGUI gui = new ClientGUI(this.client);
            gui.initialize();
            Vector xmlGameOptions = this.client.game.getOptions().loadOptions("");
            xmlGameOptions.addAll(this.mwclient.getGameOptions());
            try {
                this.client.connect();
            }
            catch (Exception ex) {
                this.client = null;
                this.mwclient.showInfoWindow("Couldn't join this game!");
                MWClient.mwClientLog.clientOutputLog(this.serverip + " " + this.serverport);
                return;
            }
            try {
                Entity entity;
                while (this.client.getLocalPlayer() == null) {
                    ClientThread.sleep(50L);
                }
                for (int i = 0; i < 1000 && this.client.game.getPhase() == -1; ++i) {
                    ClientThread.sleep(50L);
                }
                if (this.client.game == null || this.client.game.getPhase() != 1) break block28;
                if (this.mechs.size() > 0 && xmlGameOptions.size() > 0) {
                    this.client.sendGameOptions("", xmlGameOptions);
                }
                IClientPreferences cs = PreferenceManager.getClientPreferences();
                cs.setStampFilenames(Boolean.valueOf(this.mwclient.getserverConfigs("MMTimeStampLogFile")));
                cs.setShowUnitId(Boolean.valueOf(this.mwclient.getserverConfigs("MMShowUnitId")));
                cs.setKeepGameLog(Boolean.valueOf(this.mwclient.getserverConfigs("MMKeepGameLog")));
                cs.setGameLogFilename(this.mwclient.getserverConfigs("MMGameLogName"));
                if (this.mwclient.getConfig().getParam("UNITCAMO").length() > 0) {
                    this.client.getLocalPlayer().setCamoCategory("-- General --");
                    this.client.getLocalPlayer().setCamoFileName(this.mwclient.getConfig().getParam("UNITCAMO"));
                    playerUpdate = true;
                }
                if (this.mwclient.getPlayerStartingEdge() != -1) {
                    this.client.getLocalPlayer().setStartingPos(this.mwclient.getPlayerStartingEdge());
                    playerUpdate = true;
                }
                if (playerUpdate) {
                    this.client.sendPlayerInfo();
                }
                for (CUnit mek : this.mechs) {
                    entity = mek.getEntity();
                    entity.setExternalId(mek.getId());
                    entity.setOwner(this.client.getLocalPlayer());
                    IOptionGroup group = null;
                    Pilot pilot = null;
                    pilot = mek.getType() == 0 || mek.getType() == 1 ? new Pilot(mek.getPilot().getName(), mek.getPilot().getGunnery(), mek.getPilot().getPiloting()) : new Pilot(mek.getPilot().getName(), mek.getPilot().getGunnery(), 5);
                    Enumeration enumeration = pilot.getOptions().getGroups();
                    while (enumeration.hasMoreElements() && !(group = (IOptionGroup)enumeration.nextElement()).getKey().equalsIgnoreCase("lvl3Advantages")) {
                    }
                    block8: for (MegaMekPilotOption po : mek.getPilot().getMegamekOptions()) {
                        Enumeration j = group.getOptions();
                        while (j.hasMoreElements()) {
                            IOption option = (IOption)j.nextElement();
                            if (!option.getName().equals(po.getMmname())) continue;
                            if (po.getMmname().equals("weapon_specialist")) {
                                option.setValue(mek.getPilot().getWeapon());
                                continue block8;
                            }
                            option.setValue(po.isValue());
                            continue block8;
                        }
                    }
                    entity.setCrew(pilot);
                    this.client.sendAddEntity(entity);
                    ClientThread.sleep(125L);
                }
                for (CUnit autoUnit : this.autoarmy) {
                    entity = autoUnit.getEntity();
                    entity.setOwner(this.client.getLocalPlayer());
                    Pilot pilot = new Pilot("AutoArtillery", 4, 5);
                    entity.setCrew(pilot);
                    this.client.sendAddEntity(entity);
                    ClientThread.sleep(125L);
                }
                if (this.mechs.size() <= 0) break block28;
                Vector<CArmy> armies = this.mwclient.getPlayer().getArmies();
                for (int i = 0; i < armies.size(); ++i) {
                    CArmy army = armies.get(i);
                    if (!army.isLocked()) continue;
                    if (army.getC3Network().size() < 1) break;
                    Enumeration slave = army.getC3Network().keys();
                    Enumeration master = army.getC3Network().elements();
                    while (slave.hasMoreElements()) {
                        Integer slaveid = (Integer)slave.nextElement();
                        Integer masterid = (Integer)master.nextElement();
                        this.linkMegaMekC3Units(army, slaveid, masterid);
                    }
                    break;
                }
                if (this.mwclient.getCurrentEnvironment() != null) {
                    MapSettings mySettings = new MapSettings(this.mwclient.getMapSize().width, this.mwclient.getMapSize().height, 1, 1);
                    AdvanceTerrain aTerrain = new AdvanceTerrain();
                    aTerrain = this.mwclient.getCurrentAdvanceTerrain();
                    if (aTerrain != null && aTerrain.isStaticMap()) {
                        mySettings = new MapSettings(aTerrain.getXSize(), aTerrain.getYSize(), aTerrain.getXBoardSize(), aTerrain.getYBoardSize());
                        Vector<String> boardvec = new Vector<String>();
                        if (aTerrain.getStaticMapName().equalsIgnoreCase("surprise")) {
                            int maxBoards = aTerrain.getXBoardSize() * aTerrain.getYBoardSize();
                            for (int i = 0; i < maxBoards; ++i) {
                                boardvec.add("[SURPRISE]");
                            }
                            mySettings.setBoardsSelectedVector(boardvec);
                            mySettings.setBoardsAvailableVector(this.scanForBoards(aTerrain.getXSize(), aTerrain.getYSize()));
                        } else {
                            boardvec.add(aTerrain.getStaticMapName());
                            mySettings.setBoardsSelectedVector(boardvec);
                        }
                        this.client.sendMapSettings(mySettings);
                    } else {
                        PlanetEnvironment env = this.mwclient.getCurrentEnvironment();
                        mySettings.setElevationParams(env.getHillyness(), env.getHillElevationRange(), env.getHillInvertProb());
                        mySettings.setWaterParams(env.getWaterMinSpots(), env.getWaterMaxSpots(), env.getWaterMinHexes(), env.getWaterMaxHexes(), env.getWaterDeepProb());
                        mySettings.setForestParams(env.getForestMinSpots(), env.getForestMaxSpots(), env.getForestMinHexes(), env.getForestMaxHexes(), env.getForestHeavyProb());
                        mySettings.setRoughParams(env.getRoughMinSpots(), env.getRoughMaxSpots(), env.getRoughMinHexes(), env.getRoughMaxHexes());
                        mySettings.setSwampParams(env.getSwampMinSpots(), env.getSwampMaxSpots(), env.getSwampMinHexes(), env.getSwampMaxHexes());
                        mySettings.setPavementParams(env.getPavementMinSpots(), env.getPavementMaxSpots(), env.getPavementMinHexes(), env.getPavementMaxHexes());
                        mySettings.setIceParams(env.getIceMinSpots(), env.getIceMaxSpots(), env.getIceMinHexes(), env.getIceMaxHexes());
                        mySettings.setRubbleParams(env.getRubbleMinSpots(), env.getRubbleMaxSpots(), env.getRubbleMinHexes(), env.getRubbleMaxHexes());
                        mySettings.setFortifiedParams(env.getFortifiedMinSpots(), env.getFortifiedMaxSpots(), env.getFortifiedMinHexes(), env.getFortifiedMaxHexes());
                        mySettings.setSpecialFX(env.getFxMod(), env.getProbForestFire(), env.getProbFreeze(), env.getProbFlood(), env.getProbDrought());
                        mySettings.setRiverParam(env.getRiverProb());
                        mySettings.setRoadParam(env.getRoadProb());
                        mySettings.setCraterParam(env.getCraterProb(), env.getCraterMinNum(), env.getCraterMaxNum(), env.getCraterMinRadius(), env.getCraterMaxRadius());
                        mySettings.setAlgorithmToUse(env.getAlgorithm());
                        if (env.getTheme().length() > 1) {
                            mySettings.setTheme(env.getTheme());
                        }
                        Vector<String> boardvec = new Vector<String>();
                        boardvec.add("[GENERATED]");
                        mySettings.setBoardsSelectedVector(boardvec);
                        if (this.mwclient.getBuildingTemplate() != null && this.mwclient.getBuildingTemplate().getTotalBuildings() > 0) {
                            Vector buildingList = this.generateRandomBuildings(mySettings, this.mwclient.getBuildingTemplate());
                            mySettings.setBoardBuildings(buildingList);
                        } else if (env.getMaxBuildings() > 0) {
                            Buildings template = new Buildings();
                            template.setMaxCF(env.getMaxCF());
                            template.setMinCF(env.getMinCF());
                            template.setMaxFloors(env.getMaxFloors());
                            template.setMinFloors(env.getMinFloors());
                            template.setBuildingType(env.getBuildingTypes());
                            Random r = new Random();
                            int total = 0;
                            total = env.getMaxBuildings() - env.getMinBuildings() <= 0 ? env.getMaxBuildings() : r.nextInt(env.getMaxBuildings() - env.getMinBuildings()) + env.getMinBuildings();
                            template.setTotalBuildings(total);
                            template.setStartingEdge(-1);
                            Vector buildingList = this.generateRandomBuildings(mySettings, template);
                            mySettings.setBoardBuildings(buildingList);
                        }
                        this.client.sendMapSettings(mySettings);
                    }
                }
            }
            catch (Exception e) {
                MWClient.mwClientLog.clientOutputLog(e);
            }
        }
    }

    public void gamePlayerStatusChange(GameEvent e) {
    }

    public void gameTurnChange(GameTurnChangeEvent e) {
        if (this.client != null) {
            if (this.getTurn() == 0) {
                this.mwclient.setGameState("Running");
            }
            this.addTurn(1);
        }
    }

    public String serializeEntity(Entity e, boolean fullStatus, boolean forceDevastate) {
        String result = "";
        if (fullStatus) {
            if (!(e instanceof MechWarrior)) {
                result = result + e.getExternalId() + "*";
                result = result + e.getOwner().getName() + "*";
                result = result + e.getCrew().getHits() + "*";
                result = forceDevastate ? result + "1024*" : result + e.getRemovalCondition() + "*";
                result = e instanceof Mech ? result + "0*" : (e instanceof QuadMech ? result + "5*" : (e instanceof Tank ? result + "1*" : (e instanceof Protomech ? result + "3*" : (e instanceof BattleArmor ? result + "4*" : result + "2*"))));
                Enumeration en = e.getKills();
                if (!en.hasMoreElements()) {
                    result = result + " *";
                }
                while (en.hasMoreElements()) {
                    Entity kill = (Entity)en.nextElement();
                    result = result + kill.getExternalId();
                    if (en.hasMoreElements()) {
                        result = result + "~";
                        continue;
                    }
                    result = result + "*";
                }
            }
            if (e instanceof Mech || e instanceof QuadMech) {
                result = result + e.getCrew().isUnconscious() + "*";
                result = result + e.getInternal(1) + "*";
                result = result + e.getInternal(0) + "*";
                result = result + e.getInternal(7) + "*";
                result = result + e.getInternal(6) + "*";
                result = result + e.getInternal(5) + "*";
                result = result + e.getInternal(4) + "*";
                result = result + e.getBadCriticals(0, 4, 1) + "*";
            } else if (e instanceof Tank) {
                result = result + e.isRepairable() + "*";
            } else if (e instanceof MechWarrior) {
                MechWarrior mw = (MechWarrior)e;
                result = result + "MW*";
                result = result + mw.getOriginalRideExternalId() + "*";
                result = result + mw.getPickedUpByExternalId() + "*";
                result = result + mw.isDestroyed() + "*";
            }
            if (e.isOffBoard()) {
                result = result + e.getOffBoardDistance();
            }
        } else if (e instanceof MechWarrior) {
            MechWarrior mw = (MechWarrior)e;
            result = result + "MW*" + mw.getOriginalRideExternalId() + "*";
            result = result + mw.getPickedUpByExternalId() + "*";
            result = result + mw.isDestroyed();
        } else {
            result = result + e.getOwner().getName() + "*";
            result = result + e.getExternalId() + "*";
            result = forceDevastate ? result + "1024*" : result + e.getRemovalCondition() + "*";
            if (e instanceof Mech || e instanceof QuadMech) {
                result = result + e.getInternal(1) + "*";
                result = result + e.getInternal(0) + "*";
            } else {
                result = result + "1*";
                result = result + "1*";
            }
            result = result + e.isRepairable() + "*";
        }
        return result;
    }

    public void gamePhaseChange(GamePhaseChangeEvent e) {
        String result = "";
        String winnerName = "";
        String name = "";
        try {
            if (this.client.game.getPhase() == 18) {
                MMGame game;
                Entity ent;
                if (this.client.getLocalPlayer().isObserver()) {
                    return;
                }
                winnerName = "";
                if (this.client.game.getVictoryTeam() != 0) {
                    Enumeration en = this.client.game.getPlayers();
                    while (en.hasMoreElements()) {
                        Player p = (Player)en.nextElement();
                        if (p.getTeam() != this.client.game.getVictoryTeam()) continue;
                        StringTokenizer st = new StringTokenizer(p.getName().trim(), "~");
                        name = "";
                        while (st.hasMoreElements()) {
                            name = st.nextToken().trim();
                        }
                        winnerName = winnerName + name + "*";
                    }
                    winnerName = winnerName + "#";
                } else {
                    winnerName = this.client.game.getPlayer(this.client.game.getVictoryPlayerId()).getName();
                    StringTokenizer st = new StringTokenizer(winnerName, "~");
                    name = "";
                    while (st.hasMoreElements()) {
                        name = st.nextToken().trim();
                    }
                    winnerName = name + "#";
                }
                result = result + winnerName;
                boolean useRepairs = Boolean.valueOf(this.mwclient.getserverConfigs("UseAdvanceRepair"));
                Enumeration en = this.client.game.getDevastatedEntities();
                while (en.hasMoreElements()) {
                    ent = (Entity)en.nextElement();
                    result = result + this.serializeEntity(ent, true, false) + "#";
                }
                en = this.client.game.getGraveyardEntities();
                while (en.hasMoreElements()) {
                    ent = (Entity)en.nextElement();
                    result = ent instanceof Mech && ent.getInternal(1) <= 0 ? result + this.serializeEntity(ent, true, true) + "#" : result + this.serializeEntity(ent, true, false) + "#";
                    if (!useRepairs) continue;
                    this.mwclient.sendChat("/c setunitrepair#" + ent.getOwner().getName() + "#" + ent.getExternalId() + "#" + UnitUtils.unitBattleDamage(ent));
                }
                en = this.client.game.getEntities();
                while (en.hasMoreElements()) {
                    ent = (Entity)en.nextElement();
                    result = ent instanceof Mech && ent.getInternal(1) <= 0 ? result + this.serializeEntity(ent, true, true) + "#" : result + this.serializeEntity(ent, true, false) + "#";
                    if (!useRepairs) continue;
                    this.mwclient.sendChat("/c setunitrepair#" + ent.getOwner().getName() + "#" + ent.getExternalId() + "#" + UnitUtils.unitBattleDamage(ent));
                }
                en = this.client.game.getRetreatedEntities();
                while (en.hasMoreElements()) {
                    ent = (Entity)en.nextElement();
                    result = ent instanceof Mech && ent.getInternal(1) <= 0 ? result + this.serializeEntity(ent, true, true) + "#" : result + this.serializeEntity(ent, true, false) + "#";
                    if (!useRepairs) continue;
                    this.mwclient.sendChat("/c setunitrepair#" + ent.getOwner().getName() + "#" + ent.getExternalId() + "#" + UnitUtils.unitBattleDamage(ent));
                }
                if (this.mwclient.getBuildingTemplate() != null) {
                    result = result + "BL*" + this.getBuildingsLeft();
                }
                MWClient.mwClientLog.clientOutputLog("CR|" + result);
                this.mwclient.serverSend("CR|" + result);
                MWClient.mwClientLog.clientOutputLog("GAME END");
                if (this.mwclient.getPlayer().getName().equalsIgnoreCase(name) && (game = this.mwclient.games.getGame(this.gameid)).getPlayerName().startsWith("[Dedicated]")) {
                    String dedPrefix = game.getDedPrefix();
                    this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "mail " + game.getPlayerName() + "," + dedPrefix + "checkrestartcount");
                }
            } else if (this.client.game.getPhase() == 13 || this.client.game.getPhase() == 15 || this.client.game.getPhase() == 9 || this.client.game.getPhase() == 17 || this.client.game.getPhase() == 11) {
                Entity currEntity;
                if (this.client.getLocalPlayer().isObserver()) {
                    return;
                }
                Enumeration en = this.client.game.getWreckedEntities();
                while (en.hasMoreElements()) {
                    currEntity = (Entity)en.nextElement();
                    if (!(currEntity instanceof MechWarrior)) continue;
                    this.mwclient.serverSend("IPU|" + this.serializeEntity(currEntity, false, false));
                }
                en = this.client.game.getEntities();
                while (en.hasMoreElements()) {
                    currEntity = (Entity)en.nextElement();
                    if (!(currEntity instanceof MechWarrior)) continue;
                    this.mwclient.serverSend("IPU|" + this.serializeEntity(currEntity, false, false));
                }
            }
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("Error reporting game!");
            MWClient.mwClientLog.clientErrLog(ex);
        }
    }

    public void gameEntityRemove(GameEntityRemoveEvent e) {
        if (this.client.getLocalPlayer().isObserver()) {
            return;
        }
        Entity removedE = e.getEntity();
        String toSend = this.serializeEntity(removedE, false, false);
        this.mwclient.serverSend("IPU|" + toSend);
    }

    public void gamePlayerConnected(GamePlayerConnectedEvent e) {
    }

    public void gamePlayerDisconnected(GamePlayerDisconnectedEvent e) {
    }

    public void gamePlayerChange(GamePlayerChangeEvent e) {
    }

    public void gamePlayerChat(GamePlayerChatEvent e) {
    }

    public void gameReport(GameReportEvent e) {
    }

    public void gameEnd(GameEndEvent e) {
    }

    public void gameBoardNew(GameBoardNewEvent e) {
    }

    public void gameBoardChanged(GameBoardChangeEvent e) {
    }

    public void gameSettingsChange(GameSettingsChangeEvent e) {
    }

    public void gameMapQuery(GameMapQueryEvent e) {
    }

    public void gameEntityNew(GameEntityNewEvent e) {
    }

    public void gameEntityNewOffboard(GameEntityNewOffboardEvent e) {
    }

    public void gameEntityChange(GameEntityChangeEvent e) {
    }

    public void gameNewAction(GameNewActionEvent e) {
    }

    public void clientClosed() {
        PreferenceManager.getInstance().save();
        this.mwclient.closingGame(this.gameid);
    }

    public void linkMegaMekC3Units(CArmy army, Integer slaveid, Integer masterid) {
        Entity c3Unit = null;
        Entity c3Master = null;
        while (c3Unit == null && c3Master == null) {
            Enumeration unitList = this.client.getEntities();
            try {
                while (unitList.hasMoreElements()) {
                    Entity tempUnit = (Entity)unitList.nextElement();
                    if (tempUnit.getExternalId() == slaveid.intValue()) {
                        c3Unit = tempUnit;
                    } else if (tempUnit.getExternalId() == masterid.intValue()) {
                        c3Master = tempUnit;
                    }
                    if (c3Unit == null || c3Master == null) continue;
                    break;
                }
                ClientThread.sleep(125L);
            }
            catch (Exception ex) {
                System.err.println("Error in linkMegaMekC3Units");
            }
        }
        if (c3Unit == null || c3Master == null) {
            return;
        }
        try {
            CUnit masterUnit = (CUnit)army.getUnit(masterid);
            if (!masterUnit.hasC3SlavesLinkedTo(army) && masterUnit.hasBeenC3LinkedTo(army) && (masterUnit.getC3Level() == 2 || masterUnit.getC3Level() == 4)) {
                c3Master.setShutDown(false);
                c3Master.setC3Master(c3Master);
            }
            c3Unit.setShutDown(false);
            c3Master.setShutDown(false);
            c3Unit.setC3Master(c3Master);
            this.client.sendUpdateEntity(c3Unit);
            this.client.sendUpdateEntity(c3Master);
            ClientThread.sleep(125L);
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
            MWClient.mwClientLog.clientErrLog("Error in setting up C3Network");
        }
    }

    private Vector scanForBoards(int boardWidth, int boardHeight) {
        Vector<String> boards = new Vector<String>();
        File boardDir = new File("data/boards");
        if (!boardDir.isDirectory()) {
            return boards;
        }
        String[] fileList = boardDir.list();
        Vector<String> tempList = new Vector<String>();
        Comparator sortComp = StringUtil.stringComparator();
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].indexOf(".board") == -1 || !Board.boardIsSize(fileList[i], boardWidth, boardHeight)) continue;
            tempList.addElement(fileList[i].substring(0, fileList[i].lastIndexOf(".board")));
        }
        if (tempList.size() > 0) {
            boards.addElement("[RANDOM]");
            boards.addElement("[SURPRISE]");
            boards.addElement("[GENERATED]");
            Collections.sort(tempList, sortComp);
            for (int loop = 0; loop < tempList.size(); ++loop) {
                boards.addElement((String)tempList.elementAt(loop));
            }
        } else {
            boards.addElement("[GENERATED]");
        }
        return boards;
    }

    private Vector generateRandomBuildings(MapSettings mapSettings, Buildings buildingTemplate) {
        Vector<BuildingTemplate> buildingList = new Vector<BuildingTemplate>();
        Vector<String> buildingTypes = new Vector<String>();
        int width = mapSettings.getBoardWidth();
        int height = mapSettings.getBoardHeight();
        int minHeight = 0;
        int minWidth = 0;
        switch (buildingTemplate.getStartingEdge()) {
            case 2: {
                height = 5;
                minHeight = 1;
                break;
            }
            case 6: {
                if (height > 5) {
                    minHeight = height - 5;
                }
                height = 5;
                break;
            }
            case 4: {
                if (width > 5) {
                    minWidth = width - 5;
                }
                width = 5;
                break;
            }
            case 8: {
                width = 5;
                minWidth = 1;
                break;
            }
        }
        StringTokenizer types = new StringTokenizer(buildingTemplate.getBuildingType(), ",");
        while (types.hasMoreTokens()) {
            buildingTypes.add(types.nextToken());
        }
        int typeSize = buildingTypes.size();
        Random r = new Random();
        TreeSet<String> tempMap = new TreeSet<String>();
        Coords coord = new Coords();
        String stringCoord = "";
        for (int count = 0; count < buildingTemplate.getTotalBuildings(); ++count) {
            int y;
            int x;
            int loops = 0;
            boolean CFx2 = false;
            Vector<Coords> coordList = new Vector<Coords>();
            do {
                if (loops++ > 100) {
                    CFx2 = true;
                    break;
                }
                x = r.nextInt(width) + minWidth;
                y = r.nextInt(height) + minHeight;
                if (x >= mapSettings.getBoardWidth()) {
                    x = mapSettings.getBoardWidth() - 2;
                } else if (x <= 1) {
                    x = 2;
                }
                if (y >= mapSettings.getBoardHeight()) {
                    y = mapSettings.getBoardHeight() - 2;
                } else if (y <= 1) {
                    y = 2;
                }
                coord = new Coords(x, y);
            } while (tempMap.contains(stringCoord = x + "," + y));
            tempMap.add(stringCoord);
            coordList.add(coord);
            int floors = buildingTemplate.getMaxFloors() - buildingTemplate.getMinFloors();
            floors = floors <= 0 ? buildingTemplate.getMinFloors() : r.nextInt(floors) + buildingTemplate.getMinFloors();
            int totalCF = buildingTemplate.getMaxCF() - buildingTemplate.getMinCF();
            totalCF = totalCF <= 0 ? buildingTemplate.getMinCF() : r.nextInt(totalCF) + buildingTemplate.getMinCF();
            if (CFx2) {
                totalCF *= 2;
            }
            int type = 1;
            try {
                type = typeSize == 1 ? Integer.parseInt((String)buildingTypes.elementAt(0)) : Integer.parseInt((String)buildingTypes.elementAt(r.nextInt(typeSize)));
            }
            catch (Exception ex) {
                // empty catch block
            }
            buildingList.add(new BuildingTemplate(type, coordList, totalCF, floors, -1));
        }
        return buildingList;
    }

    public int getBuildingsLeft() {
        Enumeration buildings = this.client.game.getBoard().getBuildings();
        int buildingCount = 0;
        while (buildings.hasMoreElements()) {
            Building building = (Building)buildings.nextElement();
            ++buildingCount;
        }
        return buildingCount;
    }
}

