/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.campaign.CCampaign;
import client.campaign.CPlayer;
import client.campaign.CUnit;
import client.gui.HSMek;
import client.gui.MMNetHyperLinkListener;
import client.gui.MyHTMLEditorKit;
import client.gui.SpringLayoutHelper;
import client.gui.dialog.MechDetailDisplay;
import common.House;
import common.UnitFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.border.LineBorder;
import megamek.common.Entity;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Pilot;

public class CHSPanel
extends JPanel {
    MWClient mwclient;
    CPlayer thePlayer;
    CCampaign theCampaign;
    JEditorPane mainPane = new JEditorPane();
    JScrollPane scrollPane = new JScrollPane();
    MyHTMLEditorKit kit = new MyHTMLEditorKit();
    GridBagConstraints gridBagConstraints;
    private JPanel pnlBtns = new JPanel();
    private JPanel hsButtonSpringPanel = new JPanel();
    private JButton btnRefresh = new JButton();
    private JButton buyNewButton = new JButton();
    private JButton buyUsedButton = new JButton();
    private JLabel lblInfo = new JLabel();
    private BuyPopupListener myPopup = null;
    long lastUpdate = System.currentTimeMillis();
    private String HouseName;
    private Hashtable Components = new Hashtable();
    private Hashtable Factories = new Hashtable();
    private Hashtable Units = new Hashtable();

    public CHSPanel(MWClient client) {
        this.setLayout(new GridBagLayout());
        this.mwclient = client;
        this.theCampaign = this.mwclient.getCampaign();
        this.thePlayer = this.theCampaign.getPlayer();
        this.myPopup = new BuyPopupListener();
        this.mainPane.setEditorKit(this.kit);
        this.mainPane.setEditable(false);
        this.mainPane.addHyperlinkListener(new MMNetHyperLinkListener(this.mwclient, this));
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setViewportBorder(new LineBorder(new Color(0, 0, 0)));
        this.scrollPane.setViewportView(this.mainPane);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 0;
        this.gridBagConstraints.fill = 1;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, this.gridBagConstraints);
        this.pnlBtns.setLayout(new BoxLayout(this.pnlBtns, 1));
        this.hsButtonSpringPanel = new JPanel(new SpringLayout());
        this.buyNewButton.setText("Buy New");
        this.buyNewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CHSPanel.this.buyNewButtonActionPerformed(evt);
            }
        });
        this.buyNewButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                CHSPanel.this.buyNewUnitMouseEvent(evt);
            }
        });
        this.hsButtonSpringPanel.add(this.buyNewButton);
        this.buyUsedButton.setText("Buy Used");
        this.buyUsedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CHSPanel.this.buyUsedButtonActionPerformed(evt);
            }
        });
        this.buyUsedButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                CHSPanel.this.buyUsedUnitMouseEvent(evt);
            }
        });
        this.hsButtonSpringPanel.add(this.buyUsedButton);
        this.btnRefresh.setText("Refresh [Last: Never]");
        this.btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CHSPanel.this.mwclient.sendChat("/c status");
            }
        });
        this.hsButtonSpringPanel.add(this.btnRefresh);
        SpringLayoutHelper.setupSpringGrid(this.hsButtonSpringPanel, 1, 3);
        this.lblInfo.setAlignmentX(0.5f);
        this.lblInfo.setSize(0, 0);
        this.pnlBtns.add(this.lblInfo);
        this.pnlBtns.add(this.hsButtonSpringPanel);
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.gridx = 0;
        this.gridBagConstraints.gridy = 1;
        this.gridBagConstraints.fill = 2;
        this.gridBagConstraints.weightx = 1.0;
        this.gridBagConstraints.weighty = 0.0;
        this.add((Component)this.pnlBtns, this.gridBagConstraints);
        TThread clockT = new TThread(this);
        clockT.start();
    }

    public void setStatus(String s) {
        Integer type;
        Integer weight;
        StringTokenizer ST2;
        this.lastUpdate = System.currentTimeMillis();
        this.updateClock();
        this.Factories = new Hashtable();
        this.Components = new Hashtable();
        this.Units = new Hashtable();
        StringTokenizer ST = new StringTokenizer(s, "|");
        ST.nextElement();
        this.HouseName = ST.nextToken();
        if (!ST.nextToken().equals("STARTCOM")) {
            return;
        }
        String next = ST.nextToken();
        while (!next.equals("ENDCOM")) {
            ST2 = new StringTokenizer(next, "$");
            weight = new Integer(ST2.nextToken());
            type = new Integer(ST2.nextToken());
            Integer components = new Integer(ST2.nextToken());
            Integer units = new Integer(ST2.nextToken());
            this.Components.put(weight + "$" + type, components + "$" + units);
            next = ST.nextToken();
        }
        if (!ST.nextToken().equals("STARTFAC")) {
            return;
        }
        next = ST.nextToken();
        while (!next.equals("ENDFAC")) {
            ST2 = new StringTokenizer(next, "$");
            weight = new Integer(ST2.nextToken());
            type = new Integer(ST2.nextToken());
            String founder = ST2.nextToken();
            String planet = ST2.nextToken();
            String factoryName = ST2.nextToken();
            Integer timeUntilRefresh = new Integer(ST2.nextToken());
            if (this.canProduce(0, type)) {
                this.addFactory(weight, new Integer(0), founder, planet, factoryName, timeUntilRefresh);
            }
            if (this.canProduce(1, type)) {
                this.addFactory(weight, new Integer(1), founder, planet, factoryName, timeUntilRefresh);
            }
            if (this.canProduce(2, type)) {
                this.addFactory(weight, new Integer(2), founder, planet, factoryName, timeUntilRefresh);
            }
            if (this.canProduce(3, type)) {
                this.addFactory(weight, new Integer(3), founder, planet, factoryName, timeUntilRefresh);
            }
            if (this.canProduce(4, type)) {
                this.addFactory(weight, new Integer(4), founder, planet, factoryName, timeUntilRefresh);
            }
            next = ST.nextToken();
            this.mwclient.getData().updateFactoryTick(planet, factoryName, timeUntilRefresh);
        }
        if (!ST.nextToken().equals("STARTBAY")) {
            return;
        }
        next = ST.nextToken();
        while (!next.equals("ENDBAY")) {
            String weight2 = next;
            String type2 = ST.nextToken();
            next = ST.nextToken();
            Vector<HSMek> v = new Vector<HSMek>();
            while (!next.equals("NEXT")) {
                String unit = next;
                HSMek m = new HSMek(unit);
                v.add(m);
                next = ST.nextToken();
            }
            this.Units.put(weight2 + "$" + type2, v);
            next = ST.nextToken();
        }
        this.updateDisplay();
    }

    public void addFactory(Integer weight, Integer type, String founder, String planet, String factoryName, Integer timeUntilRefresh) {
        Vector v = this.Factories.get(weight + "$" + type) == null ? new Vector() : (Vector)this.Factories.get(weight + "$" + type);
        v.add(founder + "$" + planet + "$" + factoryName + "$" + timeUntilRefresh);
        this.Factories.put(weight + "$" + type, v);
    }

    public boolean canProduce(int type_id, int productionCapabilities) {
        if (productionCapabilities == UnitFactory.BUILDALL) {
            return true;
        }
        int test = productionCapabilities;
        if (test - UnitFactory.BUILDBATTLEARMOR >= 0) {
            test -= UnitFactory.BUILDBATTLEARMOR;
            if (type_id == 4) {
                return true;
            }
        }
        if (test - UnitFactory.BUILDPROTOMECHS >= 0) {
            test -= UnitFactory.BUILDPROTOMECHS;
            if (type_id == 3) {
                return true;
            }
        }
        if (test - UnitFactory.BUILDINFANTRY >= 0) {
            test -= UnitFactory.BUILDINFANTRY;
            if (type_id == 2) {
                return true;
            }
        }
        if (test - UnitFactory.BUILDVEHICLES >= 0) {
            test -= UnitFactory.BUILDVEHICLES;
            if (type_id == 1) {
                return true;
            }
        }
        return test - UnitFactory.BUILDMEK >= 0 && type_id == 0;
    }

    public void updateDisplay() {
        String useIt;
        String result = "";
        result = result + "<TABLE Border=\"1\"><TR><TH>" + this.HouseName + "</TH><TH>Light</TH><TH>Medium</TH><TH>Heavy</TH><TH>Assault</TH></TR>";
        for (int type_id = 0; type_id < CUnit.TOTALTYPES; ++type_id) {
            useIt = "Use" + CUnit.getTypeClassDesc(type_id);
            if (!Boolean.valueOf(this.mwclient.getserverConfigs(useIt)).booleanValue()) continue;
            result = result + "<TR><TD VALIGN=MIDDLE><b>" + CUnit.getTypeClassDesc(type_id) + "</b></TD>";
            for (int weight = 0; weight < 4; ++weight) {
                Vector<String> supportedFactions = new Vector<String>();
                for (House faction : this.mwclient.getData().getAllHouses()) {
                    supportedFactions.add(faction.getName());
                }
                String Comps = (String)this.Components.get(weight + "$" + type_id);
                StringTokenizer ST = new StringTokenizer(Comps, "$");
                int comps = Integer.parseInt(ST.nextToken());
                if (comps > 0 || this.Factories.get(weight + "$" + type_id) != null) {
                    result = result + "<TD><img src=\"data/images/miniticks.gif\">:" + comps;
                    result = result + "<img src=\"data/images/units.gif\">:" + ST.nextToken();
                    result = result + "<br>";
                    String openRes = "";
                    String closedRes = "";
                    int typetocheck = type_id;
                    Vector facs = (Vector)this.Factories.get(weight + "$" + typetocheck);
                    if (facs != null) {
                        boolean hasOpen = false;
                        int minrefresh = Integer.MAX_VALUE;
                        for (int i = 0; i < facs.size(); ++i) {
                            String Fac = (String)facs.elementAt(i);
                            ST = new StringTokenizer(Fac, "$");
                            String founder = ST.nextToken();
                            String planet = ST.nextToken();
                            String factoryName = ST.nextToken();
                            int refreshTime = Integer.parseInt(ST.nextToken());
                            String addon = "";
                            if (supportedFactions.contains(founder)) {
                                addon = founder;
                            }
                            if (refreshTime == 0) {
                                openRes = openRes + "<a href=\"MEKWARS/c request#" + weight + "#" + type_id + "#" + planet + "#" + factoryName + "\"><img border=\"0\" alt=\"Click to buy from " + factoryName + " on " + planet + " built by " + founder + "\" src=\"data/images/open" + addon + ".gif\"></a>";
                                hasOpen = true;
                                continue;
                            }
                            closedRes = closedRes + "<a href=\"MEKWARS/c request#" + weight + "#" + type_id + "#" + planet + "#" + factoryName + "\"<img border=\"0\" alt=\"" + factoryName + " on " + planet + " built by " + founder + " (Refresh Time: " + refreshTime + ")\" src=\"data/images/closed" + addon + ".gif\"></a>";
                            if (refreshTime >= minrefresh) continue;
                            minrefresh = refreshTime;
                        }
                        result = result + openRes + closedRes;
                        if (!hasOpen) {
                            result = result + "<img src=\"data/images/clock.gif\">:" + minrefresh;
                        }
                    } else {
                        result = result + "<img src=\"data/images/absent.gif\">";
                    }
                } else {
                    result = result + "<TD> </TD>";
                }
                result = result + "</TD>";
            }
            result = result + "</TR>";
        }
        result = result + "</TABLE>";
        for (int type = 0; type < CUnit.TOTALTYPES; ++type) {
            int weight;
            useIt = "Use" + CUnit.getTypeClassDesc(type);
            if (!Boolean.valueOf(this.mwclient.getserverConfigs(useIt)).booleanValue()) continue;
            boolean hasUnits = false;
            for (weight = 0; weight < 4; ++weight) {
                if (this.Units.get(weight + "$" + type) == null) continue;
                hasUnits = true;
            }
            if (hasUnits) {
                result = result + "<b>" + CUnit.getTypeClassDesc(type) + " Bays</b><br>";
            }
            for (weight = 0; weight < 4; ++weight) {
                if (this.Units.get(weight + "$" + type) == null) continue;
                result = result + "<a href=\"MEKWARS/c requestdonated#" + weight + "#" + type + "\"><img border=\"0\" alt=\"Request one of the Units from this bay" + "\" src=\"data/images/cart.gif\"></a> " + CUnit.getWeightclassName(weight) + ": ";
                Vector v = (Vector)this.Units.get(weight + "$" + type);
                HSMek[] entities = new HSMek[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    entities[i] = (HSMek)v.elementAt(i);
                }
                Arrays.sort(entities, new Comparator(){

                    public int compare(Object obj1, Object obj2) {
                        HSMek a = (HSMek)obj1;
                        HSMek b = (HSMek)obj2;
                        if (a.getName().compareTo(b.getName()) == 0) {
                            if (a.getGunnery() == b.getGunnery()) {
                                if (a.getPiloting() == b.getPiloting()) {
                                    if (a.getSkills().equals(b.getSkills())) {
                                        return 0;
                                    }
                                    return a.getSkills().compareTo(b.getSkills());
                                }
                                if (a.getPiloting() > b.getPiloting()) {
                                    return 1;
                                }
                                return -1;
                            }
                            if (a.getGunnery() > b.getGunnery()) {
                                return 1;
                            }
                            return -1;
                        }
                        return a.getName().compareTo(b.getName());
                    }
                });
                for (int j = 0; j < entities.length; ++j) {
                    String unitString = "";
                    HSMek m = entities[j];
                    int num = 1;
                    while (j < entities.length - 1 && m.getName().equalsIgnoreCase(entities[j + 1].getName()) && m.getGunnery() == entities[j + 1].getGunnery() && m.getPiloting() == entities[j + 1].getPiloting() && m.getSkills().equalsIgnoreCase(entities[j + 1].getSkills())) {
                        ++j;
                        ++num;
                    }
                    unitString = m.getType().equalsIgnoreCase("mek") || m.getType().equalsIgnoreCase("vehicle") ? unitString + "<a href=\"MEKINFO" + m.getMekFile() + "#" + m.getBV() + "#" + m.getGunnery() + "#" + m.getPiloting() + "\">" + m.getName() + "(" + m.getGunnery() + "/" + m.getPiloting() : unitString + "<a href=\"MEKINFO" + m.getMekFile() + "#" + m.getBV() + "#" + m.getGunnery() + "#" + m.getPiloting() + "\">" + m.getName() + "(" + m.getGunnery();
                    if (!m.getSkills().equals(" ")) {
                        unitString = unitString + ", " + m.getSkills();
                    }
                    unitString = unitString + ")";
                    if (num > 1) {
                        unitString = num + " x " + unitString;
                    }
                    unitString = unitString + "</a>";
                    unitString = j < entities.length - 1 ? unitString + ", " : unitString + "<br>";
                    result = result + unitString;
                }
            }
        }
        this.mainPane.setText(result);
    }

    public void setInfoText(String s) {
        this.lblInfo.setText(s);
        if (s == null) {
            this.hsButtonSpringPanel.setVisible(true);
            this.lblInfo.setVisible(false);
        } else if (s.equals("")) {
            this.hsButtonSpringPanel.setVisible(true);
            this.lblInfo.setVisible(false);
        } else {
            if (this.lblInfo.getWidth() == 0 && this.lblInfo.getHeight() == 0) {
                Dimension newDim = new Dimension();
                newDim.setSize(this.lblInfo.getPreferredSize().getWidth(), this.hsButtonSpringPanel.getSize().getHeight());
                this.lblInfo.setMinimumSize(newDim);
            }
            this.hsButtonSpringPanel.setVisible(false);
            this.lblInfo.setVisible(true);
        }
    }

    public void showInfoWindow(String MekFile, int BV, int Gunnery, int Piloting) {
        Entity UnitEntity = null;
        try {
            MechSummary ms = MechSummaryCache.getInstance().getMech(MekFile);
            UnitEntity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
        }
        catch (Exception exep) {
            try {
                MWClient.mwClientLog.clientErrLog("Error loading unit: " + MekFile + ". Try replacing with OMG.");
                UnitEntity = new MechFileParser(new File("./data/mechfiles/Meks.zip"), "Error OMG-UR-FD.hmp").getEntity();
            }
            catch (Exception exepe) {
                MWClient.mwClientLog.clientErrLog("Error unit failed to load. Exiting.");
                return;
            }
        }
        JFrame InfoWindow = new JFrame();
        MechDetailDisplay MechDetailInfo = new MechDetailDisplay();
        UnitEntity.loadAllWeapons();
        UnitEntity.setCrew(new Pilot("", Gunnery, Piloting));
        MechDetailInfo.displayEntity(UnitEntity, BV, this.mwclient.getConfig().getImage("CAMO"));
        InfoWindow.getContentPane().add(MechDetailInfo);
        InfoWindow.setSize(220, 400);
        InfoWindow.setResizable(false);
        InfoWindow.setTitle(UnitEntity.getModel());
        InfoWindow.setLocationRelativeTo(null);
        InfoWindow.setVisible(true);
    }

    private void buyNewButtonActionPerformed(ActionEvent e) {
    }

    private void buyUsedButtonActionPerformed(ActionEvent e) {
    }

    private void buyNewUnitMouseEvent(MouseEvent e) {
        JPopupMenu buy = this.createBuyNewPopupMenu();
        buy.show(e.getComponent(), e.getX(), e.getY());
    }

    private void buyUsedUnitMouseEvent(MouseEvent e) {
        JPopupMenu buy = this.createBuyUsedPopupMenu();
        buy.show(e.getComponent(), e.getX(), e.getY());
    }

    private JPopupMenu createBuyNewPopupMenu() {
        JPopupMenu buy = new JPopupMenu();
        JMenuItem menuItem = null;
        JMenu tmenu = new JMenu("Mek");
        buy.add(tmenu);
        menuItem = new JMenuItem("Light Mek");
        menuItem.setActionCommand("BUY|LIGHT|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Medium Mek");
        menuItem.setActionCommand("BUY|MEDIUM|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Heavy Mek");
        menuItem.setActionCommand("BUY|HEAVY|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Assault Mek");
        menuItem.setActionCommand("BUY|ASSAULT|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        if (Boolean.valueOf(this.mwclient.getserverConfigs("UseVehicle")).booleanValue()) {
            tmenu = new JMenu("Vehicle");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Vehicle");
            menuItem.setActionCommand("BUY|LIGHT|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Vehicle");
            menuItem.setActionCommand("BUY|MEDIUM|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Vehicle");
            menuItem.setActionCommand("BUY|HEAVY|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Vehicle");
            menuItem.setActionCommand("BUY|ASSAULT|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (Boolean.valueOf(this.mwclient.getserverConfigs("UseInfantry")).booleanValue()) {
            tmenu = new JMenu("Infantry");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Infantry");
            menuItem.setActionCommand("BUY|LIGHT|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Infantry");
            menuItem.setActionCommand("BUY|MEDIUM|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Infantry");
            menuItem.setActionCommand("BUY|HEAVY|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Infantry");
            menuItem.setActionCommand("BUY|ASSAULT|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (Boolean.valueOf(this.mwclient.getserverConfigs("UseProtoMek")).booleanValue()) {
            tmenu = new JMenu("ProtoMek");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light ProtoMek");
            menuItem.setActionCommand("BUY|LIGHT|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium ProtoMek");
            menuItem.setActionCommand("BUY|MEDIUM|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy ProtoMek");
            menuItem.setActionCommand("BUY|HEAVY|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault ProtoMek");
            menuItem.setActionCommand("BUY|ASSAULT|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (Boolean.valueOf(this.mwclient.getserverConfigs("UseBattleArmor")).booleanValue()) {
            tmenu = new JMenu("Battle Armor");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Battle Armor");
            menuItem.setActionCommand("BUY|LIGHT|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Battle Armor");
            menuItem.setActionCommand("BUY|MEDIUM|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Battle Armor");
            menuItem.setActionCommand("BUY|HEAVY|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Battle Armor");
            menuItem.setActionCommand("BUY|ASSAULT|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (new Boolean(this.mwclient.getserverConfigs("AllowPersonalPilotQueues")).booleanValue()) {
            tmenu = new JMenu("Pilots");
            buy.add(tmenu);
            JMenu smenu = new JMenu("Mek");
            menuItem = new JMenuItem("Light Pilot");
            menuItem.setActionCommand("BUYP|0|0");
            menuItem.addActionListener(this.myPopup);
            smenu.add(menuItem);
            menuItem = new JMenuItem("Medium Pilot");
            menuItem.setActionCommand("BUYP|0|1");
            menuItem.addActionListener(this.myPopup);
            smenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Pilot");
            menuItem.setActionCommand("BUYP|0|2");
            menuItem.addActionListener(this.myPopup);
            smenu.add(menuItem);
            menuItem = new JMenuItem("Assault Pilot");
            menuItem.setActionCommand("BUYP|0|3");
            menuItem.addActionListener(this.myPopup);
            smenu.add(menuItem);
            tmenu.add(smenu);
            if (new Boolean(this.mwclient.getserverConfigs("UseProtoMek")).booleanValue()) {
                smenu = new JMenu("Proto");
                menuItem = new JMenuItem("Light Pilot");
                menuItem.setActionCommand("BUYP|3|0");
                menuItem.addActionListener(this.myPopup);
                smenu.add(menuItem);
                menuItem = new JMenuItem("Medium Pilot");
                menuItem.setActionCommand("BUYP|3|1");
                menuItem.addActionListener(this.myPopup);
                smenu.add(menuItem);
                menuItem = new JMenuItem("Heavy Pilot");
                menuItem.setActionCommand("BUYP|3|2");
                menuItem.addActionListener(this.myPopup);
                smenu.add(menuItem);
                menuItem = new JMenuItem("Assault Pilot");
                menuItem.setActionCommand("BUYP|3|3");
                menuItem.addActionListener(this.myPopup);
                smenu.add(menuItem);
                tmenu.add(smenu);
            }
        }
        return buy;
    }

    private JPopupMenu createBuyUsedPopupMenu() {
        JPopupMenu buy = new JPopupMenu();
        JMenuItem menuItem = null;
        JMenu tmenu = new JMenu("Mek");
        buy.add(tmenu);
        menuItem = new JMenuItem("Light Mek");
        menuItem.setActionCommand("BUYU|LIGHT|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Medium Mek");
        menuItem.setActionCommand("BUYU|MEDIUM|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Heavy Mek");
        menuItem.setActionCommand("BUYU|HEAVY|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        menuItem = new JMenuItem("Assault Mek");
        menuItem.setActionCommand("BUYU|ASSAULT|0");
        menuItem.addActionListener(this.myPopup);
        tmenu.add(menuItem);
        if (new Boolean(this.mwclient.getserverConfigs("UseVehicle")).booleanValue()) {
            tmenu = new JMenu("Vehicle");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Vehicle");
            menuItem.setActionCommand("BUYU|LIGHT|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Vehicle");
            menuItem.setActionCommand("BUYU|MEDIUM|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Vehicle");
            menuItem.setActionCommand("BUYU|HEAVY|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Vehicle");
            menuItem.setActionCommand("BUYU|ASSAULT|1");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (new Boolean(this.mwclient.getserverConfigs("UseInfantry")).booleanValue()) {
            tmenu = new JMenu("Infantry");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Infantry");
            menuItem.setActionCommand("BUYU|LIGHT|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Infantry");
            menuItem.setActionCommand("BUYU|MEDIUM|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Infantry");
            menuItem.setActionCommand("BUYU|HEAVY|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Infantry");
            menuItem.setActionCommand("BUYU|ASSAULT|2");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (new Boolean(this.mwclient.getserverConfigs("UseProtoMek")).booleanValue()) {
            tmenu = new JMenu("ProtoMek");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light ProtoMek");
            menuItem.setActionCommand("BUYU|LIGHT|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Infantry");
            menuItem.setActionCommand("BUYU|MEDIUM|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Infantry");
            menuItem.setActionCommand("BUYU|HEAVY|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Infantry");
            menuItem.setActionCommand("BUYU|ASSAULT|3");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        if (new Boolean(this.mwclient.getserverConfigs("UseBattleArmor")).booleanValue()) {
            tmenu = new JMenu("Battle Armor");
            buy.add(tmenu);
            menuItem = new JMenuItem("Light Battle Armor");
            menuItem.setActionCommand("BUYU|LIGHT|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Medium Battle Armor");
            menuItem.setActionCommand("BUYU|MEDIUM|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Heavy Battle Armor");
            menuItem.setActionCommand("BUYU|HEAVY|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
            menuItem = new JMenuItem("Assault Battle Armor");
            menuItem.setActionCommand("BUYU|ASSAULT|4");
            menuItem.addActionListener(this.myPopup);
            tmenu.add(menuItem);
        }
        return buy;
    }

    private void updateClock() {
        this.btnRefresh.setText("Refresh  [Last: " + (System.currentTimeMillis() - this.lastUpdate) / 60000L + " min]");
    }

    private class TThread
    extends Thread {
        CHSPanel myPanel;

        public TThread(CHSPanel p) {
            this.myPanel = p;
        }

        public synchronized void run() {
            while (true) {
                this.myPanel.updateClock();
                try {
                    this.wait(60000L);
                    continue;
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                    continue;
                }
                break;
            }
        }
    }

    class BuyPopupListener
    extends MouseAdapter
    implements ActionListener {
        BuyPopupListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String s = actionEvent.getActionCommand();
            StringTokenizer st = new StringTokenizer(s, "|");
            String command = st.nextToken();
            if (command.equalsIgnoreCase("BUY")) {
                CHSPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c request#" + st.nextToken() + "#" + st.nextToken());
            } else if (command.equalsIgnoreCase("BUYU")) {
                CHSPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c requestdonated#" + st.nextToken() + "#" + st.nextToken());
            } else if (command.equalsIgnoreCase("BUYP")) {
                CHSPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c buypilotsfromhouse#" + st.nextToken() + "#" + st.nextToken());
            }
        }
    }
}

